import { Component, OnInit, OnDestroy } from '@angular/core';
import { Router } from '@angular/router';
import { Subscription } from 'rxjs/Subscription';

import { Message, MenuItem } from 'primeng/primeng';

import { AppService } from './../../app.service';
import { UtilsService } from './../../oneit/services/utils.service';
import { SaveService } from './../../oneit/services/save.service';
import { ListJobsService } from './list-jobs.service';


@Component({
    selector: 'app-list-jobs',
    templateUrl: './list-jobs.component.html'
})
export class ListJobsComponent implements OnInit, OnDestroy {
    
    subscriptions: Array<Subscription> = [];
    
    statuss: any[] = [];
    showLoader: boolean = false;
    
    constructor(
        private router: Router,
        private activatedRoute: ActivatedRoute,
        private utilsService: UtilsService,
        private saveService: SaveService,
        private appService: AppService,
        private listJobsService: ListJobsService
    ){
        
    }

    ngOnInit() {

        this.getStatuss();
    }
    

    getStatuss() {
        this.subscriptions.push(this.listJobsService.getstatuss([])
            .subscribe(
                data => {
                    this.statuss = data;
                },
                error => {
                    this.utilsService.handleError(error);
                }
            )
        );
    }
    
    ngOnDestroy(){
        this.utilsService.unsubscribeSubscriptions(this.subscriptions);
    }
}