<%@ page extends="oneit.servlets.jsp.JSPInclude" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>
<%@ page import="oneit.utils.text.FormatUtils" %>

<oneit:dynIncluded>
<%
    String          currentPage     =   WebUtils.getSamePageInRenderMode(request, "JobMatchAssessment");
    String          nextPage        =   WebUtils.getSamePageInRenderMode(request, "SubmitApplication");
    JobApplication  jobApplication  =   (JobApplication) process.getAttribute("JobApplication");
    Job             job             =   jobApplication.getJob();
    Candidate       candidate       =   jobApplication.getCandidate();
    int             questionNumber  =   process.getAttribute("QuestionNumber")!= null ? (int) process.getAttribute("QuestionNumber") : jobApplication.getQuestionNumber();
    int             actualNumber    =   process.getAttribute("ActualNumber")!= null ? (int) process.getAttribute("ActualNumber") : jobApplication.getActualQuestionNumber();
    List<Question>  totalQuestions  =   (List<Question>) process.getAttribute("TotalQuestions");
    List<Question>  allQuestions    =   (List<Question>) process.getAttribute("AllQuestions");
    String          exitPage        =   WebUtils.getArticleLink(request, transaction, WebUtils.APPLY_JOB, "Page") + "&id=" + job.getID() + "&key=" + job.getRandomKey();

    if(totalQuestions == null)
    {
        totalQuestions  =   job.getAllQuestions();
        
        process.setAttribute("TotalQuestions", totalQuestions);
    }

    if(allQuestions == null)
    {
        allQuestions    =   job.getAllLeftQuestions(totalQuestions);
        
        process.setAttribute("AllQuestions", allQuestions);
    }

    //to store current question number in history
    if(process.getAttribute("QuestionNumber")==null || process.getAttribute("ActualNumber")==null)
    {
        request.getSession().setAttribute ("historyQstNo", null);
        request.getSession().setAttribute ("historyActualNo", null);
    }
    
    if(request.getSession().getAttribute("historyQstNo")!=null && process.getAttribute("QuestionNumber")!= null)
    {
        if((int) process.getAttribute("QuestionNumber") <= (int) request.getSession().getAttribute("historyQstNo"))
        {
            questionNumber   =   (int) request.getSession().getAttribute("historyQstNo");
        }
    }
    
    if(request.getSession().getAttribute("historyActualNo")!=null && process.getAttribute("ActualNumber")!= null)
    {
        if((int) process.getAttribute("ActualNumber") <= (int) request.getSession().getAttribute("historyActualNo"))
        {
            actualNumber   =   (int) request.getSession().getAttribute("historyActualNo");
        }
    }
    
    request.getSession().setAttribute ("historyQstNo", questionNumber);
    request.getSession().setAttribute ("historyActualNo", actualNumber);
    
    boolean toRedirect  =   jobApplication.initAssessmentAnswers(allQuestions);
    
    if(toRedirect)
    {
        process.setAttribute("QuestionNumber", questionNumber);
        process.setAttribute("ActualNumber", actualNumber);

        %><%@include file="/saferedirect.jsp" %><%
    }

    Question        question        =   allQuestions.get(questionNumber);
    QuestionType    questionType    =   question.getQuestionType();
%>
    <script>
        $(document.body).addClass('bg-color');
        
        $(document).ready(function(){
            
            $(".answer_radio").change(function(){
                $(".ratting-number li.active").removeClass("active" );
                $(".ratting-number input[type='radio']:checked").closest('li').addClass("active" );
            });
        });
        
        function gotoNextQuestion()
        {
            $("#nextButton").click();
        }
    </script>
    
    <div class="main-application-outline">
        <div class="selection-aust-logo">
        <%
            BinaryContent   logo    =   job.getLogo();

            if(logo != null)
            {
                int logoHeight  =   45;
        %>
                <tagfile:img src="<%= ThumbnailUtils.filterImage(DiskFileBinaryContent.getRelativeURL(logo), "KEEP", new ScaleWithin (0, logoHeight)) %>" />
        <%
            }
        %>
            <span><oneit:toString value="<%= job.getJobTitle() %>"  mode="EscapeHTML"/></span>
            <div class="clearfix no-height"></div>
        </div>
        <div class="show-mobile-title">
            <div class="mobile-title-page">Your Work Style</div>
            <div class="mobile-estimated">Estimated time to complete: 
                <span class="estimated-time-20">&nbsp;20 mins</span>
            </div>
        </div>
        <div class="section-c-title m-hide">
            Your Work Style
            <span>Estimated time to complete: 
                <span class="estimated-time-20">&nbsp;20 mins</span>
            </span>
        </div>
        <div class="section-tab-view">
            
            <oneit:form name="editApplication"  method="post"   enctype="multipart/form-data">
            
                <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"           data="<%= CollectionUtils.EMPTY_MAP%>"/>
                
                <oneit:dynInclude   page="/extensions/applicantportal/inc/application_main_tabs.jsp"    PageNumber="3"  data="<%= CollectionUtils.EMPTY_MAP%>"/>

                <div class="section-page-area section-job-match">
                    <%
                        if(actualNumber == 1 )
                        {
                            int     maxRating   =   7;
                            int     midRating   =   4;
                            String  otherRating =   "2, 3, 5, 6";
                    %>
                            <div class="main-sc-section sj-1">
                                <p>Using the scale given, indicate how important to you are the following aspects in your work life. Use the following system:</p>
                                <ul class="security-level">
                                    <li><span>1</span> means of very little importance to you</li>
                                    <li><oneit:toString value="<%= midRating %>"  mode="EscapeHTML"/> means about average in importance to you</li>
                                    <li><oneit:toString value="<%= maxRating %>"  mode="EscapeHTML"/> means of high importance to you</li>
                                </ul>
                                <p>Use the other numbers (<oneit:toString value="<%= otherRating %>"    mode="EscapeHTML"/>) to indicate in-between levels of importance to you.</p>            
                            </div>
                            <div class="selection-br-line"></div>
                    <%
                        }
                        else if(questionType == QuestionType.IPSATIVE && actualNumber == 31)
                        {
                    %>
                            <div class="main-sc-section sj-1">
                                <p>
                                    For questions like these, indicate your preference by selecting the number closest to the term or idea that's most like you. We know that it can be challenging to make a choice sometimes, but try to avoid selecting the middle value.
                                </p>
                            </div>
                            <div class="selection-br-line"></div>
                    <%
                        }
                    %>
                    <div class="main-sc-section main-rate-section">
                    <%
                        FormTag     applicationForm     =   FormTag.getActiveFormTag(request);
                        FormBuilder formBuilder         =   applicationForm.getFormBuilder();
                        int         totNoOfQuestions    =   totalQuestions.size();

                        if(actualNumber <= totNoOfQuestions)
                        {
                            Answer          answer          =   jobApplication.getAnswerForQuestion(question);
                            String          optionKey       =   WebUtils.getInputKey(request, answer, Answer.FIELD_AnswerNo);
                            String          formValue       =   formBuilder.fieldValue (optionKey, answer.getAnswerNo() == null ? "" : String.valueOf(answer.getAnswerNo()));
                            String          numberText      =   actualNumber + "/" + totNoOfQuestions;

                            if(questionType == QuestionType.SCALAR)
                            {
                    %>    
                                <div class="rateing-title">
                                    Rate the importance of each item below
                                    <span><oneit:toString value="<%= numberText %>"   mode="EscapeHTML"/></span>
                                </div>
                                
                                <div class="rating-box-title">
                                    <oneit:toString value="<%= question.getDescription() %>"    mode="EscapeHTML"/>
                                </div>
                        <%
                            }
                            else
                            {
                        %>    
                                <div class="rateing-title">
                                    Select your preference on the scale below 
                                    <span><oneit:toString value="<%= numberText %>"   mode="EscapeHTML"/></span>
                                </div>
                        <%
                            }
                        %>
                            <div class="ratting-box">
                            <%
                                if(questionType == QuestionType.SCALAR)
                                {
                            %>
                                    <span>Very little importance</span>
                            <%
                                }
                                else
                                {
                            %>
                                    <span class="left-s-label"><div><%= FormatUtils.stringify(question.getDescription(), "EscapeHTML") %></div></span> <!-- toString tag not used due to styling issue with additional span tag -->
                            <%
                                }
                            %>
                                <ul class="pagination ratting-number">
                                <%
                                    for(int index=1; index <= (questionType == QuestionType.SCALAR ? 7 : 5); index++)
                                    {
                                        String  activeStr   = (CollectionUtils.equals(String.valueOf(index), formValue) ? "active " : "");
                                        String  selectedStr = (CollectionUtils.equals(String.valueOf(index), formValue) ? "checked" : "");
                                %>
                                        <li class="<%= activeStr +  ((questionType == QuestionType.SCALAR) ?  "scaler" : "ipsative")%>">
                                            <a href="javascript:void(0);">
                                                <input  type="radio"    name="<%= optionKey %>" id="<%= index %>"   onchange="gotoNextQuestion();"   class="answer_radio"    value="<%= answer.getFinalAnswerValue(index) %>" <%= selectedStr %>>
                                                <label  for="<%= index %>"><%= index %></label>
                                            </a>
                                        </li>
                                <%
                                    }
                                %>
                                </ul>
                            <%
                                if(questionType == QuestionType.SCALAR)
                                {
                            %>
                                    <span>High importance</span>
                            <%
                                }
                                else if(question.getRightQuestion() != null)
                                {
                            %>
                                    <span class="right-s-label"><div><%= FormatUtils.stringify(question.getRightQuestion().getDescription(), "EscapeHTML") %></div></span>
                            <%
                                }
                            %>
                            </div>
                            <div class="section-btn text-center">
                                <oneit:button   value="Save and exit"   name="saveAndExitWorkStyle" cssClass="box-btn-gray"
                                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", exitPage)
                                                                                    .mapEntry ("JobApplication", jobApplication)
                                                                                    .mapEntry(UpdateMappedObjFP.FAIL_VALIDATION_ERRORS, Boolean.FALSE)
                                                                                    .toMap() %>"/>
                                <%
                                    if(questionNumber + 1 < allQuestions.size())
                                    {
                                %>
                                        <oneit:button   value=" "    name="gotoPage"    id="nextButton"    skin="link"
                                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", currentPage)
                                                                                        .mapEntry("procParams", CollectionUtils.mapEntry("QuestionNumber", (questionNumber + 1)).mapEntry("ActualNumber", questionType == QuestionType.SCALAR ?  actualNumber + 1 : actualNumber + 2).toMap())
                                                                                        .toMap() %>"/>
                                <%
                                    }
                                    else
                                    {
                                %>

                                        <oneit:button   value=" "    name="completeApplication"  id="nextButton" skin="link" 
                                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                                            .mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).toMap())
                                                                                            .mapEntry("attribNamesToRestore", Collections.singleton("JobApplication"))
                                                                                            .mapEntry("restartProcess", Boolean.TRUE)
                                                                                            .toMap() %>"/>
                                <%
                                    }
                                %>
                            </div>
                    <%
                        }
                    %>
                        <div class="auto-save">
                            <%-- <div>Autosaved 1 min ago.</div> --%>
                        </div>
                    </div>                      
                </div>
            </oneit:form>
        </div>
    </div>
</oneit:dynIncluded>