package performa.utils;

import java.util.Map;
import java.util.regex.*;
import oneit.objstore.*;
import oneit.objstore.parser.BusinessObjectParser;
import oneit.objstore.validator.*;
import oneit.security.SecUser;


public class PerformaPasswordValidator extends AttributeValidator
{
    @Override
    public boolean validate (Map attribMetadata, BaseBusinessClass obj, String fieldName, Object newValue) throws Exception
    {
        String      newPwd  =   (String) newValue;
        Pattern     pattern =   Pattern.compile("([a-zA-Z0-9.@_!#$%&*]*)");
        Matcher     matcher =   pattern.matcher(newPwd);        

        BusinessObjectParser.assertFieldCondition(matcher.matches(), obj, SecUser.FIELD_Password, "PasswordPatternNotMatched");
        
        // Password must at least 8 characters
        BusinessObjectParser.assertFieldCondition(newPwd.length () >= 8, obj, SecUser.FIELD_Password, "PasswordLengthTooShort");
        
        // Password must be less than or equal 16 characters
        BusinessObjectParser.assertFieldCondition(newPwd.length () <= 16, obj, SecUser.FIELD_Password, "PasswordLengthTooLong");
               
        return true;
    } 
    
}
