<%@ page extends="oneit.servlets.jsp.FormJSP"%>
<%@ include file="/setuprequest.jsp"%>
<%@ include file="inc/stdimports.jsp"%>
<%@ include file="/editor/stdimports.jsp"%>

<%@ page import="oneit.servlets.jsp.ormtable.*" %>

<%! protected String getName (ServletConfig config) { return "customers_jsp"; } %>
    
<%
    ORMProcessState     process     =   (ORMProcessState) ProcessDecorator.getDefaultProcess(request);
    ObjectTransaction   objTran     =   process.getTransaction ();
    String              currentPage =   request.getContextPath() + "/extensions/performa/customers.jsp";
    SecUser             secUser     =   SecUser.getTXUser(objTran);
    UserSortOption      userSortOpt =   (UserSortOption) process.getAttribute("UserSortOption");
    SearchHiringTeam    searchHT    =   (SearchHiringTeam) RunSearchExecutorFP.setupExecutor(request, SearchHiringTeam.REFERENCE_SearchHiringTeam, true);
    HiringTeam[]        hiringTeams =   (HiringTeam[]) process.getAttribute("HiringTeams");

    if(hiringTeams == null)
    {
        hiringTeams =   (HiringTeam[]) searchHT.doSearch();
    }

    if (getData (request, GenericObjSearchDF.GENERIC_SEARCH_RESULTS) != null)
    {
        hiringTeams =   (HiringTeam[])getData (request, GenericObjSearchDF.GENERIC_SEARCH_RESULTS);
    }

    process.setAttribute("HiringTeams", hiringTeams);

    if( request.getParameter("UserSortOption") != null)
    {
        userSortOpt =   UserSortOption.forName((String) request.getParameter("UserSortOption"));
    }
    
    if(userSortOpt == null)
    {
        userSortOpt =   UserSortOption.ALPHA_A_Z;
    }
    
    process.setAttribute("UserSortOption", userSortOpt);

    Collection<HiringTeam> sortedHiringTeams    =   Utils.getHiringTeamsSorted(Arrays.asList(hiringTeams), userSortOpt);

    request.setAttribute("oneit.pageFormDetails", CollectionUtils.mapEntry("name", "Customers").mapEntry("enctype", "multipart/form-data").toMap());
    request.setAttribute("oneit.pageHeaderTitle", "Customers");
%>
    
<%@include file="/editor/header.jsp"%>
    <oneit:css>
        <oneit:css href="/css/common.css" />
        <oneit:css href="/css/jBox.css" />
    </oneit:css>
    <oneit:script>
        <oneit:script src="/scripts/jBox.js"/>
    </oneit:script>
    <style>
        .dashboard-content-area {
            margin-top: 0px ; 
            width: 100%; 
        }
        .change-company-btn{
            border: none;
            background: none;
            color: #4e5258; 
        }
    </style>

    <div class="dashboard-content-area second-part">
    <script type="text/javascript">
        var Popup = null;
        
        $(document).ready(function(){
        
            setupRecalc ($("form"), {'recalcOnError':true});
            $(".change-company-btn").prop('title', 'Change Customer');

            $(".htstatus").change(function() {
                $('.save').click();
            });
            
            $(".company-status").change(function() {
                $('.search-real-btn').click();
            });
        });
        
        $(function(){
            $('.search-icon-btn').click(function () {   
               $('.search-real-btn').click();
            });
        });
    </script>
            
        <div class="jobs-list-shorting">
            <div class="d-job-title all-jobs-title">Customers</div>
            <div class="shorting-dropdown relative-parent">
                <div class="order-label">Search Customers</div>
                <oneit:ormInput obj="<%= searchHT %>"    type="text" attributeName="Details"    cssClass="form-control search-input"    id="searchText" />
                <span class="search-icon-btn"></span>
            </div>
            <div class="shorting-dropdown relative-parent">
                <div class="order-label">Customer Status</div>
                <oneit:ormEnum  obj="<%= searchHT %>"   attributeName="CompanyStatus"   cssClass="form-control company-status"/>
            </div>
            <oneit:button value="Search" name="search" cssClass="btn btn-primary search-real-btn hidden"  />
            <oneit:button value=" " name="save" cssClass="btn save hidden"  requestAttribs="<%= CollectionUtils.mapEntry("nextPage", currentPage).toMap() %>"    id="save"/>
            <div class="shorting-dropdown">
                <span class="order-label">order by</span>
                <select class="form-control"    onChange="location=this.value">
                    <%
                        for (UserSortOption  sortOption : UserSortOption.getUserSortOptionArray())
                        {
                            String  optionLink  =    currentPage + "?UserSortOption=" + sortOption.getName() ;
                    %>
                            <option <%= (userSortOpt != null && userSortOpt == sortOption ? "selected" : "" )%>  value="<%= optionLink %>">
                                <oneit:toString value="<%= sortOption.getDescription() %>"   mode="EscapeHTML"/>
                            </option>
                    <%
                        }
                    %>
                </select>
            </div>
        </div>

        <div class="main-client-list">
        <%
            for(HiringTeam hiringTeam : sortedHiringTeams)
            {
                Job[]   filledJobs  =   Job.SearchByAll().andJobStatus(new EqualsFilter<>(JobStatus.FILLED))
                                                                .andHiringTeam(new EqualsFilter<>(hiringTeam))
                                                                .search(objTran);
                int     filledCount =   filledJobs != null ? filledJobs.length : 0;

                Job[]   openJobs    =   Job.SearchByAll().andJobStatus(new EqualsFilter<>(JobStatus.OPEN))
                                                                .andHiringTeam(new EqualsFilter<>(hiringTeam))
                                                                .search(objTran);
                int     openCount   =   openJobs != null ? openJobs.length : 0;
                int     clientCount =   hiringTeam.pipelineHiringTeam().toClients().uniqueVals().size();
        %>
                <div class="client-list">
                    <div class="client-row"  >
                        <div class="client-name-cell jl-c" style="width:25%;">
                            <div class="client-name">
                                    <oneit:toString value="<%= hiringTeam.getHiringTeamName() %>" mode="EscapeHTML" />
                            </div>
                        </div>
                    </div>
                    <div class="client-row company-details"  >
                        <div class="client-name-cell jl-c" style="width:20%;">
                            <div class="client-name">
                                <%= hiringTeam.getCompany().getCompanyName() %>
                                <tagfile:popup  actualJSP="<%= contextPath + "/extensions/performa/inc/changeCompanyPopup.jsp" %>"   id="<%= hiringTeam.getID().toString() %>"    
                                                displayValue="..."    cssClass="change-company-btn"  bypassValidate="false"   
                                                procVars="<%= CollectionUtils.mapEntry("HiringTeam", hiringTeam).toMap() %>"    width="800"    height="450" popupAction="#save"/>
                            </div>
                        </div>
                    </div>
                    <div class="<%= "application-count jl-c " + (clientCount == 0 ? "opaque-jobcount" : "")%>">
                        <oneit:toString value="<%= clientCount %>" mode="EscapeHTML"   nullValue="0"/>
                        <span class="grey-span">Clients</span>
                    </div>
                    <div class="<%= "application-count jl-c " + (openCount == 0 ? "opaque-jobcount" : "")%>">
                        <oneit:toString value="<%= openCount %>" mode="EscapeHTML"   nullValue="0"/>
                        <span class="grey-span">Open Jobs</span>
                    </div>
                    <div class="<%= "application-count jl-c " + (filledCount == 0 ? "opaque-jobcount" : "")%>">
                        <oneit:toString value="<%= filledCount %>" mode="EscapeHTML"   nullValue="0"/>
                        <span class="grey-span">Jobs Filled</span>
                    </div>
                    <div class="application-count jl-c"  style="width:12%;">
                        <oneit:ormEnum obj="<%= hiringTeam %>"   attributeName="HTStatus"    cssClass="form-control htstatus"/>
                    </div>
                    <%
                        if(hiringTeam.getHTStatus() == HTStatus.ACTIVE && hiringTeam.getCompany().getCompanyStatus() == CompanyStatus.ACTIVE)
                        {
                    %>
                            <div class="application-count jl-c"  style="width:13%;padding: 11px 6px 17px 20px;">
                                <oneit:button   value="Login as Admin" name="assume"  cssClass="btn btn-primary loginAsAdmin"
                                                requestAttribs="<%= CollectionUtils.mapEntry("HiringTeam", hiringTeam)
                                                                                    .toMap()%>"/>
                            </div>
                    <%
                        }
                    %>
                </div>
        <%
            }
        %>
        </div>
    </div>
<%@include file="/editor/footer.jsp"%>