import { Component, OnInit, ViewChild } from '@angular/core';
import { Subscription } from 'rxjs';
import { ActivatedRoute, Params, Router } from '@angular/router';
import { NgForm } from '@angular/forms';
import { FIELDS } from '../../constants';
import { SearchApplicantService } from '../search-applicants/search-applicants.service';
import { UtilsService } from '../../oneit/services/utils.service';
import { Candidate } from '../search-applicants/search-applicants.model';
import { SaveService } from '../../oneit/services/save.service';

@Component({
  selector: 'app-edit-applicant',
  templateUrl: './edit-applicant.component.html',
  styleUrls: ['./edit-applicant.component.css']
})
export class EditApplicantComponent implements OnInit {

    subscriptions: Array<Subscription> = [];
    @ViewChild('form') form: NgForm;

    saveDropdown = [{
        label : 'Save & Back', icon: 'ui-icon-refresh', command: () => { this.saveApplicants(false);}
    }]

    readonly    FIELDS                          =   FIELDS;

    applicant : Candidate = new Candidate();

    showLoader      : boolean = false;
    cols = [
        { field: 'Job.HiringTeam.Company.CompanyName',          header: 'Customer',           width: '33%',   noSort: false,    noFilter: false},
        { field: 'Job.HiringTeam.HiringTeamName',               header: 'Hiring Team',        width: '33%',   noSort: false,    noFilter: false},
        { field: 'Job.JobTitle',                                header: 'Job',                width: '33%',   noSort: false,    noFilter: false},
    ];

    constructor(private activatedRoute : ActivatedRoute,
        private SearchApplicantService : SearchApplicantService,
        private utilsService : UtilsService,
        private saveService : SaveService,
        private router : Router) { }

    ngOnInit() {
        this.subscriptions.push(this.activatedRoute.params
            .subscribe(
                (params: Params) => {
                    this.showLoader = true;
                    if (params.id && params.id !== '0') {
                        this.showLoader = false;
                        this.getApplicate(params.id);
                    }
                }
        ));
    }

    getApplicate(id) {
        this.SearchApplicantService.getApplicantByID(id, ['User', 'JobApplications', 'JobApplications.Job.HiringTeam.Company']).subscribe(data => {
            this.applicant = data;
            this.showLoader = false;
        }, error => {
            this.utilsService.handleError(error);
            this.showLoader = false;
        })
    }

    saveApplicants(reload) {
        this.utilsService.clearErrorMessages();
        if (this.form.invalid) {
            this.utilsService.showAllErrorMessages();
        } else {
            this.showLoader = true;
            let updatedObjs  = {};
            this.utilsService.addObjsToJSONByObjectID(updatedObjs, [this.applicant, this.applicant.User])
            this.subscriptions.push(this.saveService.saveObjectsWithDefaultSvc({}, updatedObjs, {})
                .subscribe(
                    data => {
                        this.utilsService.handleSuccess();
                        if (reload) {
                            let idToNavigate = this.applicant.ObjectID;
                            this.getApplicate(idToNavigate);
                        }
                        else {
                            this.router.navigate(["/search-applicant"]);
                        }
                        this.showLoader = false;
                    },
                    error => {
                        this.showLoader = false;
                        this.utilsService.handleError(error);
                    }
                )
            );
        }
    }
}
