package performa.form;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.objstore.ObjectTransaction;
import oneit.objstore.StorageException;
import oneit.objstore.parser.BusinessObjectParser;
import oneit.security.SecUser;
import oneit.servlets.forms.RedisplayResult;
import oneit.servlets.forms.SubmissionDetails;
import oneit.servlets.forms.SuccessfulResult;
import oneit.servlets.process.ORMProcessFormProcessor;
import oneit.servlets.process.ORMProcessState;
import oneit.utils.*;
import performa.orm.AssessmentCriteria;
import performa.orm.AssessmentCriteriaTemplate;
import performa.orm.CompanyUser;
import performa.orm.Job;
import performa.orm.WorkFlow;

/**
 *
 * @author nilu
 */
public class SaveRequirementsTemplateFP extends ORMProcessFormProcessor
{
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        final   HttpServletRequest  request     =   submission.getRequest();
        ObjectTransaction           objTran     =   process.getTransaction();
        Job                         job         =   (Job) request.getAttribute("Job");
        
        LogMgr.log(Job.LOG, LogLevel.PROCESSING1, "Inside SaveRequirementsTemplateFP for create new template.", job);
            
        objTran.runInNewTX((ObjectTransaction newObjTran) -> {
            
            AssessmentCriteriaTemplate newTemplate  =   AssessmentCriteriaTemplate.createAssessmentCriteriaTemplate(newObjTran);
            SecUser                     secUser     =   SecUser.getTXUser(newObjTran);
            CompanyUser                 companyUser =   secUser.getExtension(CompanyUser.REFERENCE_CompanyUser);
            
            newTemplate.setCompanyUser(companyUser);
            newTemplate.setTemplateName(job.getAssessmentTemplateName());
            newTemplate.setHiringTeam(job.getHiringTeam().getInTransaction(newObjTran));

            newTemplate.setJobTitle(job.getJobTitle());
            newTemplate.setReferenceNumber(job.getReferenceNumber());
            newTemplate.setJobDescription(job.getJobDescription());
            newTemplate.setJobOwner(job.getJobOwner().getInTransaction(newObjTran));
            newTemplate.setClient(job.getClient() != null ? job.getClient().getInTransaction(newObjTran) : null);
            
            newTemplate.setGoogleAddressText(job.getGoogleAddressText());
            newTemplate.setExpectedCandidateRadius(job.getExpectedCandidateRadius());
            newTemplate.setRemote(job.getRemote());
            
            newTemplate.setJobType(job.getJobType());
            newTemplate.setIndustry(job.getIndustry());
            newTemplate.setOccupation(job.getOccupation().getInTransaction(newObjTran));
            newTemplate.setRequireCV(job.getRequireCV());
            newTemplate.setAssessmentType(job.getAssessmentType());
            newTemplate.setLevel(job.getLevel().getInTransaction(newObjTran));
            
            for (WorkFlow workflow : job.getWorkFlowsSet())
            {
                WorkFlow    workflowCopy    =    WorkFlow.createWorkFlow(newObjTran);
            
                workflowCopy.copyAttributesFrom(workflow);

                newTemplate.addToWorkFlows(workflowCopy);
            }
            
            for (AssessmentCriteria criteria : job.getAssessmentCriteriasSet())
            {
                AssessmentCriteria criteriaCopy = AssessmentCriteria.createAssessmentCriteria(newObjTran);
            
                criteriaCopy.copyAttributesFrom(criteria);

                newTemplate.addToAssessmentCriterias(criteriaCopy);
            }
        });
        
        job.setAssessmentTemplateName(null);
        job.setSaveAssessmentTemplate(Boolean.FALSE);
        
        LogMgr.log(Job.LOG, LogLevel.PROCESSING1, "SaveRequirementsTemplateFP completed for create new template.", job);
        
        return RedisplayResult.getInstance();
    }

    @Override
    public void validate(ORMProcessState process, SubmissionDetails submission, MultiException exceptions, Map params) throws StorageException
    {
        HttpServletRequest  request =   submission.getRequest();
        Job                 job     =   (Job) request.getAttribute("Job");
        
        BusinessObjectParser.assertFieldCondition(job.getAssessmentTemplateName() != null, job , Job.FIELD_AssessmentTemplateName, "mandatory", exceptions, true, request);

        for(AssessmentCriteria criteria: job.getAssessmentCriteriasSet())
        {
            BusinessObjectParser.assertFieldCondition(criteria.getName() != null, criteria , AssessmentCriteria.FIELD_Name, "mandatory", exceptions, true, request);
        }
        
        super.validate(process, submission, exceptions, params);
    }
}