package performa.form;

import java.util.Map;
import oneit.logging.*;
import oneit.objstore.StorageException;
import oneit.objstore.parser.BusinessObjectParser;
import oneit.security.SecUser;
import oneit.servlets.forms.*;
import oneit.servlets.process.*;
import oneit.utils.*;
import performa.orm.Candidate;
import performa.orm.CompanyUser;
import performa.utils.Utils;
 

public class ResetPasswordFP extends ORMProcessFormProcessor
{
    private static final    LoggingArea LOG =   LoggingArea.createLoggingArea("ResetPasswordFP");
    
    
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        SecUser     user        =   (SecUser) process.getAttribute("SecUser");
        CompanyUser companyUser =   user.getExtension(CompanyUser.REFERENCE_CompanyUser);
        Candidate   candidate   =   user.getExtension(Candidate.REFERENCE_Candidate);
        
        LogMgr.log(LOG, LogLevel.PROCESSING1, "Inside ResetPasswordFP user:", user," companyUser:", companyUser, " candidate:", candidate);
        
        if(companyUser != null)
        {
            companyUser.setForgotPasswordKey(null);
        }
        else if (candidate != null)
        {
            candidate.setForgotPasswordKey(null);
        }
        return Utils.processSuccessfulLogin(process, submission, params, user);
    }
    
    
    @Override
    public void validate(ORMProcessState process, SubmissionDetails submission, MultiException exceptions, Map params) throws StorageException
    {
        super.validate(process, submission, exceptions, params);
        
        SecUser user = (SecUser) process.getAttribute("SecUser");
        
        Debug.assertion(user != null, "No user found for rest password. Call from " + getClass().getName());
        
        BusinessObjectParser.assertFieldCondition(user.getPassword().length() >= 8, user, SecUser.FIELD_Password, exceptions, true, submission.getRequest());
    }
}