import { Component, OnInit, OnDestroy } from '@angular/core';
import { Router } from '@angular/router';
import { Subscription } from 'rxjs/Subscription';

import { Message, MenuItem } from 'primeng/primeng';

import { AppService } from './../../app.service';
import { UtilsService } from './../../oneit/services/utils.service';
import { SaveService } from './../../oneit/services/save.service';
import { GlobalHiringTeamEditMessageTemplatesService } from './global-hiring-team-edit-message-templates.service';


@Component({
    selector: 'app-global-hiring-team-edit-message-templates',
    templateUrl: './global-hiring-team-edit-message-templates.component.html'
})
export class GlobalHiringTeamEditMessageTemplatesComponent implements OnInit, OnDestroy {
    
    subscriptions: Array<Subscription> = [];
    
    messageTemplateTypes: any[] = [];
    showLoader: boolean = false;
    
    constructor(
        private router: Router,
        private activatedRoute: ActivatedRoute,
        private utilsService: UtilsService,
        private saveService: SaveService,
        private appService: AppService,
        private globalHiringTeamEditMessageTemplatesService: GlobalHiringTeamEditMessageTemplatesService
    ){
        
    }

    ngOnInit() {

        this.getMessageTemplateTypes();
    }
    

    getMessageTemplateTypes() {
        this.subscriptions.push(this.globalHiringTeamEditMessageTemplatesService.getMessageTemplateTypes([])
            .subscribe(
                data => {
                    this.messageTemplateTypes = data;
                },
                error => {
                    this.utilsService.handleError(error);
                }
            )
        );
    }
    
    ngOnDestroy(){
        this.utilsService.unsubscribeSubscriptions(this.subscriptions);
    }
}