<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>
 
<oneit:dynIncluded>
<%
    boolean                     toRedirect  =   GenericObjDF.getOrCreateObject (request, "AssessmentCriteriaTemplate", AssessmentCriteriaTemplate.REFERENCE_AssessmentCriteriaTemplate);
    AssessmentCriteriaTemplate  template    =   (AssessmentCriteriaTemplate) process.getAttribute("AssessmentCriteriaTemplate");
    String                      nextPage    =   WebUtils.getSamePageInRenderMode(request, "Page");
    String                      samePage    =   WebUtils.getSamePageInRenderMode(request, WebUtils.EDIT_JOB_TEMP);

    Debug.assertion(template != null && !toRedirect, "Invalid template in job templates");

%>
    <script type="text/javascript">
        var lastclickedOccid = 0 , lastclickedOcc = "" ;
        var occPopup;
        var occlistObj = {"level0" : null , "level1" : null , "level2" : null , "level3" : null };
        var scrolldiv = null ;
        $(document).ready(function() 
        {
            setupRecalc ($("form#editJobTemplate"), {'recalcOnError':true});

            $("select[name$='JobTemplate']").change(function()
            {
                $("button[name$='loadJobFromTemplate']").click();
            });
            
            if ($("#select-occupation-id").val()) {
               lastclickedOccid =  $("#select-occupation-id").val();
            }else {
                lastclickedOccid = 0 ;
            }

            var popup_width = 1040;
            
            occPopup = new jBox('Modal', {
                id : "occupation-list",
                attach: '.select-occupation',
                title: 'Select the occupation classification for this job',
                content : $("#occupation_content"),overlay : true,
                closeButton: "title",
                minWidth : popup_width, height : 500,
                onCreated : function(){
                    $(".dyn-div").empty();
                    $(".occupation_content_column").css("width", popup_width/4 );
                },
                onOpen : function(){
                    $(".dyn-div").empty();
                    $('.occupation_content_column ul li').removeClass("clicked");
                    $(".occupation_select_info").css("width","75%");
                     if (scrolldiv===null) scrolldiv = '.main-list-div';
                    if(lastclickedOccid!==0){
                        var  currEle = $(".main-list-div").find("li[data-id='"+ lastclickedOccid +"']");
                        occlistObj[currEle.parent('ul').attr("class")] = lastclickedOccid ;
                        checkParents(currEle);
                        for (i = 0; i < 4; i++) {
                            if (occlistObj["level"+i] ){
                                popuplateSelectLists  ($(".main-list-div").find("li[data-id='"+ occlistObj["level"+i] +"']"));
                                $(".level"+i+"-div").find("li").removeClass("clicked");
                                $(".level"+i+"-div").find("li[data-id='"+ occlistObj["level"+i] +"']").addClass("clicked");
                                occlistObj["level"+i] = null ;
                            }
                        }
                    }
                }
            });
            
            $(document).on("click",".occupation_content_column ul li",function(){
                popuplateSelectLists($(this));               
            });
            
            $("#save-job-occ").on("click",function(){
                if(lastclickedOccid!==0){
                    occPopup.close();
                }
            });
            
            $(document).on('mousewheel', function(e){
                if(scrolldiv!==null){
                    var target = $( scrolldiv);
                    if(e.originalEvent.wheelDelta /120 > 0) {
                        target.scrollTop(target.scrollTop() + 10);
                    }
                    else{
                        target.scrollTop(target.scrollTop() - 10);
                    }
                }
            });
                
            $(".create-job").find('input,select,textarea').each( function (i) 
            {
                if($(this).hasClass('type_radio'))
                {
                    $(this).next('label').attr('tabindex', i + 1); 
                }
                else if($(this).hasClass('level_radio'))
                {
                    $(this).parent('a').attr('tabindex', i + 1); 
                }
                else if($(this).hasClass('last-workflow'))
                {
                    $(this).attr('tabindex', i + 5); 
                }
                else
                {
                    $(this).attr('tabindex', i + 1); 
                }
            });
                
            var currFocusSelect2;
            
            $(document).on('focus', '.select2.select2-container', function (e) {
            // only open on original attempt - close focus event should not fire open
                if (e.originalEvent && $(this).find(".select2-selection--single").length > 0) {
                    currFocusSelect2 = $(this).siblings('select').on("select2-blur", function(e) { log ("blur");});;
                    currFocusSelect2.select2('open');
                } 
            });
                  
            $(document).on('keyup', '.select2.select2-container', function (e) {
                      
                if(!$(this).hasClass('select2-container--open')){
                    nexttab = parseInt($(this).siblings('select').attr('tabindex')) + 1 ;
                    $('[tabindex=' + nexttab + ']').focus();
                }
            });
                  
            $('input[type="text"][id$="Industry"]').blur(function(){
                if($(this).next().val() === ""){
                   $(this).val('');
                }
            });
                
            $('input[type="text"][id$="Industry"]').attr('placeholder','Please select an Industry');
        });
        
      
        function checkParents(currEle){
            newCurrEle = currEle.parent('ul').parent("li");
            if (newCurrEle.length){               
                occlistObj[newCurrEle.parent("ul").attr("class")] = newCurrEle.data("id") ;
                checkParents(newCurrEle);
            } else {
                return false;
            }
        }
        
        function popuplateSelectLists(thisEle){
           
            lastclickedOccid = thisEle.data('id');
            lastclickedOcc = thisEle.data('occ');
                
            $(".select-occupation").val(lastclickedOcc);
            $("#select-occupation-id").val(lastclickedOccid);
                
            thisEle.siblings('li').removeClass("clicked");
            thisEle.addClass("clicked");

            if( !thisEle.parent().hasClass("level3")) {
                $(".occupation_select_info").show();
                var nextUl = thisEle.find('ul').first().clone();

                $("." + nextUl.attr('class') + "-div").empty();
                $("." + nextUl.attr('class') + "-div").nextAll().empty();
                var nextDiv = $("." + nextUl.attr('class') + "-div");
                
            
                if(nextUl) {
                    nextUl.appendTo(nextDiv);
                }
                
                if(nextDiv.hasScrollBar()){
                    scrolldiv = "." + nextUl.attr('class') + "-div";
                }else{
                    scrolldiv = '.main-list-div';
                }
              

                if(thisEle.parent().hasClass("level2")) {
                    $(".occupation_select_info").hide();
                } else {
                    if( thisEle.hasClass("main-item")) {
                        $(".occupation_select_info").css("width","50%").show();
                    } else {
                        if( thisEle.parent().hasClass("level1")) {
                            $(".occupation_select_info").css("width","25%").show();
                        }
                    }
                }
            }
        }
        
        function addWorkflow() 
        {
            ajaxProcessAddJQ ("<%= request.getContextPath() %>/extensions/adminportal/inc/workflow_add.jsp", "#middle-workflows", {}, function (theHTML_JQ) {
                $("#middle-workflows").append (theHTML_JQ);
                
                $("#middle-workflows").find('input').each( function () 
                {
                   $(this).attr('tabindex', 26);  
                });
            });
            
        }
        
        function deleteWorkflow(deleteVarKey)
        {
            ajaxProcessDeleteJQ("<%= request.getContextPath() %>/genericDelete_AJAX.jsp", "#middle-workflows" , { varKey: deleteVarKey });
            return false;
        }
        
        
        function addCriteria(criteria) 
        {
            var divID = "#" + criteria;
            
            ajaxProcessAddJQ ("<%= request.getContextPath() %>/extensions/adminportal/inc/job_assessment_criteria_add.jsp", divID, {'CriteriaName' : criteria}, function (theHTML_JQ) {
                $(divID + "> #assessmentCriteriaSection").append (theHTML_JQ);
            });
        }
        
        function deleteCriteria(deleteVarKey)
        {
            ajaxProcessDeleteJQ("<%= request.getContextPath() %>/genericDelete_AJAX.jsp", "#assessmentCriteriaSection" , { varKey: deleteVarKey });
            return false;
        }
        
        (function($) {
            $.fn.hasScrollBar = function() {
                return this.get(0).scrollHeight > this.height();
            }
        })(jQuery);  

    </script>  
    <script src="https://maps.googleapis.com/maps/api/js?v=3.exp&libraries=places&key=AIzaSyCaBh-MsMb8BBYJD_NcFzoCmygQbt5-QSw"></script>
    <oneit:script>
        <oneit:script src="/scripts/google_address.js"/>
    </oneit:script>
    
    <oneit:form name="editJobTemplate" method="post"    enctype="multipart/form-data">
        
        <h1 class="page-title page-title-with-arrow edit-template">
            <oneit:button cssClass="arrow-btn-blue"  name="gotoPage" value=" " skin="link"
                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)         
                                                            .mapEntry("cancelProcess", true)
                                                            .toMap() %>">
                <img src="images/arrow-left-prev_blue.svg" />
            </oneit:button>
            View/Edit Job Template
        </h1>
        <div class="form-group row box-border">
            <div class="col-md-1">
                <label><oneit:label GUIName="Title" /></label>
            </div>
            <div class="col-md-11">
                <oneit:ormInput obj="<%= template %>"    type="text" attributeName="TemplateName"    cssClass="form-control" />
            </div>
        </div>
        <div class="container-fluid">
            <div class="main-tab-template">
                <span class="tab-number">1</span>
                <span class="job-details">Job Details</span>
            </div>
            <div class="form-page-area nopadding">
                <div class="create-job"> 
                    <div class="form-page-section">
                        <div class="form-group row">
                            <div class="col-md-8">
                                <label><oneit:label GUIName="Job Title" /></label>
                                <oneit:ormInput obj="<%= template %>"    type="text" attributeName="JobTitle"    cssClass="form-control" />                                
                            </div>
                            <div class="col-md-4">
                                <label><oneit:label GUIName="Reference Number" /><a href="#" title="Uniquely identify jobs that have identical titles. Examlple:<br>&#8226; New Home Sales Consutant (ABC123)<br>&#8226;  New Home Sales Consutant (ABC456)" class="info-icon"><img src="images/info-icon.png" /></a></label>
                                <oneit:ormInput obj="<%= template %>"   type="text" attributeName="ReferenceNumber" cssClass="form-control" />
                            </div>
                        </div>
                        <div class="form-group row">
                            <div class="col-md-12">
                                <label><oneit:label GUIName="About the Job" /></label>
                                <oneit:ormtextarea  obj="<%= template %>"     attributeName="JobDescription"  cssClass="form-control textarea-box"/>
                            </div>
                        </div>
                        <div class="form-group row">
                            <div class="col-md-6">
                                <label><oneit:label GUIName="Job Owner"/></label>
                                <div class="wider-select">
                                    <tagfile:ormsingleasso_select obj="<%= template %>"    assocName="JobOwner"    options="<%= template.getHiringTeam().getActiveTeammates().toArray(new CompanyUser[0]) %>"/>
                                </div>
                            </div>
                            <%
                                if(template.getHiringTeam().showHasClientSupport())
                                {
                            %>
                                    <div class="col-sm-6 col-xs-12">
                                        <label><oneit:label GUIName="Client "/><span>(Optional)</span></label>
                                        <div class="wider-select">
                                            <tagfile:ormsingleasso_select obj="<%= template %>"   assocName="Client"  options="<%= Utils.getClientsByHiringTeam(transaction) %>"/>
                                        </div> 
                                    </div>
                            <%
                                }
                            %>
                        </div>
                    </div>
                    <div class="form-page-section darkbg">
                        <div class="form-group row">
                            <div class="col-md-12">
                                <label class="label-16">Job Location</label>                
                            </div>
                        </div>
                        <div class="form-group row">
                            <div class="col-md-8">
                                <label><oneit:label GUIName="Google Location"/></label>
                                <oneit:ormInput obj="<%= template %>" type="text"  attributeName="GoogleAddressText" class="autoAddress" id="<%= "gAddress_"+template.getObjectID() %>" placeholder="Enter your address" cssClass="form-control" />
                            </div>
                            <div class="col-md-4">
                                <label><oneit:label GUIName="Expected Candidate Radius"/></label>
                                <oneit:ormEnum  obj="<%= template %>"  attributeName="ExpectedCandidateRadius" cssClass="form-control"/>
                            </div>                
                        </div>
                        <div class="form-group row">
                            <div class="col-md-4">
                                <div class="styled_checkboxes">
                                    <div class="checkbox checkbox-primary">
                                        <oneit:ormInput obj="<%= template %>" id="is-remote"    attributeName="Remote"  type="checkbox"/>
                                        <oneit:recalcClass  htmlTag="span"  classScript="template.getRemote() != null && template.getRemote() ? 'checked': 'unchecked'"    template="<%= template %>">
                                            <label for="is-remote">
                                                <oneit:label GUIName="Working remotely is an option" />
                                            </label>
                                        </oneit:recalcClass>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-page-section"> 
                        <div class="form-group row">
                            <div class="col-md-12">
                                <label><oneit:label GUIName="Job Type" /></label>
                                <oneit:ormEnum  obj="<%= template %>"    attributeName="JobType" cssClass="form-control"/>
                            </div>
                        </div>
                        <div class="form-group row">
                            <div class="col-md-6">
                                <label><oneit:label GUIName="Industry Classification" /></label>
                                <oneit:ormEnum  obj="<%= template %>"     attributeName="Industry"    cssClass="form-control"    displayType="autocomplete"/>
                            </div>
                            <div class="col-md-6">
                                <label><oneit:label GUIName="Job Occupation Classification" /></label>
                                <input type="text" class="form-control select-occupation search-input " placeholder="Select the occupation classification"
                                       value="<%= template.getOccupation() != null ? template.getOccupation() : "Select the occupation classification"%>"></input>
                                <oneit:ormInput obj="<%= template %>"  id="select-occupation-id"    attributeName="OccupationId" type="hidden"/>
                            </div>
                        </div>
                        <div class="form-group row">
                            <div class="col-md-12">
                                <div class="styled_checkboxes">
                                    <div class="checkbox checkbox-primary">
                                        <oneit:ormInput obj="<%= template %>"  id="require-cv"    attributeName="RequireCV"  type="checkbox"/>
                                        <oneit:recalcClass  htmlTag="span"  classScript="template.getRequireCV() != null && template.getRequireCV() ? 'checked': 'unchecked'"    template="<%= template %>">
                                            <label for="require-cv">
                                                <oneit:label GUIName="Require CV and Cover Letter from Candidate" />
                                            </label>
                                        </oneit:recalcClass>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group row">
                            <div class="col-md-12">
                                <label class="label-16">Select your assessment type</label>                
                            </div>
                        </div>
                <%
                    FormTag     jobForm             =   FormTag.getActiveFormTag(request);
                    FormBuilder formBuilder         =   jobForm.getFormBuilder();
                    String      assessmentTypeKey   =   WebUtils.getInputKey(request, template, AssessmentCriteriaTemplate.FIELD_AssessmentType);
                    String      assessmentTypeValue =   formBuilder.fieldValue (assessmentTypeKey, template.getAssessmentType() == null ? "" : template.getAssessmentType().getName());

                    for(AssessmentType assessmentType : AssessmentType.getAssessmentTypeArray())
                    {
                        String  assessmentTypeId    =   assessmentType.getName();
                        String  selectedStr         =   CollectionUtils.equals(assessmentTypeValue, assessmentTypeId) ? "checked" : "";

                        String  levelKey    =   WebUtils.getRadioSingleAssocKey(request, template, AssessmentCriteriaTemplate.SINGLEREFERENCE_Level);
                        String  levelValue  =   formBuilder.fieldValue (levelKey, template.getLevel() == null ? "" : String.valueOf(template.getLevelID()));
                %>
                        <div class="radio radio-primary job-match-radio">
                            <input type="radio" name="<%= assessmentTypeKey %>" id="<%= assessmentTypeId %>"     class="type_radio" value="<%= assessmentType.getName() %>" <%= selectedStr %>/>
                            <label for="<%= assessmentTypeId %>">
                                <span class="label-title"><oneit:toString value="<%= assessmentType %>" mode="EscapeHTML" /></span>
                                <oneit:toString value="<%= assessmentType.getQuestionDetails() %>"  mode="EscapeHTML"/><br />
                            </label>
                        </div>

                        <oneit:recalcClass  htmlTag="div"    classScript="template.getAssessmentType() == assessmentType ? 'main-pack-type' : '' "  template="<%= template %>"    assessmentType="<%= assessmentType %>">
                            <ul>
                            <%
                                for(Level level : Level.getAllLevelsforAssessmentType(transaction, assessmentType))
                                {
                                    String  levelId     =   String.valueOf(level.getID().longID());
                                    boolean isSelected  =   CollectionUtils.equals(levelId, levelValue);
                                    String  selected    =   isSelected ? "checked" : "";
                            %>
                                    <oneit:recalcClass  htmlTag="li"    classScript="template.getLevelClass(level)"  template="<%= template %>"    level="<%= level %>">
                                        <a href="javascript:void(0)">
                                            <input type="radio" name="<%= levelKey %>" id="<%= levelId %>"  class="level_radio" value="<%= levelId %>" <%= selected %>/>
                                            <label for="<%= levelId %>">
                                                <span class="talen">Talentology</span>
                                                <span class="pack-type"><oneit:toString value="<%= level %>"    mode="EscapeHTML" /></span>
                                                <span class="pack-img <%= level.getCSSClass() %>"></span>
                                            </label>
                                        </a>
                                    </oneit:recalcClass>
                            <%
                                }
                            %>
                            </ul>
                        </oneit:recalcClass>
                        <div class="clearfix"></div>           
                <%
                    }

                    String  levelKey    =   WebUtils.getRadioSingleAssocKey(request, template, AssessmentCriteriaTemplate.SINGLEREFERENCE_Level);
                    String  levelValue  =   formBuilder.fieldValue (levelKey, template.getLevel() == null ? "" : String.valueOf(template.getLevelID()));
                %>
                    </div>
                    <div class="form-page-section darkbg">
                        <div class="form-group row">
                            <div class="col-md-12">
                                <label class="label-16">Applicant Workflow</label>                
                            </div>
                        </div>
                        <div class="form-group row">
                            <div class="col-md-12">
                                Please define your applicant approval/refinement workflow and tabs below. We have nominated some defaults to help you get started. You are allowed up to 9 different steps, and can drag to re-order using the handle on the left.
                            </div>
                        </div>
                        <div id="workflows">
                            <div>
                            <%
                                WorkFlow firstWorkflow  =   template.getWorkFlowBySortOrder(1);
                            %>
                                <div class="form-group row">
                                    <div class="col-md-12">
                                        <div class="workflow-row">
                                            <span><%= firstWorkflow.getSortOrder() %></span>
                                            <oneit:ormInput obj="<%= firstWorkflow %>"    type="text" attributeName="Name"    cssClass="form-control" /> 
                                        </div>
                                        <div class="seperator-dots"><span class="dot"></span><span class="dot"></span><span class="dot"></span></div>
                                    </div>
                                </div>
                            </div>
                            <div id="middle-workflows">
                                <%
                                    List<WorkFlow>  sortedWorkflows =   template.getSortedMiddleWorkFlows();
                                    int             index           =   0;
                                    for (WorkFlow workflow : sortedWorkflows)
                                    {
                                        index++;
                                %>

                                        <div class="form-group row" id="<%= workflow.getID() %>">
                                            <div class="col-md-12">
                                                <div class="workflow-row">
                                                    <span><%= workflow.getSortOrder() %></span>
                                                    <oneit:ormInput obj="<%= workflow %>"    type="text" attributeName="Name"    cssClass="form-control" /> 
                                                    <%
                                                        if(workflow.getApplicationStatus() != ApplicationStatus.SUBMITTED && workflow.getApplicationStatus() != ApplicationStatus.SHORTLISTED)
                                                        {
                                                            String      deleteVarKey    =   FormTag.getVariableKey (request);

                                                            FormTag.setVariable (request, deleteVarKey, "objToDelete", workflow);
                                                            FormTag.setVariable (request, deleteVarKey, "jqToDelete", "#" + workflow.getID());          
                                                    %>
                                                            <div class="remove-icon" onclick="return deleteWorkflow (<%= deleteVarKey %>)">_</div>
                                                    <%
                                                        }
                                                    %>
                                                </div>
                                            </div>
                                        </div>
                                <%
                                    }
                                %>
                            </div>
                            <div>
                            <%
                                WorkFlow lastWorkflow  =   template.getWorkFlowBySortOrder(9);
                            %>
                                <div class="form-group row">
                                    <div class="col-md-12">
                                        <div class="seperator-dots"><span class="dot"></span><span class="dot"></span><span class="dot"></span></div>
                                        <div class="workflow-row">
                                            <span><%= lastWorkflow.getSortOrder() %></span>
                                            <oneit:ormInput obj="<%= lastWorkflow %>"    type="text" attributeName="Name"    cssClass="form-control last-workflow" /> 
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group row" style="text-align: center;" >
                            <a href="#" class="add-more-btn review-edit-btn" onclick="<%="addWorkflow(); return false;"%>"  tabindex="32">Add Workflow Step</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
                    
        <div class="occupation_content" id="occupation_content" style="display: none;">
            <div  class="occupation_content_row">
                <div id="scrollme" class="main-list-div occupation_content_column">
                    <ul class="level0">
                    <%
                        Occupation[]    firstLevelOccupations   =   Occupation.SearchByAll()
                                                                                .andLevel(new EqualsFilter<>(OccupationLevel.LEVEL_1))
                                                                                .search(transaction);
                        for (Occupation firstLevel : firstLevelOccupations)
                        {
                    %>
                            <li class="main-item" data-id="<%= firstLevel.getObjectID()%>" data-occ="<%= firstLevel%>">
                                <span> <%= firstLevel%> </span>
                                <ul class="level1">
                                <%
                                    for (Occupation secondLevel : firstLevel.getChildOccupationsSet())
                                    {
                                %>
                                        <li data-id="<%= secondLevel.getObjectID()%>" data-occ="<%= secondLevel%>">
                                            <span> <%= secondLevel%></span>
                                            <ul class="level2">
                                            <%
                                                for (Occupation thirdLevel : secondLevel.getChildOccupationsSet())
                                                {
                                            %>
                                                    <li data-id="<%= thirdLevel.getObjectID()%>" data-occ="<%= thirdLevel%>">
                                                        <span>  <%= thirdLevel%></span>
                                                        <ul class="level3">
                                                        <%
                                                            for (Occupation  fourthLevel : thirdLevel.getChildOccupationsSet())
                                                            {
                                                        %>
                                                                <li data-id="<%= fourthLevel.getObjectID()%>" data-occ="<%= fourthLevel%>">
                                                                    <span>  <%= fourthLevel%></span>
                                                                </li>
                                                        <%
                                                            }
                                                        %>
                                                        </ul>
                                                    </li>
                                            <%
                                                }
                                            %>
                                            </ul>
                                        </li>
                                <%
                                    }
                                %>
                                </ul>
                            </li>
                    <%
                        }
                    %>
                    </ul>
                </div>
                <div class="level1-div occupation_content_column dyn-div"></div>

                <div class="level2-div occupation_content_column dyn-div"></div>

                <div class="level3-div occupation_content_column dyn-div"></div>
            </div>
            <div class="occupation_select_info">
                Select the most appropriate Category to help narrow down your Occupation
            </div>
            <div class="occupation_select_button">
                <button type="button" value="Save Job Occupation" id="save-job-occ" class="btn btn-primary largeBtn" style="" >Save Job Occupation</button>
            </div>
        </div>
                    
        <div class="container-fluid">
            <div class="main-tab-template">
                <span class="tab-number">2</span>
                <span class="job-details">Requirements</span>
            </div>
            <div class="form-page-area nopadding">
                <div class="create-job">
                    <div class="form-page-section">
                        <div class="form-group">
                            <label>Include Requirements for this Job?</label>
                            <span class="pull-right">
                                <label class="switch">
                                    <oneit:recalcClass  htmlTag="span"  classScript="template.showAssessmentCriteriaSection() ? 'checkbox checked': 'checkbox unchecked'"    template="<%= template %>">
                                        <oneit:ormInput obj="<%= template %>"    attributeName="IncludeAssessmentCriteria"   type="checkbox"/>
                                    </oneit:recalcClass>
                                    <div class="slider round"></div>
                                </label>
                                <oneit:button   value=" "    name="changeAssessmentCriteria"    cssClass="hide"
                                                requestAttribs="<%= CollectionUtils.mapEntry ("AssessmentCriteriaTemplate", template)
                                                                                .mapEntry (UpdateMappedObjFP.FAIL_VALIDATION_ERRORS, Boolean.FALSE)
                                                                                .toMap() %>" />
                            </span>
                        </div>

                        <oneit:recalcClass  htmlTag="div"   classScript="template.showAssessmentCriteriaSection() ? 'show': 'hide'"  template="<%= template %>">

                        <div class="warning-box">
                            Requirements marked as Essential will be mandatory for any applicant applying for this job
                        </div>

                            <div class="form-brack-line-sub"></div> 
                        <%  
                            int criteriaCount   =   0;

                            for(CriteriaType criteria : CriteriaType.getCriteriaTypeArray())
                            {
                                String  name    =   criteria.getName();

                                criteriaCount++;
                        %>
                                <div class="form-group">
                                    <div class="form-group"  id="<%= name%>">
                                        <div class="form-medium-title qualification-title">

                                            <oneit:toString value="<%= criteria %>" mode="EscapeHTML"/>

                                            <span class="skill-label">

                                                <oneit:recalcClass htmlTag="span"   class="skill-label" classScript="template.getAssessmentCriteraCountByType(criteria) > 0 ? 'show': 'hide'" template="<%= template %>"    criteria="<%= criteria %>">
                                                    <oneit:recalc   script="template.getAssessmentCriteraCountByType(criteria)"  mode="EscapeHTML"   template="<%= template %>"    criteria="<%= criteria %>" />
                                                    <oneit:toString value="<%= criteria %>" mode="EscapeHTML"/> added
                                                </oneit:recalcClass>

                                                <oneit:recalcClass htmlTag="span"   class="skill-label" classScript="template.getAssessmentCriteraCountByType(criteria) > 0 ? 'hide': 'show'" template="<%= template %>"    criteria="<%= criteria %>">
                                                    <span class="skill-label">No required <oneit:toString value="<%= criteria %>" mode="EscapeHTML"/><%= criteria.getIsSingular() ? " has" : " have"%> been added.</span>
                                                </oneit:recalcClass>

                                            </span>
                                        </div>
                                        <div id="assessmentCriteriaSection">
                                        <%
                                            for (AssessmentCriteria assessmentCriteria : template.getAssessmentCriteraByType(criteria))
                                            {
                                        %>
                                                <oneit:dynInclude   page="/extensions/adminportal/inc/job_assessment_criteria_add.jsp"  AssessmentCriteria="<%= assessmentCriteria %>"
                                                                    data="<%= CollectionUtils.EMPTY_MAP%>"/>
                                        <%
                                            }
                                        %>
                                        </div>
                                    </div>
                                    <div class="main-add-more">
                                        <oneit:button   value="<%= "Add " + name%>"  name="newAssessmentCriteria"   cssClass="add-more-btn" skin="link"
                                                        onClick="<%="addCriteria('" + name + "'); return false;"%>"
                                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", samePage).toMap() %>"/>
                                    </div>
                                </div>
                        <%
                                if(criteriaCount < 4)
                                {
                        %>   
                                    <div class="form-brack-line-sub"></div>
                        <%
                                }
                            }
                        %>   
                        </oneit:recalcClass>
                    </div>
                </div>
            </div>            
        </div>            
                    
        <div class="text-center save-template">
            <oneit:button   value="Save Template"   name="save" cssClass="btn btn-primary top-margin-25 largeBtn"
                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                        .toMap() %>" />
            <div class="save-template-text">Saving this template will not affect any previously created or filled jobs</div>
        </div>
            
        <script>
            addGoogleAddressListener('#<%= "gAddress_"+ template.getObjectID() %>');
        </script>

    </oneit:form>
</oneit:dynIncluded>