/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import okio.-Platform;
import okio.-Util;
import okio.Buffer;
import okio.ByteString;
import okio.Segment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\r\n\u0002\u0010\u0005\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J\r\u0010\u001b\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\u001cJ\b\u0010\u001d\u001a\u00020\u0005H\u0016J\b\u0010\u001e\u001a\u00020\u0015H\u0016J\u0010\u0010\u001f\u001a\u00020\u00012\u0006\u0010 \u001a\u00020\u0001H\u0016J\u0010\u0010!\u001a\u00020\u00012\u0006\u0010 \u001a\u00020\u0001H\u0016J\u0010\u0010\"\u001a\u00020\u00012\u0006\u0010 \u001a\u00020\u0001H\u0016J\u0018\u0010#\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010$\u001a\u00020\u0005H\u0016J\r\u0010%\u001a\u00020\rH\u0010\u00a2\u0006\u0002\b&J\u0015\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b*J\u0018\u0010+\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010$\u001a\u00020\u0005H\u0016J\b\u0010,\u001a\u00020\u0001H\u0016J(\u0010-\u001a\u00020\u00182\u0006\u0010.\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010/\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J(\u0010-\u001a\u00020\u00182\u0006\u0010.\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00012\u0006\u0010/\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u00100\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u0005H\u0002J\b\u00101\u001a\u00020\u0001H\u0016J\b\u00102\u001a\u00020\u0001H\u0016J\b\u00103\u001a\u00020\u0001H\u0016J\u0010\u00104\u001a\u00020\u00152\u0006\u00105\u001a\u000206H\u0016J\u0018\u00107\u001a\u00020\u00012\u0006\u00108\u001a\u00020\u00052\u0006\u00109\u001a\u00020\u0005H\u0016J\b\u0010:\u001a\u00020\u0001H\u0016J\b\u0010;\u001a\u00020\u0001H\u0016J\b\u0010<\u001a\u00020\rH\u0016J\b\u0010=\u001a\u00020\u0001H\u0002J\b\u0010>\u001a\u00020\u0015H\u0016J\b\u0010?\u001a\u00020\u0015H\u0016J\u0010\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CH\u0016J\u0015\u0010@\u001a\u00020A2\u0006\u0010\u0002\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\bDJ\b\u0010E\u001a\u00020FH\u0002R\u0016\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8\u0006X\u0087\u0004\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006G"}, d2={"Lokio/SegmentedByteString;", "Lokio/ByteString;", "buffer", "Lokio/Buffer;", "byteCount", "", "(Lokio/Buffer;I)V", "directory", "", "getDirectory", "()[I", "segments", "", "", "getSegments", "()[[B", "[[B", "asByteBuffer", "Ljava/nio/ByteBuffer;", "kotlin.jvm.PlatformType", "base64", "", "base64Url", "equals", "", "other", "", "getSize", "getSize$jvm", "hashCode", "hex", "hmacSha1", "key", "hmacSha256", "hmacSha512", "indexOf", "fromIndex", "internalArray", "internalArray$jvm", "internalGet", "", "pos", "internalGet$jvm", "lastIndexOf", "md5", "rangeEquals", "offset", "otherOffset", "segment", "sha1", "sha256", "sha512", "string", "charset", "Ljava/nio/charset/Charset;", "substring", "beginIndex", "endIndex", "toAsciiLowercase", "toAsciiUppercase", "toByteArray", "toByteString", "toString", "utf8", "write", "", "out", "Ljava/io/OutputStream;", "write$jvm", "writeReplace", "Ljava/lang/Object;", "jvm"})
public final class SegmentedByteString
extends ByteString {
    @NotNull
    private final transient byte[][] segments;
    @NotNull
    private final transient int[] directory;

    @NotNull
    public final byte[][] getSegments() {
        return this.segments;
    }

    @NotNull
    public final int[] getDirectory() {
        return this.directory;
    }

    @Override
    @NotNull
    public String utf8() {
        return this.toByteString().utf8();
    }

    @Override
    @NotNull
    public String string(@NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        return this.toByteString().string(charset);
    }

    @Override
    @NotNull
    public String base64() {
        return this.toByteString().base64();
    }

    @Override
    @NotNull
    public String hex() {
        return this.toByteString().hex();
    }

    @Override
    @NotNull
    public ByteString toAsciiLowercase() {
        return this.toByteString().toAsciiLowercase();
    }

    @Override
    @NotNull
    public ByteString toAsciiUppercase() {
        return this.toByteString().toAsciiUppercase();
    }

    @Override
    @NotNull
    public ByteString md5() {
        return this.toByteString().md5();
    }

    @Override
    @NotNull
    public ByteString sha1() {
        return this.toByteString().sha1();
    }

    @Override
    @NotNull
    public ByteString sha256() {
        return this.toByteString().sha256();
    }

    @Override
    @NotNull
    public ByteString sha512() {
        return this.toByteString().sha512();
    }

    @Override
    @NotNull
    public ByteString hmacSha1(@NotNull ByteString key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.toByteString().hmacSha1(key);
    }

    @Override
    @NotNull
    public ByteString hmacSha256(@NotNull ByteString key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.toByteString().hmacSha256(key);
    }

    @Override
    @NotNull
    public ByteString hmacSha512(@NotNull ByteString key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.toByteString().hmacSha512(key);
    }

    @Override
    @NotNull
    public String base64Url() {
        return this.toByteString().base64Url();
    }

    @Override
    @NotNull
    public ByteString substring(int beginIndex, int endIndex) {
        return this.toByteString().substring(beginIndex, endIndex);
    }

    @Override
    public byte internalGet$jvm(int pos) {
        -Util.checkOffsetAndCount(this.directory[((Object[])this.segments).length - 1], pos, 1L);
        int segment = this.segment(pos);
        int segmentOffset = segment == 0 ? 0 : this.directory[segment - 1];
        int segmentPos = this.directory[segment + ((Object[])this.segments).length];
        return this.segments[segment][pos - segmentOffset + segmentPos];
    }

    private final int segment(int pos) {
        int i = Arrays.binarySearch(this.directory, 0, ((Object[])this.segments).length, pos + 1);
        return i >= 0 ? i : ~i;
    }

    @Override
    public int getSize$jvm() {
        return this.directory[((Object[])this.segments).length - 1];
    }

    @Override
    @NotNull
    public byte[] toByteArray() {
        byte[] result = new byte[this.directory[((Object[])this.segments).length - 1]];
        int segmentOffset = 0;
        int segmentCount = ((Object[])this.segments).length;
        for (int s = 0; s < segmentCount; ++s) {
            int segmentPos = this.directory[segmentCount + s];
            int nextSegmentOffset = this.directory[s];
            -Platform.arraycopy(this.segments[s], segmentPos, result, segmentOffset, nextSegmentOffset - segmentOffset);
            segmentOffset = nextSegmentOffset;
        }
        return result;
    }

    @Override
    public ByteBuffer asByteBuffer() {
        return ByteBuffer.wrap(this.toByteArray()).asReadOnlyBuffer();
    }

    @Override
    public void write(@NotNull OutputStream out) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        int segmentOffset = 0;
        int segmentCount = ((Object[])this.segments).length;
        for (int s = 0; s < segmentCount; ++s) {
            int segmentPos = this.directory[segmentCount + s];
            int nextSegmentOffset = this.directory[s];
            out.write(this.segments[s], segmentPos, nextSegmentOffset - segmentOffset);
            segmentOffset = nextSegmentOffset;
        }
    }

    @Override
    public void write$jvm(@NotNull Buffer buffer) {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        int segmentOffset = 0;
        int segmentCount = ((Object[])this.segments).length;
        for (int s = 0; s < segmentCount; ++s) {
            int segmentPos = this.directory[segmentCount + s];
            int nextSegmentOffset = this.directory[s];
            Segment segment = new Segment(this.segments[s], segmentPos, segmentPos + nextSegmentOffset - segmentOffset, true, false);
            if (buffer.head == null) {
                buffer.head = segment.next = (segment.prev = segment);
            } else {
                Segment segment2 = buffer.head;
                if (segment2 == null) {
                    Intrinsics.throwNpe();
                }
                Segment segment3 = segment2.prev;
                if (segment3 == null) {
                    Intrinsics.throwNpe();
                }
                segment3.push(segment);
            }
            segmentOffset = nextSegmentOffset;
        }
        Buffer buffer2 = buffer;
        buffer2.setSize$jvm(buffer2.size() + (long)segmentOffset);
    }

    @Override
    public boolean rangeEquals(int offset, @NotNull ByteString other, int otherOffset, int byteCount) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        int offset2 = offset;
        int otherOffset2 = otherOffset;
        int byteCount2 = byteCount;
        if (offset2 < 0 || offset2 > this.size() - byteCount2) {
            return false;
        }
        int s = this.segment(offset2);
        while (byteCount2 > 0) {
            int segmentSize;
            int n;
            int stepSize;
            int segmentPos;
            int segmentOffset = s == 0 ? 0 : this.directory[s - 1];
            int arrayOffset = offset2 - segmentOffset + (segmentPos = this.directory[((Object[])this.segments).length + s]);
            if (!other.rangeEquals(otherOffset2, this.segments[s], arrayOffset, stepSize = Math.min(byteCount2, n = segmentOffset + (segmentSize = this.directory[s] - segmentOffset) - offset2))) {
                return false;
            }
            offset2 += stepSize;
            otherOffset2 += stepSize;
            byteCount2 -= stepSize;
            ++s;
        }
        return true;
    }

    @Override
    public boolean rangeEquals(int offset, @NotNull byte[] other, int otherOffset, int byteCount) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        int offset2 = offset;
        int otherOffset2 = otherOffset;
        int byteCount2 = byteCount;
        if (offset2 < 0 || offset2 > this.size() - byteCount2 || otherOffset2 < 0 || otherOffset2 > other.length - byteCount2) {
            return false;
        }
        int s = this.segment(offset2);
        while (byteCount2 > 0) {
            int segmentSize;
            int n;
            int stepSize;
            int segmentPos;
            int segmentOffset = s == 0 ? 0 : this.directory[s - 1];
            int arrayOffset = offset2 - segmentOffset + (segmentPos = this.directory[((Object[])this.segments).length + s]);
            if (!-Util.arrayRangeEquals(this.segments[s], arrayOffset, other, otherOffset2, stepSize = Math.min(byteCount2, n = segmentOffset + (segmentSize = this.directory[s] - segmentOffset) - offset2))) {
                return false;
            }
            offset2 += stepSize;
            otherOffset2 += stepSize;
            byteCount2 -= stepSize;
            ++s;
        }
        return true;
    }

    @Override
    public int indexOf(@NotNull byte[] other, int fromIndex) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.toByteString().indexOf(other, fromIndex);
    }

    @Override
    public int lastIndexOf(@NotNull byte[] other, int fromIndex) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.toByteString().lastIndexOf(other, fromIndex);
    }

    private final ByteString toByteString() {
        return new ByteString(this.toByteArray());
    }

    @Override
    @NotNull
    public byte[] internalArray$jvm() {
        return this.toByteArray();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other == this ? true : (other instanceof ByteString ? ((ByteString)other).size() == this.size() && this.rangeEquals(0, (ByteString)other, 0, this.size()) : false);
    }

    @Override
    public int hashCode() {
        int result = this.getHashCode$jvm();
        if (result != 0) {
            return result;
        }
        result = 1;
        int segmentOffset = 0;
        int segmentCount = ((Object[])this.segments).length;
        for (int s = 0; s < segmentCount; ++s) {
            byte[] segment = this.segments[s];
            int segmentPos = this.directory[segmentCount + s];
            int nextSegmentOffset = this.directory[s];
            int segmentSize = nextSegmentOffset - segmentOffset;
            int limit = segmentPos + segmentSize;
            for (int i = segmentPos; i < limit; ++i) {
                result = 31 * result + segment[i];
            }
            segmentOffset = nextSegmentOffset;
        }
        this.setHashCode$jvm(result);
        return result;
    }

    @Override
    @NotNull
    public String toString() {
        return this.toByteString().toString();
    }

    private final Object writeReplace() {
        ByteString byteString = this.toByteString();
        if (byteString == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.Object");
        }
        return byteString;
    }

    public SegmentedByteString(@NotNull Buffer buffer, int byteCount) {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        super(ByteString.EMPTY.getData$jvm());
        -Util.checkOffsetAndCount(buffer.size(), 0L, byteCount);
        int offset = 0;
        int segmentCount = 0;
        Segment s = buffer.head;
        while (offset < byteCount) {
            Segment segment = s;
            if (segment == null) {
                Intrinsics.throwNpe();
            }
            if (segment.limit == s.pos) {
                throw (Throwable)((Object)new AssertionError((Object)"s.limit == s.pos"));
            }
            offset += s.limit - s.pos;
            ++segmentCount;
            s = s.next;
        }
        byte[][] segments = new byte[segmentCount][];
        this.directory = new int[segmentCount * 2];
        offset = 0;
        segmentCount = 0;
        s = buffer.head;
        while (offset < byteCount) {
            Segment segment = s;
            if (segment == null) {
                Intrinsics.throwNpe();
            }
            segments[segmentCount] = segment.data;
            if ((offset += s.limit - s.pos) > byteCount) {
                offset = byteCount;
            }
            this.directory[segmentCount] = offset;
            this.directory[segmentCount + ((Object[])segments).length] = s.pos;
            s.shared = true;
            ++segmentCount;
            s = s.next;
        }
        this.segments = segments;
    }
}

