import { CommonModule } from '@angular/common';
import { NgModule } from '@angular/core';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { AutoCompleteModule } from 'primeng/autocomplete';
import { ButtonModule } from 'primeng/button';
import { CheckboxModule } from 'primeng/checkbox';
import { DialogModule } from 'primeng/dialog';
import { DropdownModule } from 'primeng/dropdown';
import { InputMaskModule } from 'primeng/inputmask';
import { InputSwitchModule } from 'primeng/inputswitch';
import { ProgressBarModule } from 'primeng/progressbar';
import { RadioButtonModule } from 'primeng/radiobutton';
import { ToastModule } from 'primeng/toast';
import { AssessmentService } from '../services/assessment.service';
import { HelperService } from '../services/helper.service';
import { PersonalDetailsService } from '../services/personal-details.service';
import { ToasterService } from '../services/toaster.service';
import { FormControlComponent } from './form-control/form-control.component';
import { GooglePlacesAutocompleteDirective } from './google-places-autocomplete.directive';
import { OverlayComponent } from './overlay/overlay.component';
import { TruncatePipe } from './truncate.pipe';
import { TabViewModule } from 'primeng/tabview';
import { CalendarModule } from 'primeng/calendar';
import { FileUploadModule } from 'primeng/fileupload';
import { SelectButtonModule } from 'primeng/selectbutton';
import { PersonalDetailsComponent } from './personal-details/personal-details.component';
import { ConfirmDialogModule } from 'primeng/confirmdialog';
import { TooltipModule } from 'primeng/tooltip';

const MODULES = [
    ReactiveFormsModule,
    FormsModule,
    RadioButtonModule,
    CheckboxModule,
    DropdownModule,
    AutoCompleteModule,
    ToastModule,
    InputSwitchModule,
    ButtonModule,
    InputMaskModule,
    ProgressBarModule,
    DialogModule,
    TabViewModule,
    CalendarModule,
    FileUploadModule,
    SelectButtonModule,
    ConfirmDialogModule,
    TooltipModule
];

const COMPONENTS = [
    FormControlComponent,
    OverlayComponent,
    PersonalDetailsComponent
];

const DIRECTIVES = [
    GooglePlacesAutocompleteDirective
];

const PIPES = [
    TruncatePipe
];

@NgModule({
    imports: [
        CommonModule,
        ...MODULES
    ],
    exports: [
        ...MODULES,
        ...COMPONENTS,
        ...DIRECTIVES,
        ...PIPES
    ],
    providers: [
        ToasterService,
        HelperService,
        PersonalDetailsService,
        AssessmentService
    ],
    declarations: [
        ...COMPONENTS,
        ...DIRECTIVES,
        ...PIPES
    ]
})
export class McSharedModule {
}
