<%@ page extends="oneit.servlets.jsp.JSPInclude"%>

<%@ taglib prefix="tagfile" tagdir="/WEB-INF/tags"%>
<%@ include file="/setuprequest.jsp"%>

<%@ page import="oneit.servlets.process.*"%>
<%@ page import="oneit.objstore.*, oneit.utils.*, oneit.utils.text.*"%>
<%@ page import="java.util.*"%>
<%@ page import="performa.orm.*, performa.orm.types.*, performa.chart.*, performa.utils.*"%>
<%
    ORMProcessState         process         =   (ORMProcessState) ProcessDecorator.getDefaultProcess(request);
    ObjectTransaction       objTran         =   process.getTransaction();
    Job                     job             =   (Job) process.getAttribute("Job");
    List<JobApplication>    applications    =   (List<JobApplication>) getData(request, "Applications");
    WorkFlow                workFlow        =   (WorkFlow) getData(request, "WorkFlow");
%>
<oneit:dynIncluded>
    <div class="wrap">
        <div class="header">
            <div class="chief-officer">
                <oneit:toString value="<%= job.getJobTitle() %>"    mode="EscapeHTML" />
                <%
                    if(job.getReferenceNumber() != null)
                    {
                %>
                &nbsp;<span class="ref-no">(<oneit:toString value="<%= job.getReferenceNumber() %>" mode="EscapeHTML" />)</span>
                <%
                    }
                %>
            </div>
            <div class="by-name">
                <div class="header-right-status">
                    <span class="light-calendar">
                        <span class="number">
                            <span class="calcField">0</span>
                        </span>
                        <span class="calcField">days until closed</span>
                
                    </span>
                    <span class="job-status-appli">
                        <span class="open-status-icon"></span>
                        <span class="calcField">THIS JOB IS Open</span>
                    </span>
                </div>
                <span>
                <%
                    if(job.isClientAvailable())
                    {
                %>
                        <oneit:toString value="<%= job.getClient() %>"  mode="EscapeHTML" />
                <%
                    }
                %>
                </span>SUPERLAW by <oneit:toString   value="<%= job.getCreatedBy() %>"  mode="EscapeHTML"  nullValue=""/>
                &nbsp;&nbsp;.&nbsp;&nbsp;
                <oneit:toString value="<%= job.getLevel() %>"   mode="EscapeHTML" />
            </div>


        </div>
        <div class="white-header">
            <div style="clear:both"></div>

            <div class="main-appli-name">
                <div class="appli-name"><%= workFlow == null || workFlow.getApplicationStatus() == ApplicationStatus.SUBMITTED ? "All" : workFlow.getName() %> Applicants </div>
            </div>
            <div class="appli-count">
                <%= applications.size() %> Applicants
            </div>
        </div>  
        <div class="view-appli-list">
    <%
        for (JobApplication jobApplication : applications)
        {
            String  roleFit     =   FormatUtils.stringify(jobApplication.getRoleFitPercentage(), "PercentageWholeNumber", "0");
            String  culture     =   FormatUtils.stringify(jobApplication.getCultureFitScore(), "PercentageWholeNumber", "0");
            Integer overallRank =   jobApplication.getOverallRank();
            boolean missingReq  =   jobApplication.hasFailedEssentialRequirements();
    %>
    
            <div class="appl-c-box">
                <div class="gridbox-title">
                    <div class="gridbox-applicant">
                        <oneit:toString value="<%= jobApplication.getCandidate() %>"    mode="EscapeHTML" />
                    </div>
                </div>
                <div class="overall-suitablity">
                    <div class="overall">overall rank</div>
                    <div class="over-all blue">
                        <oneit:toString value="<%= overallRank %>"   mode="Integer" />
                    </div>
                     <div style="clear:both"></div>
                </div>
                <div class="jcc-box">
                    <div class="job-match jcc">
                        <div class="jcc-title">
                        <img src="file:///<%= PDFUtils.FILE_BASE_PATH %>/images/job-match-icon.png" /> role fit 
                        </div>
                        <span>
                            <oneit:toString value="<%= jobApplication.getRoleFitPercentage() %>"    mode="PercentageWholeNumber" />
                        </span>
                    </div>
                    <div class="culture jcc">
                         <div class="jcc-title">
                        <img src="file:///<%= PDFUtils.FILE_BASE_PATH %>/images/culture-icon.png" /> culture fit
                         </div>
                        <span>
                            <oneit:toString value="<%= jobApplication.getCultureFitScore() %>"  mode="PercentageWholeNumber" />
                        </span>
                    </div>
                        
                    <%
                        if(job.getIncludeAssessmentCriteria()==Boolean.TRUE)
                        {
                    %>
                            <div class="criteria jcc <%=(missingReq ? "red-bg" : "green-bg")%> ">
                                <div class="jcc-title">
                                <img src="file:///<%= PDFUtils.FILE_BASE_PATH %>/images/<%=(missingReq ? "icon-requirements_small.png" : "critarea_white.png")%>"/> requirements
                                </div>
                                <span>
                                    <oneit:toString value="<%= jobApplication.getRequirementFitScore() %>"  mode="PercentageWholeNumber" />
                                </span>
                            </div>
                    <%
                        }
                    %>
                     <div style="clear:both"></div>
                </div>
            </div>
    <%
        }
    %>
   
    </div>
      </div>
</oneit:dynIncluded>