package performa.form;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.logging.LoggingArea;
import oneit.objstore.ObjectTransaction;
import oneit.objstore.StorageException;
import oneit.objstore.parser.BusinessObjectParser;
import oneit.objstore.rdbms.filters.EqualsFilter;
import oneit.servlets.forms.SubmissionDetails;
import oneit.servlets.forms.SuccessfulResult;
import oneit.servlets.process.ORMProcessState;
import oneit.servlets.process.SaveFP;
import oneit.utils.BusinessException;
import oneit.utils.MultiException;
import performa.orm.Company;
import performa.orm.CompanyUser;
import performa.orm.CompanyUserHiringTeamLink;
import performa.orm.HiringTeam;
import performa.orm.types.RoleType;


public class ChangeCompanyFP extends SaveFP
{
    private static final LoggingArea  LOG =   LoggingArea.createLoggingArea("ChangeCompanyFP");
    
    @Override
    public void validate(ORMProcessState process, SubmissionDetails submission, MultiException exceptions, Map params) throws StorageException 
    {
        HttpServletRequest  request     =   submission.getRequest();
        HiringTeam          hiringTeam  =   (HiringTeam) request.getAttribute("HiringTeam");
        
        if(hiringTeam.isFalse(hiringTeam.getExistingCustomer()))
        {
            BusinessObjectParser.assertFieldCondition(hiringTeam.getCompanyName() != null, hiringTeam, HiringTeam.FIELD_CompanyName, "mandatory", exceptions, true, request);
            BusinessObjectParser.assertFieldCondition(hiringTeam.getCompanyTimeZone() != null, hiringTeam, HiringTeam.FIELD_CompanyTimeZone, "mandatory", exceptions, true, request);
            BusinessObjectParser.assertFieldCondition(hiringTeam.getCompanyType() != null, hiringTeam, HiringTeam.FIELD_CompanyType, "mandatory", exceptions, true, request);
        }
        super.validate(process, submission, exceptions, params);
    }


    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        ObjectTransaction   objTran         =   process.getTransaction();
        HttpServletRequest  request         =   submission.getRequest();
        HiringTeam          hiringTeam      =   (HiringTeam) request.getAttribute("HiringTeam");

        LogMgr.log(LOG, LogLevel.PROCESSING1, "Changing company of hiring team : ", hiringTeam);
 
        if(hiringTeam.isFalse(hiringTeam.getExistingCustomer()))
        {
            Company company =   Company.createCompany(objTran);
            
            company.setCompanyName(hiringTeam.getCompanyName());
            company.setHiringTeamType(hiringTeam.getCompanyType());
            company.setTimeZone(hiringTeam.getCompanyTimeZone());
            company.setAddedByUser(hiringTeam.getAddedByUser());
            
            hiringTeam.setCompany(company);
            
            LogMgr.log(LOG, LogLevel.PROCESSING1, "Added new company : ", company);
        }
        
        CompanyUser                 addedByUser =   hiringTeam.getAddedByUser();
        CompanyUserHiringTeamLink   link        =   addedByUser.pipelineCompanyUser().toHiringTeams(CompanyUserHiringTeamLink.SearchByAll().andHiringTeam(new EqualsFilter<>(hiringTeam))).val();

        if(link == null)
        {
            link    =   CompanyUserHiringTeamLink.createCompanyUserHiringTeamLink(objTran);

            link.setHiringTeam(hiringTeam);
            link.setCompanyUser(addedByUser);
            link.setRole(RoleType.OWNER);
        }

        return super.processForm(process, submission, params);
    }
}