import { Injectable } from '@angular/core';
import { Observable, Subject } from 'rxjs';
import { environment } from '../../../../environments/environment';
import { ApiService } from '../../../oneit/services/api.service';
import { UtilsService } from '../../../oneit/services/utils.service';

@Injectable()
export class AdminPortalLayoutService {

    userDataUpdated = new Subject<any>();
    userData: any;
    
    constructor(
        private apiService: ApiService,
        private utilsService: UtilsService
    ) {

    }

    reloadAdminUserDetails() {
        let params = {
            environment: environment.envName
        }

        this.apiService.post(`svc/AdminUserDetails`, params).subscribe (
            (data) => {
                if (this.utilsService.isSuccessfulResponse(data)) {
                    this.userData   =   data;
                    this.userDataUpdated.next(data);
                }
            });
    }

    getAdminMenu(): Observable<any> {
        let params = {
            environment: environment.envName
        }

        return this.apiService.post(`svc/AdminMenu`, params).map(
            (data) => {
                if (this.utilsService.isSuccessfulResponse(data)) {
                    return data;
                }
            });
    }

    selectHiringTeam(selectedTeam) : Observable<any> {
        return this.utilsService.processObjects("SelectHiringTeam", { HiringTeam : selectedTeam });
    }

    createJob(selectedTeam, companyUser) : Observable<any> {
        return this.utilsService.processObjects("CreateJobVisibility", { SelectedTeam : selectedTeam, CompanyUser : companyUser });
    }

    getHiringTeamID() {
        return this.userData ? this.userData.selectedTeam : null;
    }
}
