<%@ page extends="oneit.servlets.jsp.JSPInclude" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    boolean toRedirect  =   GenericObjDF.getOrCreateObject (request, "Job", Job.REFERENCE_Job);
    Job     job         =   (Job) process.getAttribute("Job");

    Debug.assertion(job != null && !toRedirect, "Invalid job in applicant portal");

    SecUser     secUser     =   SecUser.getTXUser(transaction);
    
    Debug.assertion(secUser != null, "Invalid candidate in applicant portal");
    
    Candidate   candidate   =   secUser.getExtension(Candidate.REFERENCE_Candidate);

    Debug.assertion(candidate != null, "Invalid candidate in applicant portal");

    String          successPage     =   WebUtils.getSamePageInRenderMode(request, "VerificationSent") + "&JobID=" + job.getID();
    JobApplication  jobApplication  =   JobApplication.searchCandidateJob(transaction, candidate, job);
    boolean         redirectUser    =   jobApplication != null && jobApplication.getApplicationStatus() == ApplicationStatus.DRAFT;

    if(jobApplication == null)
    {
        jobApplication  =   JobApplication.createNewApplication(candidate, job);
    }

    Boolean isSelectionComplete     =   jobApplication.selectionCompleted();
    Boolean isCultureComplete       =   jobApplication.cultureCompleted();
    Boolean isAssesmentComplete     =   jobApplication.assessmentCompleted();
    Article jobApplicationArticle   =   WebUtils.getArticleByShortCut(transaction, WebUtils.JOB_APPLICATION);
    String  nextPage                =   jobApplicationArticle.getLink(request) + "?JobID="+ job.getID().toString();;

    if(!jobApplication.hasStartedApplication())
    {
        nextPage    =   WebUtils.getArticleLink(request, transaction, WebUtils.JOB_APPLICATION, "Page") + "&JobID="+ job.getID().toString();
    }
    else if(!isSelectionComplete)
    {
        nextPage    =   LoopbackHTTP.getRemoteAccessURL(request)
                                        + jobApplicationArticle.getLink(request, CollectionUtils.mapEntry("cms.rm", "SelectionCriteria").toMap(), "/");
    }
    else if(!isCultureComplete)
    {
        nextPage    =   LoopbackHTTP.getRemoteAccessURL(request)
                                        + jobApplicationArticle.getLink(request, CollectionUtils.mapEntry("cms.rm", "WorkplaceCulture").toMap(), "/");
    }
    else if(!isAssesmentComplete)
    {
        nextPage    =   LoopbackHTTP.getRemoteAccessURL(request)
                                        + jobApplicationArticle.getLink(request, CollectionUtils.mapEntry("cms.rm", "JobMatchAssessment").toMap(), "/");
    }
    

    if(redirectUser)
    {
        response.sendRedirect(candidate.isFalse(candidate.getIsAccountVerified()) ? successPage : nextPage +"&JobApplicationID="+ jobApplication.getID().toString());
    }

    candidate.setHasValidAddress(candidate.getGoogleAddressText() != null);
    candidate.setAnsweredDiversity(true);

    process.setAttribute("JobApplication", jobApplication);
%>
    <oneit:form name="diversity" method="post" enctype="multipart/form-data">
        <script type="text/javascript">
            $(document.body).addClass('bg-color');
            $(document).ready(function() {
                recalcFunction = setupRecalc ($("form#diversity"), {'recalcOnError':true});
            });
        </script>
        <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>
        <div class="apply-job-logo-header signinpage">
             <div class="box-sizing-border-box">
                <div class="logo-img">
                <%
                    BinaryContent   logo    =   job.getLogo();

                    if(logo != null)
                    {
                        int logoHeight  =   45;
                %>
                        <tagfile:img src="<%= ThumbnailUtils.filterImage(DiskFileBinaryContent.getRelativeURL(logo), "KEEP", new ScaleWithin (0, logoHeight)) %>" />
                <%
                    }
                %>
                </div>
                <div class="header-title">
                    <%= job.getTeamName() %>
                </div>
            </div>
        </div>
        <div class="main-verify-identity">
            <%
                for(HTDiversityQuestion question : job.getDiversityQuestions())
                {
            %>
                    <div class="form-group text-left">
                        <label><%= question.getQuestionText() %></label>
                    </div>
            <%
                }
            %>
            <div class="text-center">
                <oneit:button   value="Submit"   name="sendVerificationMail"    cssClass="box-btn send-link-btn"
                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", successPage)
                                                                    .mapEntry("Job",job)
                                                                    .mapEntry("Candidate",candidate)
                                                                    .mapEntry("JobApplication",jobApplication)
                                                                    .mapEntry(NotificationUtils.NOTIFICATION_MSG_PARAM, "emailSent")
                                                                    .toMap() %>"/>
            </div>
        </div>
    </oneit:form>
</oneit:dynIncluded>