<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<%
    Company company     =  (Company) getData(request, "Company"); 
    Job     job         =  (Job) getData(request, "Job"); 

    PaymentPlan[]   plans           =   Utils.getPaymentPlansForJobs(transaction);
    Integer         maxCount        =   0;
    Integer         minCount        =   0;
    
    if(company.getPaymentPlan() != null && company.getPaymentJobCount() == null)
    {
        company.setPaymentJobCount(company.getPaymentPlan().getActiveJobCount());
    }
    
    if(plans.length > 0)
    {
        Collection<Integer> jCounts =   PaymentPlan.pipesPaymentPlan(plans).toActiveJobCount().vals();
        maxCount                    =   Collections.max(jCounts);
        minCount                    =   Collections.min(jCounts);
    }
%>
    <style>
        input[type=number]::-webkit-inner-spin-button, 
        input[type=number]::-webkit-outer-spin-button {  
            opacity: 1;
        }
    </style>

<oneit:dynIncluded>
    <div class="a-label-row pay-subsc-row">
        <div class="col-md-6 col-sm-6 col-xs-6 text-left">
            <label class="label-20 pay-subsc-txt"><%= company.getPaymentPlan() != null ? "Monthly Plan" : job.getAssessmentType().getDescription() %></label>
        </div>
        <%
            if(company.getPaymentPlan() != null)
            {
        %>
                <div class="col-md-6 col-sm-6 col-xs-6 text-right">
                    <oneit:ormInput type="number"           obj="<%= company %>"  attributeName="PaymentJobCount"   required="true"
                                    min="<%= minCount %>"   max="<%= maxCount %>" step="1"  cssClass="payment-paln-count"/>
                     <label class="label-20">&nbsp;Jobs / month </label>    
                </div>
        <%
            }
        %>
    </div>

    <div class="form-group row">
    <div class="pay-subsc-det-row a-label-row">
        <oneit:recalcClass  htmlTag="span"  classScript="company.getPaymentPlanAmount()!=null ? 'show': 'hide'" company="<%= company %>">
            <div class="col-md-6 col-sm-6 col-xs-6 text-left">
                Total: 
                <span class="pay-subsc-amt">
                    <oneit:recalc   mode="Currency"     script="company.getPaymentPlanAmount()" company="<%= company %>"    nullValue=""/>
                     / mo
                </span>
            </div>
            <div class="col-md-6 col-sm-6 col-xs-6 text-right pay-subsc-det">
                <div class="text-right">
                    <oneit:recalc   mode="Currency" script="company.getPerJobPaymentPlanAmount()"   company="<%= company %>"  nullValue=""/> 
                    per job. Save 
                    <oneit:recalc   mode="Currency"     script="company.getPaymentPlanSaveAmount()" company="<%= company %>"    nullValue=""/> 
                    per month.
                </div>
            </div>
        </oneit:recalcClass>
    </div>
    </div>
</oneit:dynIncluded>

