<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<%
    Job     job         =   (Job) process.getAttribute("Job"); 
    int     shortlisted =   job.getNoOfCandidatesFor(ApplicationStatus.SHORTLISTED);
    String  editJobPage =   WebUtils.getSamePageInRenderMode(request, WebUtils.EDIT_JOB);
    String  sharePage   =   WebUtils.getSamePageInRenderMode(request, WebUtils.CREATED_JOB);
    String  jobPage     =   WebUtils.getSamePageInRenderMode(request, (shortlisted > 0 ? WebUtils.APPLICANTS_SHORTLIST : WebUtils.VIEW_APPLICANTS));

    if(job.getJobStatus() == JobStatus.DRAFT)
    {
        if(job.getDraftLocation() == null)
        {
            editJobPage =   WebUtils.getSamePageInRenderMode(request, WebUtils.JOB_REVIEW);
        }
        else if(job.getDraftLocation() == DraftLocation.DETAILS)
        {
            editJobPage =   WebUtils.getSamePageInRenderMode(request, WebUtils.CREATE_JOB); 
        }
        else if(job.getDraftLocation() == DraftLocation.ASSESSMENT)
        {
            editJobPage =   WebUtils.getSamePageInRenderMode(request, WebUtils.ASSESSMENT_CRITERIA); 
        }
        else if(job.getDraftLocation() == DraftLocation.CULTURE)
        {
            editJobPage =   WebUtils.getSamePageInRenderMode(request, WebUtils.WORKPLACE_CULTURE); 
        }
    }
%>

<oneit:dynIncluded>

    <div class="officer-box">
        <div class="officer-name">
            <div class="chief-officer">
            <oneit:button   name="gotoPage" value=" " skin="link"
                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", jobPage).toMap() %>" >
                <img src="images/arrow-left-prev.svg" />
            </oneit:button>
                <%
                    BinaryContent   logo    =   job.getLogo();

                    if(logo != null)
                    {
                        int logoHeight  =   26;
                %>
                        <tagfile:img src="<%= ThumbnailUtils.filterImage(DiskFileBinaryContent.getRelativeURL(logo), "KEEP", new ScaleWithin (0, logoHeight)) %>" />
                <%
                    }
                %>
                <oneit:button   value=" "   name="gotoPage" skin="link"
                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", jobPage)
                                                                .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).toMap())
                                                                .toMap() %>">
                    <oneit:toString value="<%= job.getJobTitle() %>"    mode="EscapeHTML" />
                    <%
                        if(job.getReferenceNumber() != null)
                        {
                    %>
                            &nbsp;(<oneit:toString value="<%= job.getReferenceNumber() %>" mode="EscapeHTML" />)
                    <%
                        }
                    %>
                </oneit:button>
            </div>
            <div class="off-name">
                <oneit:toString   value="<%= job.getAssessmentType() %>"  mode="EscapeHTML"  nullValue=""/>:
                <span class="ex-management">
                    <oneit:toString value="<%= job.getLevel() %>"   mode="EscapeHTML" />
                </span>
            </div>
            <div class="off-name">
                <span class="austr-post">
                <%
                    if(job.isClientAvailable())
                    {
                %>
                        <oneit:toString value="<%= job.getClient() %>"  mode="EscapeHTML" />
                <%
                    }
                %>
                </span> by <oneit:toString   value="<%= job.getCreatedBy() %>"  mode="EscapeHTML"  nullValue=""/>
            </div>
        </div>
        <div class="applicant-right-status">
            <span class="light-calendar">
                <%
                    if(job.getJobStatus() == JobStatus.OPEN)
                    {
                        int daysToClose =   job.getNoOfDaystoClosed();
                %>
                        <span class="number">
                            <oneit:toString value="<%= daysToClose %>"  mode="Integer"/>
                        </span>
                        <oneit:toString value="<%= (daysToClose == 1 ? "day" : "days") + " until closed" %>"    mode="EscapeHTML"/>
                <%
                    }
                    else
                    {
                %>
                        <oneit:toString value="<%= job.getJobStatus().getDescription() %>"    mode="EscapeHTML"/> on
                        <oneit:toString value="<%= job.getLastStatusChangeDate() %>"    mode="PerformaDate"/>
                <%
                    }
                %>
            </span>
            <span class="job-status-appli">
                <span class="<%= job.getJobStatus().getName().toLowerCase() + "-status-icon" %>"></span>
                <oneit:toString  value="<%= job.getJobStatusText() %>"    mode="EscapeHTML"/>
            </span>
            
            <span class="edit-btn-dropdown">
                <oneit:button   value="Share"   cssClass="<%= job.getJobStatus() != JobStatus.OPEN ? "leftbtn disabled" : "leftbtn"%>"  name="gotoPage" skin="link"
                                disabled="<%= job.getJobStatus() != JobStatus.OPEN ? "true" : "false" %>"
                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", sharePage + "&JobID=" + job.getObjectID())
                                                                    .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).toMap())
                                                                    .mapEntry("cancelProcess", true)
                                                                    .toMap() %>"/>
                <oneit:button   value=" " cssClass="rightbtn"  name="gotoPage" skin="link"
                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", editJobPage + "&JobID=" + job.getObjectID())
                                                                    .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).toMap())
//                                                                  .mapEntry("cancelProcess", true)
                                                                    .toMap() %>">
                    EDIT
                    <span><img src="images/edit-dropdown-arrow.svg" /></span>
                </oneit:button>
            </span>

        </div>
    </div>
</oneit:dynIncluded>