<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>
<%@ page import="oneit.utils.text.FormatUtils"%>

<%
    Job                     job             =   (Job) process.getAttribute("Job");
    List<JobApplication>    applications    =   (List<JobApplication>) getData(request, "applications");
    String                  currentPage     =   (String) getData(request, "currentPage");
    ApplicationStatus       appStatus       =   (ApplicationStatus)  getData(request, "WorkFlowStatus");
    String                  applicationPage =   WebUtils.getSamePageInRenderMode(request, WebUtils.VIEW_APPLICATION);
    List<WorkFlow>          sortedWorkFlows =   ObjstoreUtils.sort(job.getIncompleteApplicantWFs(), 
                                                        new ObjectTransform[]{WorkFlow.pipesWorkFlow().toSortOrder()}, 
                                                        new Comparator[]{CollectionUtils.DEFAULT_COMPARATOR_NULLS_FIRST});
%>

<oneit:dynIncluded>
    <script type="text/javascript">
        $(document).ready(function() 
        {            
            $("[name$='WorkFlow']").prop("disabled",true);
            
            $("[name$='WorkFlow']").change(function()
            {
                var id  = $(this).closest('.appli-row').attr('id');
                $('.save-application' + id).click();
            });
        });
        
        function copyHTMLToClip(ele, verified) {
            var aux = document.createElement("textarea");
            aux.value = $(ele).text().trim();
            document.body.appendChild(aux);
            aux.select();
            document.execCommand("copy");
            document.body.removeChild(aux);
            if(verified)
            {
                alert("link copied to clipboard");
            }
            else
            {
                alert("This applicant's email address is not verified. If the email address is wrong, further messages cannot be sent. \nLink copied to clipboard");
            }
        };
    </script>
    <div class="view-appli-list">
    <%
        int j   = 0;

        for(JobApplication jobApplication : applications)
        {
            Candidate   candidate   =   jobApplication.getCandidate();
            double      roleFitVal  =   candidate.roleFitCompletedPercentage(job); 
            double      cultureVal  =   candidate.cultureCompletedPercentage(job); 
            double      criteriaVal =   jobApplication.requirementCompletedPercentage(); 
            String      roleFit     =   FormatUtils.stringify(roleFitVal, "PercentageWholeNumber", "0");
            String      culture     =   FormatUtils.stringify(cultureVal, "PercentageWholeNumber", "0");
            String      criteria    =   FormatUtils.stringify(criteriaVal, "PercentageWholeNumber", "0");
            String      appID       =   "app-id-" + jobApplication.getID().toString();
            Integer     overallRank =   jobApplication.getOverallRank();
            Boolean     isTopRank   =   CollectionUtils.equals(overallRank, 1);
            WorkFlow    workflow    =   job.getWorkFlowByStatus(jobApplication.getApplicationStatus());
            boolean     missingReq  =   jobApplication.hasFailedEssentialRequirements();
            
            jobApplication.setWorkFlow(workflow);
    %>
            <div class="appli-row"  id="<%= jobApplication.getID() %>">
                <div class="appli-checkbox appli-l eq-second-height">
                    <div class="checkbox-list">
                        <input type="checkbox"  name="IsSelected" value="<%= jobApplication.getObjectID().toString() %>"  id="<%= appID %>" class="applicant" >
                        <label for="<%= appID %>"></label>
                    </div>
                </div>
                <div class="appli-list-name appli-l eq-second-height wider-box">
                    <oneit:button   value=" "    name="gotoPage" cssClass="<%= jobApplication.getID() + ""%>" skin="link"
                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", applicationPage)
                                                                        .mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).mapEntry("Applications", applications).toMap())
                                                                        .toMap() %>">
                    <%
                        if(jobApplication.isTrue(candidate.getIsEmailIngest()))
                        {
                    %>
                            <span style="padding-right: 5px;"><img src="images/email-ingest-icon.jpg"></span>
                    <%
                        }

                        if( candidate.getVerificationKey() == null)
                        {
                            candidate.setVerificationKey(new RandomStringGen().generateAlphaNum(6));
                        }

                        String  jobLink     =   LoopbackHTTP.getRemoteAccessURL() 
                                                            + Utils.APPLICANT_LINK
                                                            + "?id=" + job.getID() 
                                                            + "&key=" + job.getRandomKey() 
                                                            + "&aid=" + candidate.getID()
                                                            + "&pin=" + candidate.getVerificationKey();
                    %>
                        <oneit:toString value="<%= candidate %>"    mode="EscapeHTML" />
                        <span style="float:right; padding-right: 5px;">
                            <a style="float:right; padding-right: 10px;" onclick="copyHTMLToClip('.<%= jobApplication.getID().toString() + "link"%>', <%= candidate.getIsAccountVerified()%>)">
                                <img src="images/copy-icon.jpg">
                                <span style="display:none;" class='<%= jobApplication.getID().toString() + "link"%>'>
                                    <%= jobLink %>
                                </span>
                            </a>
                        </span>
                    </oneit:button>
                    <div class="appli-int-status">
                        <span>
                            <a href="<%= "mailto:" + candidate.getUser().getEmail() %>">Email</a>
                        </span>
                        <oneit:toString value="<%= candidate.getPhone() %>"   mode="EscapeHTML" />
                        <span><img src="images/clip_icon.png"></span>
                        <%
                            if(jobApplication.getCV() != null)
                            {
                        %>
                                <span>
                                    <a target='blank' href='<%= request.getContextPath() + "/" + BinaryContentHandler.getRelativeURL(request, jobApplication, "CV", jobApplication.getCV(), true) %>'>
                                        CV
                                    </a>
                                </span>
                        <%
                            }

                            if(jobApplication.getCoverLetter() != null)
                            {
                        %>
                                <span>
                                    <a target='blank' href='<%= request.getContextPath() + "/" + BinaryContentHandler.getRelativeURL(request, jobApplication, "CoverLetter", jobApplication.getCoverLetter(), true) %>'>
                                        Cover Letter
                                    </a>
                                </span>
                        <%
                            }
                        %>
                    </div>
                </div>
                <%
                    String widthClass   =   (job.showAssessmentCriteriaSection() && job.showCultureCriteriaSection()) ? "appli-jcs" : 
                                                (job.showAssessmentCriteriaSection() || job.showCultureCriteriaSection()) ? "appli-jcs2" : "appli-jcs3";
                    
                    if(job.showAssessmentCriteriaSection())
                    {
                %>
                        <div class="<%= widthClass %> appli-l eq-second-height">
                            <span class="appli-view-bar">
                                <div class="progress">
                                    <div class="completion-progress-bar <%= criteriaVal == 100 ? "green-bar": (criteriaVal >= 50 && criteriaVal  < 100 ? "orange-bar" : "red-bar") %>" role="progressbar" aria-valuenow="<%= criteria %>" aria-valuemin="0" aria-valuemax="100" 
                                            style="<%= "width: " + criteria %>">
                                         <span class="show-precentage"><%= criteria %></span>
                                    </div>
                                           
                                </div>
                                <span class="missing-requirements-icon" style="<%= missingReq ? "display:inline-block" : "display:none" %>"></span>
                            </span>
                            <span class="<%= missingReq ? "red-requirements" : "" %>">
                                requirements
                            </span>
                        </div>
                <%
                    }
                    
                    if(job.showCultureCriteriaSection())
                    {
                %>
                        <div class="<%= widthClass %> appli-l eq-second-height">
                            <span class="appli-view-bar">
                                <div class="progress">
                                    <div class="completion-progress-bar <%= cultureVal == 100 ? "green-bar": (cultureVal >= 50 && cultureVal  < 100 ? "orange-bar" : "red-bar") %>" role="progressbar" aria-valuenow="<%= culture %>" aria-valuemin="0" aria-valuemax="100" 
                                            style="<%= "width: " + culture %>">
                                        <span class="show-precentage"><%= culture %></span>
                                    </div> 

                                </div>
                            </span>
                            culture fit
                        </div>
                <%
                    }
                %>
                <div class="<%= widthClass %> appli-l eq-second-height">
                    <span class="appli-view-bar">
                        <div class="progress">
                            <div class="completion-progress-bar <%= roleFitVal == 100 ? "green-bar": (roleFitVal >= 50 && roleFitVal  < 100 ? "orange-bar" : "red-bar") %>" role="progressbar" aria-valuenow="<%= roleFit %>" aria-valuemin="0" aria-valuemax="100" 
                                    style="<%= "width: " + roleFit %>">
                                <span class="show-precentage"><%= roleFit %></span>
                            </div>
                            
                        </div>
                    </span>
                    role fit
                </div>
                <div class="appli-status appli-l eq-second-height">
                    <%
                        if(jobApplication.getApplicationStatus() == ApplicationStatus.DRAFT)
                        {
                    %>
                            <div class="appli-list-drop">
                                <tagfile:ormsingleasso_select obj="<%= jobApplication %>"   assocName="WorkFlow"    cssClass="form-control app-process"    
                                                              options="<%= sortedWorkFlows.toArray(new WorkFlow[0]) %>"/>
                            </div>
                    <%
                        }
                    %>
                </div> 
                <oneit:button   name="changeApplicationStatus"  value=" "   cssClass="<%= "save-application" +  jobApplication.getID().toString() + " hidden"%>"
                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", currentPage)
                                                                    .mapEntry ("restartProcess", Boolean.TRUE)
                                                                    .mapEntry("procParams", CollectionUtils.mapEntry("WorkFlowStatus", appStatus).mapEntry("Job", job).toMap())
                                                                    .mapEntry ("attribNamesToRestore", new HashSet<String> (Arrays.asList(new String[] {"Job", "WorkFlowStatus"})))
                                                                    .mapEntry("JobApplication", jobApplication)
                                                                    .toMap() %>" />
            </div>
    <%
            j++;
        }
    %>
    </div>
</oneit:dynIncluded>
