<%@ page extends="oneit.servlets.jsp.JSPInclude" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    String      nextPage    =   WebUtils.getArticleLink(request, process.getTransaction (), WebUtils.JOB_APPLICATION, "CoverLetter");
    Candidate   candidate   =   (Candidate) process.getAttribute("NewCandidate");
    Job         job         =   (Job) process.getAttribute("Job");
    SecUser     secUser     =   null;
    boolean     toRedirect  =   false;
    
    //to process candidate verification
    String      id          =   request.getParameter("id");
    String      key         =   request.getParameter("key");
    String      candidateId =   request.getParameter("aid");
    String      pin         =   request.getParameter("pin");
    Boolean     isVerify    =   Boolean.FALSE;
    
    if(id != null || key != null || candidateId != null || pin != null)
    {
        isVerify    =   Boolean.TRUE;

        if(candidateId != null && pin != null)
        {
            candidate   =   Candidate.searchIdPin(transaction, Long.parseLong(candidateId), pin);

            if(candidate != null && candidate.getIsAccountVerified() != Boolean.TRUE)
            {
                secUser =   candidate.getUser();
                process.setAttribute("NewCandidate", candidate);
            }
        }
        
        if(id != null && key != null)
        {
            job = Job.searchJobKey(transaction, Long.parseLong(id), key);
            process.setAttribute("Job", job);
        }
    }
    else
    {
        toRedirect  =   GenericObjDF.getOrCreateObject (request, "Job", Job.REFERENCE_Job);
    }

    //INVALID REQUEST FOR VERIFY CANDIDATE
    if(isVerify && (job == null || secUser == null))
    {
        response.sendRedirect(WebUtils.getSamePageInRenderMode(request, "AuthError"));
        return;     //Else it will continue execution and throws NPE.
    }
    
    if(secUser == null)
    {
        secUser     =   SecUser.getTXUser(transaction);
        candidate   =   secUser.getExtension(Candidate.REFERENCE_Candidate);
    }
    
    Debug.assertion(job != null && !toRedirect, "Invalid job in applicant portal");
    Debug.assertion(candidate != null, "Invalid candidate in applicant portal");

    JobApplication      jobApplication  =   JobApplication.searchCandidateJob(transaction, candidate, job);
    
    if(jobApplication == null)
    {
        jobApplication  =   JobApplication.createNewApplication(candidate, job);
    }
    
    process.setAttribute("JobApplication", jobApplication);
    process.setAttribute("JobApplicationID", jobApplication.getID().longID());
%>
    <oneit:script>
        <oneit:script src="/scripts/password_strength_lightweight.js"/>
    </oneit:script>   
    <style>
        button[disabled] {
            opacity: 0.6;
            background-color: #0582ba;
        }
    </style>
    
    <oneit:form name="signIn" method="post" enctype="multipart/form-data">
        <%
            String  passkey =   Utils.getPwdKeyOfSecUser(request, secUser, true);
        %>
        <script type="text/javascript">
            $(document.body).addClass('bg-color');
            var  interval ;
            $(document).ready(function() {
                recalcFunction = setupRecalc ($("form#signIn"), {'recalcOnError':true});
                interval =  setInterval(function() { validate(); }, 500);
                validate();
                $('input').on('change keyup', function() { validate(); });
              
               $('#myPassword').strength_meter({
                    "inputName" : "<%= passkey %>"
                });
            });
 
            function validate() {
                var empty = false;
                $('input[required]').each(function() {
                    if ($( this ).val() == '') {
                        empty = true;
                        if ($( this ).css('background-color') == 'rgb(250, 255, 189)') {
                           empty = false;
                        }
                    }
                });

                if (empty) {
                    $('.verify-btn').attr('disabled', 'disabled');
                } else {
                    $('.verify-btn').removeAttr('disabled');
                     clearInterval(interval);
                }
            }
        </script>
        <script src="https://maps.googleapis.com/maps/api/js?v=3.exp&libraries=places&key=AIzaSyCaBh-MsMb8BBYJD_NcFzoCmygQbt5-QSw"></script>
        <oneit:script>
            <oneit:script src="/scripts/google_address.js"/>
        </oneit:script>
        <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>
        <div class="apply-job-logo-header signinpage">
            <div>
                <div class="logo-img">
                <%
                    BinaryContent   logo    =   job.getLogo();

                    if(logo != null)
                    {
                        int logoHeight  =   45;
                %>
                        <tagfile:img src="<%= ThumbnailUtils.filterImage(DiskFileBinaryContent.getRelativeURL(logo), "KEEP", new ScaleWithin (0, logoHeight)) %>" />
                <%
                    }
                %>
                </div>
                <div class="header-title">
                    <%= job.getTeamName() %>
                </div>
            </div>
        </div>
        <div class="main-verify-identity">
       
            <div class="pl-confirm text-center">Please confirm your details to continue</div>
            <div class="main-box-layout main-verify-step-2">
                <div class="form-group text-left">
                    <label>Email Address</label>
                    <oneit:ormInput obj="<%= secUser %>"        type="text" attributeName="UserName"    cssClass="form-control second-style"    disabled="true" readonly="true"/>
                </div>
                <div class="row">
                    <div class="form-group text-left col-sm-6 col-xs-12">
                        <label><oneit:ormlabel  obj="<%= secUser %>"    field="FirstName" /></label>
                        <oneit:ormInput obj="<%= secUser %>"    type="text" attributeName="FirstName"   cssClass="form-control second-style"    required="true"/>
                    </div>
                    <div class="form-group text-left col-sm-6 col-xs-12">
                        <label><oneit:ormlabel  obj="<%= secUser %>"    field="LastName" /></label>
                        <oneit:ormInput obj="<%= secUser %>"    type="text" attributeName="LastName"    cssClass="form-control second-style"    required="true"/>
                    </div>
                </div>
                <div class="form-group text-left">
                    <label><oneit:ormlabel  obj="<%= candidate %>"    field="Phone" /></label>
                    <oneit:ormInput obj="<%= candidate %>"      type="text" attributeName="Phone"       cssClass="form-control second-style"    required="true"/>
                </div>
                <hr class="seperate-line">
                <div class="form-group text-left">
                    <label>Location</label>
                    <oneit:ormInput obj="<%= candidate %>" type="text" attributeName="GoogleAddressText" class="autoAddress" id="<%= "gAddress_"+candidate.getObjectID() %>" placeholder="Enter your address" cssClass="form-control" />
                </div>
                <div class="form-group text-left" style="margin-top: 30px;">
                    <div class="styled_checkboxes">
                        <div class="checkbox checkbox-primary">
                            <oneit:ormInput obj="<%= jobApplication %>"  id="prefer-remote"    attributeName="PreferRemote"  type="checkbox"/>
                            <oneit:recalcClass  htmlTag="span"  classScript="jobApplication.showPreferRemote() ? 'checked': 'unchecked'"    jobApplication="<%= jobApplication %>">
                                <label for="prefer-remote">
                                    <oneit:label GUIName="I would prefer to work remotely" />
                                </label>
                            </oneit:recalcClass>
                        </div>
                    </div>
                </div>
                <oneit:recalcClass  htmlTag="div"  classScript="jobApplication.isFarFromJob() ? 'show': 'hide'"    jobApplication="<%= jobApplication %>">
                    <div class="relocate-warning-box">               
                        <p>
                            We noticed that your location is different to the location of the job (Melbourne, 3000).
                        </p>
                        <p>
                            Are you prepared to relocate for this position?
                        </p>   

                        <div class="styled_checkboxes">
                            <div class="checkbox checkbox-primary">
                                <oneit:ormInput obj="<%= jobApplication %>"  id="happy-to-relocate"  attributeName="HappyToRelocate" type="checkbox" />
                                <oneit:recalcClass  htmlTag="span"  classScript="jobApplication.showHappyToRelocate() ? 'checked': 'unchecked'"    jobApplication="<%= jobApplication %>">
                                    <label for="happy-to-relocate">
                                        <oneit:label GUIName="Yes, I am happy to relocate"/>
                                    </label>
                                </oneit:recalcClass>
                            </div>
                        </div>
                       <span class="warning-icon"></span>
                    </div>  
                </oneit:recalcClass>

                <%
                    if(isVerify)
                    {
                %>
                        <div class="form-group text-left"   id="myPassword">
                            <label>Password</label>
                        </div>
                        <div class="form-group text-left">
                            <label>Confirm password</label>
                            <oneit:input    type="password" name="<%= passkey + 2 %>"   class="form-control second-style reset-pw"/>
                        </div>
                <%
                    }
                %>
                <div class="form-group text-left">
                    <div class="styled_checkboxes">
                        <div class="checkbox checkbox-primary">
                            <oneit:ormInput obj="<%= candidate %>"  id="privacy-policy-agreed"  attributeName="PrivacyPolicyAgreed" type="checkbox" />
                            <oneit:recalcClass  htmlTag="span"  classScript="candidate.showPrivacyPolicyAgreed() ? 'checked': 'unchecked'"    candidate="<%= candidate %>">
                                <label for="privacy-policy-agreed">
                                    <oneit:label GUIName="I have read and agree to the " />
                                    <a href="https://www.talentology.com/privacy/" target="_blank" class="privacy-link">Privacy Policy</a>
                                </label>
                            </oneit:recalcClass>
                        </div>
                    </div>
                </div>
                <div class="form-group text-left">
                    <div class="styled_checkboxes">
                        <div class="checkbox checkbox-primary">
                            <oneit:ormInput obj="<%= candidate %>"  id="conditions-agreed"  attributeName="ConditionsAgreed" type="checkbox"    />
                            <oneit:recalcClass  htmlTag="span"  classScript="candidate.showConditionsAgreed() ? 'checked': 'unchecked'"    candidate="<%= candidate %>">
                                <label for="conditions-agreed">
                                    <oneit:label GUIName="I have read and agree to the " />
                                    <a href="https://www.talentology.com/terms-of-service/" target="_blank" class="privacy-link">Terms & Conditions</a>
                                </label>
                            </oneit:recalcClass>
                        </div>
                    </div>
                </div>
                <div class="text-center">
                    <oneit:button   value="Verify and proceed"   name="verifyIdentity"   cssClass="box-btn   verify-btn"
                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                    .mapEntry("Job",job)
                                                                    .mapEntry("Candidate",candidate)
                                                                    .mapEntry("JobApplication",jobApplication)
                                                                    .mapEntry("isVerify",isVerify)
                                                                    .toMap() %>"/>
                </div>
            </div>
        </div>
        <script>
            addGoogleAddressListener('#<%= "gAddress_"+ candidate.getObjectID() %>');
        </script>
    </oneit:form>
</oneit:dynIncluded>