package performa.form;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oneit.logging.*;
import oneit.objstore.ObjectTransaction;
import oneit.objstore.StorageException;
import oneit.servlets.forms.*;
import oneit.servlets.process.*;
import oneit.utils.BusinessException;
import performa.orm.*;


public class ChangeCultureCriteriaFP extends ORMProcessFormProcessor
{
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        HttpServletRequest  request =   submission.getRequest();
        ObjectTransaction   objTran =   process.getTransaction();
        Job                 job     =   (Job) request.getAttribute("Job");

        LogMgr.log(Job.LOG, LogLevel.PROCESSING1, "Inside ChangeCultureCriteriaFP for ", job , " Include Culture:", job.getIncludeCulture());
        
        if(!job.isTrue(job.getIncludeCulture()))
        {
            for(CultureCriteria cultureCriteria : job.getCultureCriteriasSet())
            {
                cultureCriteria.delete();
            }
            
            job.setSaveCultureTemplate(false);
            job.setCultureTemplate(null);
        }
        else
        {
            for(CultureElement cultureElement : CultureElement.searchAll(objTran))
            {
                CultureCriteria cultureCriteria =   CultureCriteria.createCultureCriteria(objTran);

                cultureCriteria.setCultureElement(cultureElement);
                job.addToCultureCriterias(cultureCriteria);
            }
        }
        
        LogMgr.log(Job.LOG, LogLevel.PROCESSING1, "ChangeCultureCriteriaFP completed for ",  job);
        
        return RedisplayResult.getInstance();
    }
}

