<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<%
    JobApplication  jobApplication  =   (JobApplication) process.getAttribute("JobApplication");
    Job             job             =   jobApplication.getJob();
    Candidate       candidate       =   jobApplication.getCandidate();
    String          tabText         =   candidate.getToString();
    String          currentPage     =   WebUtils.getSamePageInRenderMode(request, WebUtils.VIEW_APPLICATION);
%>

<oneit:dynIncluded>
<script>
    function tabToggle(tab) {
        $(".nav-justified li").each(function() {
            $(this).removeClass('active');
        });

        $(tab).addClass('active');
    }
</script>

<div class="main-applicant-content">
    <div class="applicant-header">
        <div class="main-appli-name">
            <div class="appli-name"><oneit:toString value="<%= candidate.getToString() %>"  mode="EscapeHTML"/></div>
            <div class="appli-applied">
                Applied <oneit:toString  value="<%= job.getObjectCreated() %>"    mode="MidDate"/>
            </div>
        </div>
        <div class="main-export">
            <span class="export-candidate"  style="display: none;">
                <select class="form-control">
                    <option>Export Candidate Report</option>
                    <option>PDF</option>
                    <option>Excel</option>
                </select>
            </span>
            <span class="appli-status-short">
                <oneit:ormEnum  obj="<%= jobApplication %>" onChange="$('#saveBtn').click()"  attributeName="ApplicationStatus"   cssClass="form-control status-img"
                                enums="<%= jobApplication.getAvailableStatuses() %>"/>
                <oneit:button   name="save" value="Save"    cssClass="hidden"   id="saveBtn"
                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", currentPage)
                                                                .mapEntry ("attribNamesToRestore", new HashSet<String> (Arrays.asList(new String[] {"Job", "JobApplication"})))
                                                                .mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).mapEntry("Job", job).toMap())
                                                                .mapEntry ("restartProcess", Boolean.TRUE).toMap() %>" />
            </span>
        </div>
    </div>
    <div class="applicant-sub-part">
        <div class="applicant-left">
            <div class="applicant-progress">
                <div class="col-sm-4 col-xs-12 text-center" href="#1a" data-toggle="tab"    id="progress1"  onClick="tabToggle('#tab1')">
                    <label class="progress-label">role fit</label>
                    <div class="percent-green fixed-width">
                        <p style="display:none;">83%</p>
                    </div>
                </div>
                <div class="col-sm-4 col-xs-12 text-center" href="#2a" data-toggle="tab"    id="progress2"  onClick="tabToggle('#tab2')">
                    <label class="progress-label">culture fit</label>
                    <div class="percent-green fixed-width">
                        <p style="display:none;"><oneit:toString value="<%= jobApplication.getCulturePercentage() %>"   mode="PercentageWholeNumber" /></p>
                    </div>
                </div>
                <div class="col-sm-4 col-xs-12 text-center" href="#3a" data-toggle="tab"    id="progress3"  onClick="tabToggle('#tab3')">
                    <label class="progress-label">requirements</label>
                    <div class="percent-blue fixed-width">
                        <p style="display:none;"><oneit:toString value="<%= jobApplication.getCriteriaPercentage() %>"   mode="PercentageWholeNumber" /></p>
                    </div>
                </div>
            </div>
            <div class="applicant-tab">
                <ul class="nav nav-pills nav-justified">
                    <li id="tab1" class="active"><a href="#1a" data-toggle="tab">role fit</a>s</li>
                    <li id="tab2"><a href="#2a" data-toggle="tab">culture fit</a></li>
                    <li id="tab3"><a href="#3a" data-toggle="tab">requirements</a></li>
                    <li id="tab4"><a href="#4a" data-toggle="tab">areas of concern</a></li>
                </ul>
                <div class="tab-content clearfix">
                    <div class="tab-pane active" id="1a">
                        <div class="main-pro-bar">
                            <div class="pro-bar">
                                <span class="appli-label">Career Drive</span>
                                <span class="appli-percen">82%</span>
                                <span class="appli-progress-bar">
                                    <div class="progress">
                                        <div class="progress-bar" role="progressbar" aria-valuenow="82" aria-valuemin="0" aria-valuemax="100" style="width:82%"></div>
                                    </div>
                                </span>
                                <span class="expand-box">
                                <span><img src="images/select-top-arrow.png"></span>
                                </span>
                            </div>
                            <div class="expand-hide-tag" style="display: block;">
                                <div class="tab-row">
                                    <div class="tab-view-label">
                                        Achievement
                                    </div>
                                    <div class="tab-view-side">
                                        <div class="result-want">
                                            <div class="result">Not results focused</div>
                                            <div class="wants">Wants results</div>
                                        </div>
                                        <div class="result-bar">
                                            <ul>
                                                <li class="red-b" style="width: 26.5%;"></li>
                                                <li class="yellow-b" style="width: 26.5%;"></li>
                                                <li class="green-b" style="width: 47%;"></li>
                                            </ul>
                                            <span class="triangle-arrow" style="left: 48%;"></span>
                                        </div>
                                        <div class="like-strive">Likely to strive to achive results</div>
                                    </div>
                                </div>
                                <div class="tab-row">
                                    <div class="tab-view-label">
                                        Remuneration
                                    </div>
                                    <div class="tab-view-side">
                                        <div class="result-want">
                                            <div class="result">Low concern</div>
                                            <div class="wants">High concern</div>
                                        </div>
                                        <div class="result-bar">
                                            <ul>
                                                <li class="red-b" style="width: 23.2%;"></li>
                                                <li class="yellow-b" style="width: 57.6%;"></li>
                                                <li class="green-b" style="width: 19.2%;"></li>
                                            </ul>
                                            <span class="triangle-arrow" style="left: 72%;"></span>
                                        </div>
                                        <div class="like-strive">Financial reward is less of a motivation than many other factors</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="main-pro-bar">
                            <div class="pro-bar">
                                <span class="appli-label">Conflict Management Style</span>
                                <span class="appli-percen">82%</span>
                                <span class="appli-progress-bar">
                                    <div class="progress">
                                        <div class="progress-bar" role="progressbar" aria-valuenow="82" aria-valuemin="0" aria-valuemax="100" style="width:82%"></div>
                                    </div>
                                </span>
                                <span class="expand-box">
                                <span class="hasarrow"><img src="images/select-down-arrow.png" /></span>
                                </span>
                            </div>
                            <div class="expand-hide-tag">
                                <div class="tab-row">
                                    <div class="tab-view-label">
                                        Achievement
                                    </div>
                                    <div class="tab-view-side">
                                        <div class="result-want">
                                            <div class="result">Not results focused</div>
                                            <div class="wants">Wants results</div>
                                        </div>
                                        <div class="result-bar">
                                            <ul>
                                                <li class="red-b" style="width: 26.5%;"></li>
                                                <li class="yellow-b" style="width: 26.5%;"></li>
                                                <li class="green-b" style="width: 47%;"></li>
                                            </ul>
                                            <span class="triangle-arrow" style="left: 48%;"></span>
                                        </div>
                                        <div class="like-strive">Likely to strive to achive results</div>
                                    </div>
                                </div>
                                <div class="tab-row">
                                    <div class="tab-view-label">
                                        Remuneration
                                    </div>
                                    <div class="tab-view-side">
                                        <div class="result-want">
                                            <div class="result">Low concern</div>
                                            <div class="wants">High concern</div>
                                        </div>
                                        <div class="result-bar">
                                            <ul>
                                                <li class="red-b" style="width: 23.2%;"></li>
                                                <li class="yellow-b" style="width: 57.6%;"></li>
                                                <li class="green-b" style="width: 19%;"></li>
                                            </ul>
                                            <span class="triangle-arrow" style="left: 72%;"></span>
                                        </div>
                                        <div class="like-strive">Financial reward is less of a motivation than many other factors</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="main-pro-bar">
                            <div class="pro-bar">
                                <span class="appli-label">Coping</span>
                                <span class="appli-percen blue">78%</span>
                                <span class="appli-progress-bar">
                                    <div class="progress">
                                        <div class="progress-bar" role="progressbar" aria-valuenow="78" aria-valuemin="0" aria-valuemax="100" style="width:78%"></div>
                                    </div>
                                </span>
                                <span class="expand-box">
                                <span class="hasarrow"><img src="images/select-down-arrow.png" /></span>
                                </span>
                            </div>
                            <div class="expand-hide-tag">
                                <div class="tab-row">
                                    <div class="tab-view-label">
                                        Achievement
                                    </div>
                                    <div class="tab-view-side">
                                        <div class="result-want">
                                            <div class="result">Not results focused</div>
                                            <div class="wants">Wants results</div>
                                        </div>
                                        <div class="result-bar">
                                            <ul>
                                                <li class="red-b" style="width: 26.5%;"></li>
                                                <li class="yellow-b" style="width: 26.5%;"></li>
                                                <li class="green-b" style="width: 47%;"></li>
                                            </ul>
                                            <span class="triangle-arrow" style="left: 48%;"></span>
                                        </div>
                                        <div class="like-strive">Likely to strive to achive results</div>
                                    </div>
                                </div>
                                <div class="tab-row">
                                    <div class="tab-view-label">
                                        Remuneration
                                    </div>
                                    <div class="tab-view-side">
                                        <div class="result-want">
                                            <div class="result">Low concern</div>
                                            <div class="wants">High concern</div>
                                        </div>
                                        <div class="result-bar">
                                            <ul>
                                                <li class="red-b" style="width: 23.2%;"></li>
                                                <li class="yellow-b" style="width: 57.6%;"></li>
                                                <li class="green-b" style="width: 19%;"></li>
                                            </ul>
                                            <span class="triangle-arrow" style="left: 72%;"></span>
                                        </div>
                                        <div class="like-strive">Financial reward is less of a motivation than many other factors</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="main-pro-bar">
                            <div class="pro-bar">
                                <span class="appli-label">People Orientation</span>
                                <span class="appli-percen gray">68%</span>
                                <span class="appli-progress-bar">
                                    <div class="progress">
                                        <div class="progress-bar" role="progressbar" aria-valuenow="68" aria-valuemin="0" aria-valuemax="100" style="width:68%"></div>
                                    </div>
                                </span>
                                <span class="expand-box">
                                <span class="hasarrow"><img src="images/select-down-arrow.png" /></span>
                                </span>
                            </div>
                            <div class="expand-hide-tag">
                                <div class="tab-row">
                                    <div class="tab-view-label">
                                        Achievement
                                    </div>
                                    <div class="tab-view-side">
                                        <div class="result-want">
                                            <div class="result">Not results focused</div>
                                            <div class="wants">Wants results</div>
                                        </div>
                                        <div class="result-bar">
                                            <ul>
                                                <li class="red-b" style="width: 26.5%;"></li>
                                                <li class="yellow-b" style="width: 26.5%;"></li>
                                                <li class="green-b" style="width: 47%;"></li>
                                            </ul>
                                            <span class="triangle-arrow" style="left: 48%;"></span>
                                        </div>
                                        <div class="like-strive">Likely to strive to achive results</div>
                                    </div>
                                </div>
                                <div class="tab-row">
                                    <div class="tab-view-label">
                                        Remuneration
                                    </div>
                                    <div class="tab-view-side">
                                        <div class="result-want">
                                            <div class="result">Low concern</div>
                                            <div class="wants">High concern</div>
                                        </div>
                                        <div class="result-bar">
                                            <ul>
                                                <li class="red-b" style="width: 23.2%;"></li>
                                                <li class="yellow-b" style="width: 57.6%;"></li>
                                                <li class="green-b" style="width: 19%;"></li>
                                            </ul>
                                            <span class="triangle-arrow" style="left: 72%;"></span>
                                        </div>
                                        <div class="like-strive">Financial reward is less of a motivation than many other factors</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane" id="2a">
                        <%
                            Map<CultureClass, Long> cultureFitData  =   AnalysisEngine.getCultureFit(jobApplication.getCultureCriteriaAnswersSet());
                            
                            for(CultureClass cClass: cultureFitData.keySet())
                            {
                                if(cClass==null)
                                {
                                    continue;
                                }
                                
                                Long    rating  =   cultureFitData.get(cClass);
                        %>
                                <div class="main-pro-bar">
                                    <div class="pro-bar">
                                        <span class="appli-label"><oneit:toString   value="<%= cClass %>"   mode="EscapeHTML"/></span>
                                        <span class="appli-percen"><oneit:toString  value="<%= rating %>"   mode="PercentageWholeNumber" /></span>
                                        <span class="appli-progress-bar">
                                            <div class="progress">
                                                <div class="progress-bar" role="progressbar" aria-valuenow="<%= rating %>" aria-valuemin="0" aria-valuemax="100" style="width:<%= rating %>%"></div>
                                            </div>
                                        </span>
                                        <span class="expand-box">
                                        <span class="hasarrow"><img src="images/select-down-arrow.png" /></span>
                                        </span>
                                    </div>
                                    <div class="expand-hide-tag">
                                        <div class="tab-row">
                                            <div class="tab-view-label">
                                                Achievement
                                            </div>
                                            <div class="tab-view-side">
                                                <div class="result-want">
                                                    <div class="result">Not results focused</div>
                                                    <div class="wants">Wants results</div>
                                                </div>
                                                <div class="result-bar">
                                                    <ul>
                                                        <li class="red-b" style="width: 26.5%;"></li>
                                                        <li class="yellow-b" style="width: 26.5%;"></li>
                                                        <li class="green-b" style="width: 47%;"></li>
                                                    </ul>
                                                    <span class="triangle-arrow" style="left: 48%;"></span>
                                                </div>
                                                <div class="like-strive">Likely to strive to achive results</div>
                                            </div>
                                        </div>
                                        <div class="tab-row">
                                            <div class="tab-view-label">
                                                Remuneration
                                            </div>
                                            <div class="tab-view-side">
                                                <div class="result-want">
                                                    <div class="result">Low concern</div>
                                                    <div class="wants">High concern</div>
                                                </div>
                                                <div class="result-bar">
                                                    <ul>
                                                        <li class="red-b" style="width: 23.2%;"></li>
                                                        <li class="yellow-b" style="width: 57.6%;"></li>
                                                        <li class="green-b" style="width: 19%;"></li>
                                                    </ul>
                                                    <span class="triangle-arrow" style="left: 72%;"></span>
                                                </div>
                                                <div class="like-strive">Financial reward is less of a motivation than many other factors</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                        <%
                            }
                        %>
                    </div>
                    <div class="tab-pane" id="3a">
                        <%
                            Map<Importance, Long>   requirementFitData  =   AnalysisEngine.getRequirementFit(jobApplication.getAssessmentCriteriaAnswersSet());
                            
                            for(Importance importance: requirementFitData.keySet())
                            {
                                if(importance==null)
                                {
                                    continue;
                                }
                                
                                Long    rating  =   requirementFitData.get(importance);
                        %>
                                <div class="main-pro-bar">
                                    <div class="pro-bar">
                                        <span class="appli-label"><oneit:toString   value="<%= importance %>"   mode="EscapeHTML"/></span>
                                        <span class="appli-percen"><oneit:toString  value="<%= rating %>"   mode="PercentageWholeNumber" /></span>
                                        <span class="appli-progress-bar">
                                            <div class="progress">
                                                <div class="progress-bar" role="progressbar" aria-valuenow="<%= rating %>" aria-valuemin="0" aria-valuemax="100" style="width:<%= rating %>%"></div>
                                            </div>
                                        </span>
                                        <span class="expand-box">
                                        <span class="hasarrow"><img src="images/select-down-arrow.png" /></span>
                                        </span>
                                    </div>
                                    <div class="expand-hide-tag">
                                        <div class="tab-row">
                                            <div class="tab-view-label">
                                                Achievement
                                            </div>
                                            <div class="tab-view-side">
                                                <div class="result-want">
                                                    <div class="result">Not results focused</div>
                                                    <div class="wants">Wants results</div>
                                                </div>
                                                <div class="result-bar">
                                                    <ul>
                                                        <li class="red-b" style="width: 26.5%;"></li>
                                                        <li class="yellow-b" style="width: 26.5%;"></li>
                                                        <li class="green-b" style="width: 47%;"></li>
                                                    </ul>
                                                    <span class="triangle-arrow" style="left: 48%;"></span>
                                                </div>
                                                <div class="like-strive">Likely to strive to achive results</div>
                                            </div>
                                        </div>
                                        <div class="tab-row">
                                            <div class="tab-view-label">
                                                Remuneration
                                            </div>
                                            <div class="tab-view-side">
                                                <div class="result-want">
                                                    <div class="result">Low concern</div>
                                                    <div class="wants">High concern</div>
                                                </div>
                                                <div class="result-bar">
                                                    <ul>
                                                        <li class="red-b" style="width: 23.2%;"></li>
                                                        <li class="yellow-b" style="width: 57.6%;"></li>
                                                        <li class="green-b" style="width: 19%;"></li>
                                                    </ul>
                                                    <span class="triangle-arrow" style="left: 72%;"></span>
                                                </div>
                                                <div class="like-strive">Financial reward is less of a motivation than many other factors</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                        <%
                            }
                        %>
                    </div>
                    <div class="tab-pane" id="4a">
                    </div>
                </div>
            </div>
        </div>
        <div class="applicant-right">
            
            <div class="app-right-b">
                <div class="overall-suit">overall rank</div>
                <div class="big-percentage">                        
                    <oneit:toString value="<%= jobApplication.getOverallSuitability() %>"   mode="Integer" />
                </div>
            </div>
            <div class="applicant-contact-info">
                <div class="contact-title">Contact</div>
                <div class="contact-row">
                    <div class="contact-label">E</div>
                    <div class="contact-value">
                        <a href="<%= "mailto:" + candidate.getUser().getUserName() %>">
                            <oneit:toString value="<%= candidate.getUser().getUserName() %>" mode="EscapeHTML" />
                        </a>
                    </div>
                </div>
                <div class="contact-row">
                    <div class="contact-label">P</div>
                    <div class="contact-value">
                        <oneit:toString value="<%= candidate.getPhone() %>" mode="EscapeHTML" />
                    </div>
                </div>
                <div class="contact-row"    style="display: none;">
                    <div class="contact-label"><img src="images/linkdin-icon.png" /></div>
                    <div class="contact-value"><a href="#">View LinkedIn profile</a></div>
                </div>
                <div class="contact-row"    style="display: none;">
                    <div class="contact-label"><img src="images/download-icon.png" /></div>
                    <div class="contact-value"><a href="#">Download Resume</a></div>
                </div>
            </div>
            <div class="applicant-note" style="display: none;">
                <div class="applicant-note-title">Notes</div>
                <div class="note-txt-box">
                    <textarea class="form-control"></textarea>
                    <input type="button" class="add-note-btn" value="ADD NOTE" />
                </div>
            </div>
            <div class="admin-notes"    style="display: none;">
                <div class="admin-name">Admin name</div>
                <div class="date-value">TODAY</div>
                <div class="admin-text">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent accumsan interdum nisi, sed laoreet dui rhoncus.</div>
                <div class="admin-br-line"></div>
                <div class="admin-name">Admin name</div>
                <div class="date-value">2 days ago</div>
                <div class="admin-text">Lorem ipsum dolor sit amet, consectetur adipiscing elit.</div>
            </div>
        </div>
    </div>
</div>

</oneit:dynIncluded>