import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { Subscription } from 'rxjs/Subscription';
import { MessageTemplateModel } from '../../models/messageTemplateModel';

import { BaseComponent } from '../base/base.component';

import { AppService } from '../../app.service';
import { SearchService } from '../../oneit/services/search.service';
import { UtilsService } from '../../oneit/services/utils.service';
import { ListMessageTemplateService } from './list-message-template.service';

@Component({
  selector: 'app-list-message-template',
  templateUrl: './list-message-template.component.html',
  styleUrls: ['./list-message-template.component.scss']
})
export class ListMessageTemplateComponent extends BaseComponent implements OnInit {

  subscriptions: Array<Subscription> = [];
  myMessageTemplates: Array<MessageTemplateModel> = [];
  sharedMessageTemplates: Array<MessageTemplateModel> = [];
  showLoader = false;
  sortOptions: Array<SorterClass>;
  sortSelected: SorterClass;

  constructor(
    private router: Router,
    private activatedRoute: ActivatedRoute,
    private utilsService: UtilsService,
    private searchService: SearchService,
    private appService: AppService,
    private listMessageTemplateService: ListMessageTemplateService
  ) {
    super(utilsService);
  }

  ngOnInit(): void {
    this.sortOptions = [
      new SorterClass('Alphabetical (A-Z)', true),
      new SorterClass('Alphabetical (Z-A)', false)
    ];
    this.showLoader = true;
    const sharedMsgParams = {
      OnlyGlobalTemplate: true
    };
    const myMsgParams = {
      OnlyGlobalTemplate: false
    };
    this.subscriptions.push(
      this.listMessageTemplateService
        .getMessageTemplates(myMsgParams, [])
        .subscribe(
          messages => {
            this.myMessageTemplates = messages;
          },
          error => {
            this.showLoader = false;
            this.utilsService.handleError(error);
          }
        )
    );
    this.subscriptions.push(
      this.listMessageTemplateService
        .getMessageTemplates(sharedMsgParams, [])
        .subscribe(
          messages => {
            this.sharedMessageTemplates = messages;
          },
          error => {
            this.showLoader = false;
            this.utilsService.handleError(error);
          }
        )
    );
    setTimeout(() => (this.showLoader = false), 0);
  }

  sortMessageTemplates(): void {
    this.showLoader = true;

    if (this.sortSelected.ascending) {
      this.myMessageTemplates = this.utilsService.sort(this.myMessageTemplates, ['TemplateName'], [1], false);
      this.sharedMessageTemplates = this.utilsService.sort(this.sharedMessageTemplates, ['TemplateName'], [1], false);
    } else {
      this.myMessageTemplates = this.utilsService.sort(this.myMessageTemplates, ['TemplateName'], [-1], false);
      this.sharedMessageTemplates = this.utilsService.sort(this.sharedMessageTemplates, ['TemplateName'], [-1], false);
    }

    this.showLoader = false;
  }

  onRowSelect(data): void {
    this.showLoader = true;
    this.router.navigate(['/edit-message-template', data.ObjectID]);
  }
}

export class SorterClass {
  description;
  ascending;

  constructor(des: string, sort: boolean) {
    this.description = des;
    this.ascending = sort;
  }
}
