package performa.form;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.objstore.StorageException;
import oneit.servlets.forms.RedisplayResult;
import oneit.servlets.forms.SubmissionDetails;
import oneit.servlets.forms.SuccessfulResult;
import oneit.servlets.process.ORMProcessFormProcessor;
import oneit.servlets.process.ORMProcessState;
import oneit.utils.BusinessException;
import performa.orm.*;
import performa.orm.types.JobStatus;

/**
 *
 * @author nilu
 */
public class LoadJobFromTemplateFP extends ORMProcessFormProcessor
{
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        HttpServletRequest  request     =   submission.getRequest();
        Job                 job         =   (Job) request.getAttribute("Job");
        Job                 jobTemplate =   job.getJobTemplate();
        
        LogMgr.log(Job.LOG, LogLevel.PROCESSING1, "Inside LoadJobFromTemplateFP for ", job, " load from template:", jobTemplate);

        for(CultureCriteria criteria : job.getCultureCriteriasSet())
        {
            criteria.delete();
        }
        
        for(AssessmentCriteria  criteria : job.getAssessmentCriteriasSet())
        {
            criteria.delete();
        }
        
        jobTemplate.cloneJob(job);

        job.initAttribs();
        job.setJobStatus(JobStatus.DRAFT);
        job.setApplyBy(null);
        job.setOpenDate(null);
        job.setReferenceNumber(null);
        job.setCompletedDetails(Boolean.TRUE);
        job.setCompletedAssessmentType(Boolean.TRUE);
        job.setCompletedRequirements(Boolean.TRUE);
        job.setCompletedCulture(Boolean.TRUE);
        
        LogMgr.log(Job.LOG, LogLevel.PROCESSING1, "LoadJobFromTemplateFP completed for ", job);
        
        return RedisplayResult.getInstance();
    }
}