import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { MessageTemplateModel } from "./models/messageTemplate.model";
import { PlaceholderOptionsEnum } from './models/placeholderOptions.enum';
import { TemplateTypeEnum } from './models/templateType.enum';
import { EnumService } from './oneit/services/enum.service';
import { SearchService } from './oneit/services/search.service';
import { UtilsService } from './oneit/services/utils.service';

@Injectable()

export class AppService {

    constructor(
        private enumService: EnumService,
        private searchService: SearchService,
        private utilsService: UtilsService
    ) {

    }

    getMessageTemplateTypeEnum(): Observable<Array<TemplateTypeEnum>> {
        return this.enumService.getEnums('TemplateTypes', true);
    }

    getPlaceholderOptionsEnum(): Observable<Array<PlaceholderOptionsEnum>> {
        return this.enumService.getEnumsWithNULLOptionLabel('PlaceholderOptions', 'Select variable');
    }

    getTypes(serviceName: string, includeNull = false, blankLabel = null): Observable<Array<any>> {
        return includeNull ? this.enumService.getEnumsWithNULLOptionLabel(serviceName, blankLabel) :
            this.enumService.getEnums(serviceName, true);
    }

    getSearchListing(serviceName: string, queryType: string, queryParams, assocs, searchName): Observable<Array<any>> {
        return this.searchService.searchAndSaveSearchRequest(serviceName, queryType,
            queryParams, assocs, null, null, null, null, searchName, false)
            .map(
                data =>
                    this.utilsService.convertResponseToObjects(data, assocs)
            );
    }

    getMessageTemplateByID(id, assocs): Observable<MessageTemplateModel> {
        return this.searchService.getObjectById('MessageTemplates', id, assocs)
            .map(
                data => {
                    const objs = this.utilsService.convertResponseToObjects(data, assocs);

                    if (objs && objs.length > 0) {
                        return objs[0];
                    }
                }
            );
    }
}
