<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<%
    Job[]       jobs        =   (Job[]) getData(request, "Jobs");
    JobStatus   jobStatus   =   (JobStatus) getData(request, "JobStatus"); 
    String      nextPage    =   (String)  getData(request, "NextPage");
    String      homePage    =   (String)  getData(request, "HomePage");
%>

<oneit:dynIncluded>
    
    <script type="text/javascript">
       
        $(document).ready(function() 
        {
            $(".job-row").click(function() 
            {
                var id  = $(this).closest('.job-list').attr('id');
                $('.' + id).click();
            });
            
            $(".job-status").change(function(){
                var id  = $(this).closest('.job-list').attr('id');
                $('.save-job' + id).click();
            });
            
        });
    </script>
    
    <div class="main-job-list">
    <%
        for(Job job: jobs)
        {
    %>
            <div class="job-list"   id="<%= job.getID() %>">
                <div class="job-row"   >
                    <div class="job-post jl-c eq-second-height" style="height: 107px;">
                        <div class="job-post-name">
                            <oneit:toString value="<%= job.getJobTitle() %>" mode="EscapeHTML" />
                            <oneit:button   value="EDIT"   name="gotoPage" cssClass="<%= job.getID() + " hidden"%>"   skin="link"
                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                        .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).toMap())
                                                                        .toMap() %>"/>
                        </div>
                        <div class="job-company-name">
                            <span class="superlaw">SUPERLAW</span>
                            <span class="calendar"><oneit:toString value="<%= job.getDaysTillClose() %>"    mode="EscapeHTML"/></span>
                        </div>
                    </div>
                    <div class="job-application jl-c eq-second-height" style="height: 107px;">
                        <div class="ja-icon"><img src="images/job-list-user.png"></div>
                        <div class="ja-count">
                            <oneit:toString value="<%= job.getNoOfCandidatesApplied() %>"   mode="EscapeHTML"   nullValue="0"/>
                            <span class="grey-span">Applicants</span>
                        </div>
                    </div>
                    <div class="job-shortlisted jl-c eq-second-height" style="height: 107px;">
                        <div class="ja-icon"><img src="images/circle.png"></div>
                        <div class="ja-count">
                            <oneit:toString value="<%= job.getNoOfCandidatesShortlisted() %>"   mode="EscapeHTML"   nullValue="0"/>/5
                            <span class="grey-span">shortlisted</span>
                        </div>
                    </div>
                </div>
                <div class="job-states jl-c">
                    <oneit:ormEnum  obj="<%= job %>" attributeName="JobStatus" cssClass="form-control status-img job-status"   
                                    enums="<%= Arrays.asList(new JobStatus[]{JobStatus.OPEN, JobStatus.COMPLETE}) %>"/>
                </div>
                <oneit:button   name="save" value="Save"    cssClass="<%= "save-job" +  job.getID().toString() + " hidden"%>"
                                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", homePage+ (jobStatus != null ? "&JobStatus=" + jobStatus : ""))
                                                                                                .mapEntry("Job", job)
                                                                                                .toMap() %>" />
            </div>
    <%
        }
    %>

    </div>
</oneit:dynIncluded>

