import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';
import { JobsComponent } from './jobs/jobs.component';
import { JobDetailsComponent } from './job/job-details/job-details.component';
import { JobProfileComponent } from './job/job-profile/job-profile.component';

const routes: Routes = [
    {
        path: '',
        component: JobsComponent
    },
    {
        path: 'new',
        component: JobDetailsComponent
    },
    {
        path: ':id',
        component: JobDetailsComponent
    },
    {
        path: ':id/profile',
        component: JobProfileComponent
    }
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule]
})
export class JobsRouting { }
