package performa.utils;

import javax.servlet.http.HttpServletRequest;
import oneit.business.content.Article;
import oneit.business.content.transform.ContentTransformFactory;
import oneit.components.DefaultInitialisable;
import oneit.objstore.ObjectTransaction;
import oneit.security.SecUser;
import oneit.utils.ObjectTransform;
import performa.orm.CompanyUser;
import performa.orm.HiringTeam;


public class MenuItemDisableTransformFactory implements ContentTransformFactory, DefaultInitialisable
{
    @Override
    public ObjectTransform createTransform(Article article, HttpServletRequest request, ObjectTransaction transaction)
    {
        return new MenuItemDisableTransform(article, request, transaction);
    }
    
    
    public class MenuItemDisableTransform implements ObjectTransform
    {
        Article             article;
        HttpServletRequest  request;
        ObjectTransaction   transaction;
        SecUser             secUser;
        CompanyUser         companyUser;
        HiringTeam          hiringTeam;
        
        public MenuItemDisableTransform(Article article, HttpServletRequest request, ObjectTransaction transaction)
        {
            HiringTeam selectedTeam =   (HiringTeam) request.getSession().getAttribute("SelectedHiringTeam");
            
            selectedTeam = selectedTeam != null ? selectedTeam.getInTransaction(transaction) : null;
            
            this.article        =   article;
            this.request        =   request;
            this.transaction    =   transaction;
            this.secUser        =   SecUser.getTXUser(transaction);
            this.companyUser    =   this.secUser != null ? this.secUser.getExtension(CompanyUser.REFERENCE_CompanyUser) : null;
            this.hiringTeam     =   selectedTeam != null ?  selectedTeam : this.companyUser != null ? this.companyUser.getSelectedTeam() : null;
        }
        
        @Override
        public Object transform(Object original)
        {
            if((Boolean)article.getAdditionalAttribute("Allow Disable", Boolean.FALSE) 
                && this.hiringTeam != null && !this.hiringTeam.showHasClientSupport())
            {
                return String.valueOf(original);
            }
            else
            {
                return "";
            }
        }
    }
}