
package performa.orm;

import java.io.*;
import java.util.*;
import java.sql.ResultSet;
import java.sql.SQLException;
import oneit.logging.*;
import oneit.objstore.*;
import oneit.objstore.assocs.*;
import oneit.objstore.rdbms.*;
import oneit.objstore.utils.*;
import oneit.sql.*;
import oneit.utils.resource.*;
import oneit.utils.*;
import oneit.utils.threading.*;



/**
 * IMPORTANT!!!! Autogenerated class, DO NOT EDIT!!!!!
 * Template: Infrastructure8.2[oneit.objstore.PersistenceMgrTemplate.xsl]
 */
public class CultureElementRatingPersistenceMgr extends ObjectPersistenceMgr
{
    private static final LoggingArea CultureElementRatingPersistence = LoggingArea.createLoggingArea(ObjectPersistenceMgr.OBJECT_PERSISTENCE, "CultureElementRating");

    // Private attributes corresponding to business object data
    private String dummyDescription;
    

    // Static constants corresponding to attribute helpers
    private static final DefaultAttributeHelper HELPER_Description = DefaultAttributeHelper.INSTANCE;
    



    public CultureElementRatingPersistenceMgr ()
    {
        dummyDescription = (String)(HELPER_Description.initialise (dummyDescription));
        
    }

    private String  SELECT_COLUMNS = "{PREFIX}rs_culture_element_rating.object_id as id, {PREFIX}rs_culture_element_rating.object_LAST_UPDATED_DATE as LAST_UPDATED_DATE, {PREFIX}rs_culture_element_rating.object_CREATED_DATE as CREATED_DATE, {PREFIX}rs_culture_element_rating.culture_element_rating_desc, {PREFIX}rs_culture_element_rating.culture_element_number,  1 AS commasafe ";
    private String SELECT_JOINS = "";

    public BaseBusinessClass fetchByID(ObjectID id, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    resultByIDs = fetchByIDs(Collections.singleton (id), allPSets, context, sqlMgr);

        if (resultByIDs.isEmpty ())
        {
            return null;
        }
        else if (resultByIDs.size () > 1)
        {
            throw new StorageException ("Multiple results for id:" + id);
        }
        else
        {
            return resultByIDs.iterator ().next ();
        }
    }



    public Set<BaseBusinessClass> fetchByIDs(Set<ObjectID> ids, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    results = new HashSet ();
        Set<Long> idsToFetch = new HashSet ();

        for (ObjectID id : ids)
        {
            if (context.containsObject(id)) // Check for cached version
            {
                BaseBusinessClass objectToReturn = context.getObjectToReplace(id, CultureElementRating.REFERENCE_CultureElementRating);

                if (objectToReturn instanceof CultureElementRating)
                {
                    LogMgr.log (CultureElementRatingPersistence, LogLevel.TRACE, "Cache hit for id:", id);
                    results.add (objectToReturn);
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + id + " with object " + objectToReturn + "while fetching a CultureElementRating");
                }
            }

            PersistentSet rs_culture_element_ratingPSet = allPSets.getPersistentSet(id, "rs_culture_element_rating", PersistentSetStatus.FETCHED);
            
            

             // Check for persistent sets already prefetched
            if (false  || !rs_culture_element_ratingPSet.containsAttrib(BaseBusinessClass.FIELD_ObjectLastModified) ||
                    !rs_culture_element_ratingPSet.containsAttrib(CultureElementRating.FIELD_Description)||
                    !rs_culture_element_ratingPSet.containsAttrib(CultureElementRating.SINGLEREFERENCE_CultureElement))
            {
                // We will need to retrieve it
                idsToFetch.add (id.longValue());
            }
            else
            {
                LogMgr.log (CultureElementRatingPersistence, LogLevel.DEBUG2, "Persistent set preloaded id:", id);
        
                /* Non Polymorphic */
                CultureElementRating result = new CultureElementRating ();

                result.setFromPersistentSets(id, allPSets);
                context.addRetrievedObject(result);

                results.add (result);
            
            }
        }

        if (idsToFetch.size () > 0)
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}rs_culture_element_rating " +
                            "WHERE " + SELECT_JOINS + "{PREFIX}rs_culture_element_rating.object_id IN ?";

            BaseBusinessClass[] resultsFetched = loadQuery (allPSets, sqlMgr, context, query, new Object[] { idsToFetch }, null, false);

            for (BaseBusinessClass objFetched : resultsFetched)
            {
                results.add (objFetched);
            }
        }


        return results;
    }



    public BaseBusinessClass[] getReferencedObjects(ObjectID _objectID, String refName, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        if (false)
        {
            throw new RuntimeException ();
        }
        else if (refName.equals (CultureElementRating.SINGLEREFERENCE_CultureElement))
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}rs_culture_element_rating " +
                            "WHERE " + SELECT_JOINS + "culture_element_number = ?";

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, new Object[] { _objectID.longID () }, null, false);

            return results;
        }
        else
        {
            throw new IllegalArgumentException ("Illegal reference type:" + refName);
        }
    }



    public void update(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        EqualityResult  test = EqualityResult.compare (obj, obj.getBackup ());
        ObjectID        objectID = obj.getID ();

        if (!test.areAttributesEqual () || !test.areSingleAssocsEqual () || obj.getForcedSave())
        {
            PersistentSet rs_culture_element_ratingPSet = allPSets.getPersistentSet(objectID, "rs_culture_element_rating");
            

            
            if (rs_culture_element_ratingPSet.getStatus () != PersistentSetStatus.PROCESSED &&
                rs_culture_element_ratingPSet.getStatus () != PersistentSetStatus.DEFERRED)
            {
                int rowsUpdated = executeStatement (sqlMgr, 
                                                           "UPDATE {PREFIX}rs_culture_element_rating " +
                                                           "SET culture_element_rating_desc = ?, culture_element_number = ?  , object_LAST_UPDATED_DATE = " + sqlMgr.getPortabilityServices ().getTimestampExpression () + " " +
                                                                
                                                           "WHERE rs_culture_element_rating.object_id = ? AND " + getConcurrencyCheck (sqlMgr, "object_LAST_UPDATED_DATE", obj.getObjectLastModified ()) + " ",
                                                           CollectionUtils.listEntry (HELPER_Description.getForSQL(dummyDescription, rs_culture_element_ratingPSet.getAttrib (CultureElementRating.FIELD_Description))).listEntry (SQLManager.CheckNull((Long)(rs_culture_element_ratingPSet.getAttrib (CultureElementRating.SINGLEREFERENCE_CultureElement)))).listEntry (objectID.longID ()).listEntry (obj.getObjectLastModified ()).toList().toArray());

                if (rowsUpdated != 1)
                {
                    // Error, either a concurrency error or a not-exists error
                    ResultSet r = executeQuery (sqlMgr, 
                                                       "SELECT object_id, object_LAST_UPDATED_DATE FROM {PREFIX}rs_culture_element_rating WHERE object_id = ?",
                                                       new Object[] { objectID.longID () });

                    if (r.next ())
                    {
                        Date                d = new java.util.Date (r.getTimestamp (2).getTime());
                        String              errorMsg = QueryBuilder.buildQueryString ("Concurrent update error:[?] for row:[?] objDate:[?] dbDate:[?]", 
                                                                         new Object[] { "rs_culture_element_rating", objectID.longID (), obj.getObjectLastModified (), d },
                                                                         sqlMgr.getPortabilityServices ());
                                                                         
                        LogMgr.log (CultureElementRatingPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new ConcurrentUpdateConflictException (obj, "rs_culture_element_rating");
                    }
                    else
                    {
                        String  errorMsg = "Attempt to update nonexistent row in table:rs_culture_element_rating for row:" + objectID + " objDate:" + obj.getObjectLastModified ();

                        LogMgr.log (CultureElementRatingPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new RuntimeException (errorMsg);
                    }
                }

                rs_culture_element_ratingPSet.setStatus (PersistentSetStatus.PROCESSED);
            }
            
        }
        else
        {
            LogMgr.log (CultureElementRatingPersistence, LogLevel.DEBUG1, "Skipping update since no attribs or simple assocs changed on ", objectID);
        }
    }



    public void delete(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        ObjectID        objectID = obj.getID ();
        PersistentSet rs_culture_element_ratingPSet = allPSets.getPersistentSet(objectID, "rs_culture_element_rating");
        

        LogMgr.log (CultureElementRatingPersistence, LogLevel.DEBUG2, "Deleting:", objectID);

        
        if (rs_culture_element_ratingPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            rs_culture_element_ratingPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            int rowsDeleted = executeStatement (sqlMgr, 
                                                       "DELETE " +
                                                       "FROM {PREFIX}rs_culture_element_rating " +
                                                       "WHERE rs_culture_element_rating.object_id = ? AND " + sqlMgr.getPortabilityServices ().getTruncatedTimestampColumn ("object_LAST_UPDATED_DATE") + " = " + sqlMgr.getPortabilityServices ().getTruncatedTimestampParam("?") + " ",
                                                       new Object[] { objectID.longID(), obj.getObjectLastModified () });

            if (rowsDeleted != 1)
            {
                // Error, either a concurrency error or a not-exists error
                ResultSet r = executeQuery (sqlMgr, 
                                                   "SELECT object_id FROM {PREFIX}rs_culture_element_rating WHERE object_id = ?",
                                                   new Object[] { objectID.longID() });

                if (r.next ())
                {
                    throw new ConcurrentUpdateConflictException (obj, "rs_culture_element_rating");
                }
                else
                {
                    String  errorMsg = "Attempt to delete nonexistent row in table:rs_culture_element_rating for row:" + objectID;

                    LogMgr.log (CultureElementRatingPersistence, LogLevel.SYSTEMERROR1, errorMsg);
                    throw new RuntimeException (errorMsg);
                }
            }

            rs_culture_element_ratingPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }


    public ResultSet executeSearchQueryAll (SQLManager sqlMgr) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryAll");
    }
    



    public BaseBusinessClass[] loadQuery (PersistentSetCollection allPSets, SQLManager sqlMgr, RDBMSPersistenceContext context, String query, Object[] params, Integer maxRows, boolean truncateExtra) throws SQLException, StorageException
    {
        LinkedHashMap<ObjectID, CultureElementRating> results = new LinkedHashMap ();
        
        ResultSet   r = executeQuery (sqlMgr, query, params);

        while (r.next())
        {
            ThreadUtils.checkInterrupted ();
            
            ObjectID    objectID = new ObjectID (CultureElementRating.REFERENCE_CultureElementRating.getObjectIDSpace (), r.getLong ("id"));
            CultureElementRating resultElement;

            if (maxRows != null && !results.containsKey (objectID) && results.size () >= maxRows)
            {
                if (truncateExtra)
                {
                    break;
                }
                else
                {
                    throw new SearchRowsExceededException ("Maximum rows exceeded:" + maxRows);
                }
            }

            if (context.containsObject(objectID))
            {
                BaseBusinessClass   cachedElement = context.getObjectToReplace(objectID, CultureElementRating.REFERENCE_CultureElementRating);

                if (cachedElement instanceof CultureElementRating)
                {
                    LogMgr.log (CultureElementRatingPersistence, LogLevel.TRACE, "Cache hit for id:", objectID);
                    resultElement = (CultureElementRating)cachedElement;
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + objectID + " with object " + cachedElement + "while fetching a CultureElementRating");
                }
            }
            else
            {
                PersistentSet rs_culture_element_ratingPSet = allPSets.getPersistentSet(objectID, "rs_culture_element_rating", PersistentSetStatus.FETCHED);
                
                createPersistentSetFromRS(allPSets, r, objectID);

                

                        resultElement = new CultureElementRating ();

                        resultElement.setFromPersistentSets(objectID, allPSets);
                        context.addRetrievedObject(resultElement);

                
            }

            results.put (objectID, resultElement);
        }

        

        BaseBusinessClass[] resultsArr = new BaseBusinessClass[results.size ()];

        return results.values ().toArray (resultsArr);
    }



    public BaseBusinessClass[] find(String searchType, PersistentSetCollection allPSets, Hashtable criteria, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        LogMgr.log (CultureElementRatingPersistence, LogLevel.DEBUG2, "Search executing:", searchType, " criteria:", criteria);
        String  customParamFilter = (String)criteria.get (SEARCH_CustomFilter);
        String  customOrderBy = (String)criteria.get (SEARCH_OrderBy);
        String  customTables = (String)criteria.get (SEARCH_CustomExtraTables);
        Boolean  noCommaBeforeCustomExtraTables = (Boolean)criteria.get (SEARCH_CustomExtraTablesNoComma);

        if (searchType.equals (SEARCH_CustomSQL))
        {
            Set<ObjectID>                     processedIDs = new HashSet();
            SearchParamTransform    tx = new SearchParamTransform (criteria);
            Object[]                searchParams;

            customParamFilter = StringUtils.replaceParams (customParamFilter, tx);
            searchParams = tx.getParamsArray();

            if (customOrderBy != null) 
            {
                customOrderBy = " ORDER BY " + customOrderBy;
            }
            else
            {
                customOrderBy = "";
            }


            ResultSet   r;
            String      concatCustomTableWith = CollectionUtils.equals(noCommaBeforeCustomExtraTables, true) ?  " " : ", ";
            String      tables = StringUtils.subBlanks(customTables) == null ? " " : concatCustomTableWith + customTables + " ";


            String  query = "SELECT " + SELECT_COLUMNS +
                                    "FROM {PREFIX}rs_culture_element_rating " + tables +
                                    "WHERE " + SELECT_JOINS + " " + customParamFilter + customOrderBy;

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, null, false);

            return results;
        }
        else if (searchType.equals (CultureElementRating.SEARCH_All))
        {
            // Local scope for transformed variables
            {
                
            }


            
                String      orderBy = " ORDER BY rs_culture_element_rating.object_id";
                String      tables = " ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: rs_culture_element_rating.object_id is not null
                    String preFilter = "(rs_culture_element_rating.object_id is not null)"
                                     + "  ";
                    
                    
                    preFilter += context.getLoadingAttributes ().getCustomSQL() ;
                    
                    SearchParamTransform tx = new SearchParamTransform (criteria);
                    
                    filter = StringUtils.replaceParams (preFilter, tx);
                    searchParams = tx.getParamsArray();
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}rs_culture_element_rating " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        
        else
        {
            throw new IllegalArgumentException ("Illegal search type:" + searchType);
            
            
        }
    }

    private void createPersistentSetFromRS(PersistentSetCollection allPSets, ResultSet r, ObjectID objectID) throws SQLException
    {
        PersistentSet rs_culture_element_ratingPSet = allPSets.getPersistentSet(objectID, "rs_culture_element_rating", PersistentSetStatus.FETCHED);
        
            // Object Modified
            rs_culture_element_ratingPSet.setAttrib(BaseBusinessClass.FIELD_ObjectLastModified, r.getTimestamp ("LAST_UPDATED_DATE"));

            // Object Created
            rs_culture_element_ratingPSet.setAttrib(BaseBusinessClass.FIELD_ObjectCreated, r.getTimestamp ("CREATED_DATE"));

        rs_culture_element_ratingPSet.setAttrib(CultureElementRating.FIELD_Description, HELPER_Description.getFromRS(dummyDescription, r, "culture_element_rating_desc"));
        
        rs_culture_element_ratingPSet.setAttrib(CultureElementRating.SINGLEREFERENCE_CultureElement, r.getObject ("culture_element_number"));
        
    }


    public void create(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        ObjectID    objectID = obj.getID ();
        PersistentSet rs_culture_element_ratingPSet = allPSets.getPersistentSet(objectID, "rs_culture_element_rating");
        

        
        if (rs_culture_element_ratingPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            rs_culture_element_ratingPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            executeStatement (sqlMgr, 
                                     "INSERT INTO {PREFIX}rs_culture_element_rating " +
                                     "  (culture_element_rating_desc,  culture_element_number,  object_id, object_LAST_UPDATED_DATE, object_CREATED_DATE) " +
                                     "VALUES " +
                                     "  (?,  ?,   ?,  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ",  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ")",
                                     CollectionUtils.listEntry (HELPER_Description.getForSQL(dummyDescription, rs_culture_element_ratingPSet.getAttrib (CultureElementRating.FIELD_Description))) .listEntry (SQLManager.CheckNull((Long)(rs_culture_element_ratingPSet.getAttrib (CultureElementRating.SINGLEREFERENCE_CultureElement)))) .listEntry (objectID.longID ()).toList().toArray());

            rs_culture_element_ratingPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }
}
