
package performa.orm;

import java.io.*;
import java.util.*;
import java.sql.ResultSet;
import java.sql.SQLException;
import oneit.logging.*;
import oneit.objstore.*;
import oneit.objstore.assocs.*;
import oneit.objstore.rdbms.*;
import oneit.objstore.utils.*;
import oneit.sql.*;
import oneit.utils.resource.*;
import oneit.utils.*;
import oneit.utils.threading.*;



/**
 * IMPORTANT!!!! Autogenerated class, DO NOT EDIT!!!!!
 * Template: Infrastructure8.2[oneit.objstore.PersistenceMgrTemplate.xsl]
 */
public class FactorLevelLinkPersistenceMgr extends ObjectPersistenceMgr
{
    private static final LoggingArea FactorLevelLinkPersistence = LoggingArea.createLoggingArea(ObjectPersistenceMgr.OBJECT_PERSISTENCE, "FactorLevelLink");

    // Private attributes corresponding to business object data
    private String dummyClassCode;
    private String dummyNotes;
    private String dummyLeftAnnot;
    private String dummyRightAnnot;
    private Double dummyZScoreWeight;
    private Double dummyZScoreWeight2;
    

    // Static constants corresponding to attribute helpers
    private static final DefaultAttributeHelper HELPER_ClassCode = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_Notes = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_LeftAnnot = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_RightAnnot = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_ZScoreWeight = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_ZScoreWeight2 = DefaultAttributeHelper.INSTANCE;
    



    public FactorLevelLinkPersistenceMgr ()
    {
        dummyClassCode = (String)(HELPER_ClassCode.initialise (dummyClassCode));
        dummyNotes = (String)(HELPER_Notes.initialise (dummyNotes));
        dummyLeftAnnot = (String)(HELPER_LeftAnnot.initialise (dummyLeftAnnot));
        dummyRightAnnot = (String)(HELPER_RightAnnot.initialise (dummyRightAnnot));
        dummyZScoreWeight = (Double)(HELPER_ZScoreWeight.initialise (dummyZScoreWeight));
        dummyZScoreWeight2 = (Double)(HELPER_ZScoreWeight2.initialise (dummyZScoreWeight2));
        
    }

    private String  SELECT_COLUMNS = "{PREFIX}rs_factor_hdr.object_id as id, {PREFIX}rs_factor_hdr.object_LAST_UPDATED_DATE as LAST_UPDATED_DATE, {PREFIX}rs_factor_hdr.object_CREATED_DATE as CREATED_DATE, {PREFIX}rs_factor_hdr.class_code, {PREFIX}rs_factor_hdr.factor_hdr_notes, {PREFIX}rs_factor_hdr.left_annot, {PREFIX}rs_factor_hdr.right_annot, {PREFIX}rs_factor_hdr.z_score_wght, {PREFIX}rs_factor_hdr.z_score_wght_2, {PREFIX}rs_factor_hdr.level_number, {PREFIX}rs_factor_hdr.factor_number,  1 AS commasafe ";
    private String SELECT_JOINS = "";

    public BaseBusinessClass fetchByID(ObjectID id, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    resultByIDs = fetchByIDs(Collections.singleton (id), allPSets, context, sqlMgr);

        if (resultByIDs.isEmpty ())
        {
            return null;
        }
        else if (resultByIDs.size () > 1)
        {
            throw new StorageException ("Multiple results for id:" + id);
        }
        else
        {
            return resultByIDs.iterator ().next ();
        }
    }



    public Set<BaseBusinessClass> fetchByIDs(Set<ObjectID> ids, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    results = new HashSet ();
        Set<Long> idsToFetch = new HashSet ();

        for (ObjectID id : ids)
        {
            if (context.containsObject(id)) // Check for cached version
            {
                BaseBusinessClass objectToReturn = context.getObjectToReplace(id, FactorLevelLink.REFERENCE_FactorLevelLink);

                if (objectToReturn instanceof FactorLevelLink)
                {
                    LogMgr.log (FactorLevelLinkPersistence, LogLevel.TRACE, "Cache hit for id:", id);
                    results.add (objectToReturn);
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + id + " with object " + objectToReturn + "while fetching a FactorLevelLink");
                }
            }

            PersistentSet rs_factor_hdrPSet = allPSets.getPersistentSet(id, "rs_factor_hdr", PersistentSetStatus.FETCHED);
            
            

             // Check for persistent sets already prefetched
            if (false  || !rs_factor_hdrPSet.containsAttrib(BaseBusinessClass.FIELD_ObjectLastModified) ||
                    !rs_factor_hdrPSet.containsAttrib(FactorLevelLink.FIELD_ClassCode)||
                    !rs_factor_hdrPSet.containsAttrib(FactorLevelLink.FIELD_Notes)||
                    !rs_factor_hdrPSet.containsAttrib(FactorLevelLink.FIELD_LeftAnnot)||
                    !rs_factor_hdrPSet.containsAttrib(FactorLevelLink.FIELD_RightAnnot)||
                    !rs_factor_hdrPSet.containsAttrib(FactorLevelLink.FIELD_ZScoreWeight)||
                    !rs_factor_hdrPSet.containsAttrib(FactorLevelLink.FIELD_ZScoreWeight2)||
                    !rs_factor_hdrPSet.containsAttrib(FactorLevelLink.SINGLEREFERENCE_Level)||
                    !rs_factor_hdrPSet.containsAttrib(FactorLevelLink.SINGLEREFERENCE_Factor))
            {
                // We will need to retrieve it
                idsToFetch.add (id.longValue());
            }
            else
            {
                LogMgr.log (FactorLevelLinkPersistence, LogLevel.DEBUG2, "Persistent set preloaded id:", id);
        
                /* Non Polymorphic */
                FactorLevelLink result = new FactorLevelLink ();

                result.setFromPersistentSets(id, allPSets);
                context.addRetrievedObject(result);

                results.add (result);
            
            }
        }

        if (idsToFetch.size () > 0)
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}rs_factor_hdr " +
                            "WHERE " + SELECT_JOINS + "{PREFIX}rs_factor_hdr.object_id IN ?";

            BaseBusinessClass[] resultsFetched = loadQuery (allPSets, sqlMgr, context, query, new Object[] { idsToFetch }, null, false);

            for (BaseBusinessClass objFetched : resultsFetched)
            {
                results.add (objFetched);
            }
        }


        return results;
    }



    public BaseBusinessClass[] getReferencedObjects(ObjectID _objectID, String refName, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        if (false)
        {
            throw new RuntimeException ();
        }
        else if (refName.equals (FactorLevelLink.SINGLEREFERENCE_Level))
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}rs_factor_hdr " +
                            "WHERE " + SELECT_JOINS + "level_number = ?";

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, new Object[] { _objectID.longID () }, null, false);

            return results;
        }
        else if (refName.equals (FactorLevelLink.SINGLEREFERENCE_Factor))
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}rs_factor_hdr " +
                            "WHERE " + SELECT_JOINS + "factor_number = ?";

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, new Object[] { _objectID.longID () }, null, false);

            return results;
        }
        else
        {
            throw new IllegalArgumentException ("Illegal reference type:" + refName);
        }
    }



    public void update(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        EqualityResult  test = EqualityResult.compare (obj, obj.getBackup ());
        ObjectID        objectID = obj.getID ();

        if (!test.areAttributesEqual () || !test.areSingleAssocsEqual () || obj.getForcedSave())
        {
            PersistentSet rs_factor_hdrPSet = allPSets.getPersistentSet(objectID, "rs_factor_hdr");
            

            
            if (rs_factor_hdrPSet.getStatus () != PersistentSetStatus.PROCESSED &&
                rs_factor_hdrPSet.getStatus () != PersistentSetStatus.DEFERRED)
            {
                int rowsUpdated = executeStatement (sqlMgr, 
                                                           "UPDATE {PREFIX}rs_factor_hdr " +
                                                           "SET class_code = ?, factor_hdr_notes = ?, left_annot = ?, right_annot = ?, z_score_wght = ?, z_score_wght_2 = ?, level_number = ? , factor_number = ?  , object_LAST_UPDATED_DATE = " + sqlMgr.getPortabilityServices ().getTimestampExpression () + " " +
                                                                
                                                           "WHERE rs_factor_hdr.object_id = ? AND " + getConcurrencyCheck (sqlMgr, "object_LAST_UPDATED_DATE", obj.getObjectLastModified ()) + " ",
                                                           CollectionUtils.listEntry (HELPER_ClassCode.getForSQL(dummyClassCode, rs_factor_hdrPSet.getAttrib (FactorLevelLink.FIELD_ClassCode))).listEntry (HELPER_Notes.getForSQL(dummyNotes, rs_factor_hdrPSet.getAttrib (FactorLevelLink.FIELD_Notes))).listEntry (HELPER_LeftAnnot.getForSQL(dummyLeftAnnot, rs_factor_hdrPSet.getAttrib (FactorLevelLink.FIELD_LeftAnnot))).listEntry (HELPER_RightAnnot.getForSQL(dummyRightAnnot, rs_factor_hdrPSet.getAttrib (FactorLevelLink.FIELD_RightAnnot))).listEntry (HELPER_ZScoreWeight.getForSQL(dummyZScoreWeight, rs_factor_hdrPSet.getAttrib (FactorLevelLink.FIELD_ZScoreWeight))).listEntry (HELPER_ZScoreWeight2.getForSQL(dummyZScoreWeight2, rs_factor_hdrPSet.getAttrib (FactorLevelLink.FIELD_ZScoreWeight2))).listEntry (SQLManager.CheckNull((Long)(rs_factor_hdrPSet.getAttrib (FactorLevelLink.SINGLEREFERENCE_Level)))).listEntry (SQLManager.CheckNull((Long)(rs_factor_hdrPSet.getAttrib (FactorLevelLink.SINGLEREFERENCE_Factor)))).listEntry (objectID.longID ()).listEntry (obj.getObjectLastModified ()).toList().toArray());

                if (rowsUpdated != 1)
                {
                    // Error, either a concurrency error or a not-exists error
                    ResultSet r = executeQuery (sqlMgr, 
                                                       "SELECT object_id, object_LAST_UPDATED_DATE FROM {PREFIX}rs_factor_hdr WHERE object_id = ?",
                                                       new Object[] { objectID.longID () });

                    if (r.next ())
                    {
                        Date                d = new java.util.Date (r.getTimestamp (2).getTime());
                        String              errorMsg = QueryBuilder.buildQueryString ("Concurrent update error:[?] for row:[?] objDate:[?] dbDate:[?]", 
                                                                         new Object[] { "rs_factor_hdr", objectID.longID (), obj.getObjectLastModified (), d },
                                                                         sqlMgr.getPortabilityServices ());
                                                                         
                        LogMgr.log (FactorLevelLinkPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new ConcurrentUpdateConflictException (obj, "rs_factor_hdr");
                    }
                    else
                    {
                        String  errorMsg = "Attempt to update nonexistent row in table:rs_factor_hdr for row:" + objectID + " objDate:" + obj.getObjectLastModified ();

                        LogMgr.log (FactorLevelLinkPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new RuntimeException (errorMsg);
                    }
                }

                rs_factor_hdrPSet.setStatus (PersistentSetStatus.PROCESSED);
            }
            
        }
        else
        {
            LogMgr.log (FactorLevelLinkPersistence, LogLevel.DEBUG1, "Skipping update since no attribs or simple assocs changed on ", objectID);
        }
    }



    public void delete(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        ObjectID        objectID = obj.getID ();
        PersistentSet rs_factor_hdrPSet = allPSets.getPersistentSet(objectID, "rs_factor_hdr");
        

        LogMgr.log (FactorLevelLinkPersistence, LogLevel.DEBUG2, "Deleting:", objectID);

        
        if (rs_factor_hdrPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            rs_factor_hdrPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            int rowsDeleted = executeStatement (sqlMgr, 
                                                       "DELETE " +
                                                       "FROM {PREFIX}rs_factor_hdr " +
                                                       "WHERE rs_factor_hdr.object_id = ? AND " + sqlMgr.getPortabilityServices ().getTruncatedTimestampColumn ("object_LAST_UPDATED_DATE") + " = " + sqlMgr.getPortabilityServices ().getTruncatedTimestampParam("?") + " ",
                                                       new Object[] { objectID.longID(), obj.getObjectLastModified () });

            if (rowsDeleted != 1)
            {
                // Error, either a concurrency error or a not-exists error
                ResultSet r = executeQuery (sqlMgr, 
                                                   "SELECT object_id FROM {PREFIX}rs_factor_hdr WHERE object_id = ?",
                                                   new Object[] { objectID.longID() });

                if (r.next ())
                {
                    throw new ConcurrentUpdateConflictException (obj, "rs_factor_hdr");
                }
                else
                {
                    String  errorMsg = "Attempt to delete nonexistent row in table:rs_factor_hdr for row:" + objectID;

                    LogMgr.log (FactorLevelLinkPersistence, LogLevel.SYSTEMERROR1, errorMsg);
                    throw new RuntimeException (errorMsg);
                }
            }

            rs_factor_hdrPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }


    public ResultSet executeSearchQueryAll (SQLManager sqlMgr) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryAll");
    }
    



    public BaseBusinessClass[] loadQuery (PersistentSetCollection allPSets, SQLManager sqlMgr, RDBMSPersistenceContext context, String query, Object[] params, Integer maxRows, boolean truncateExtra) throws SQLException, StorageException
    {
        LinkedHashMap<ObjectID, FactorLevelLink> results = new LinkedHashMap ();
        
        ResultSet   r = executeQuery (sqlMgr, query, params);

        while (r.next())
        {
            ThreadUtils.checkInterrupted ();
            
            ObjectID    objectID = new ObjectID (FactorLevelLink.REFERENCE_FactorLevelLink.getObjectIDSpace (), r.getLong ("id"));
            FactorLevelLink resultElement;

            if (maxRows != null && !results.containsKey (objectID) && results.size () >= maxRows)
            {
                if (truncateExtra)
                {
                    break;
                }
                else
                {
                    throw new SearchRowsExceededException ("Maximum rows exceeded:" + maxRows);
                }
            }

            if (context.containsObject(objectID))
            {
                BaseBusinessClass   cachedElement = context.getObjectToReplace(objectID, FactorLevelLink.REFERENCE_FactorLevelLink);

                if (cachedElement instanceof FactorLevelLink)
                {
                    LogMgr.log (FactorLevelLinkPersistence, LogLevel.TRACE, "Cache hit for id:", objectID);
                    resultElement = (FactorLevelLink)cachedElement;
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + objectID + " with object " + cachedElement + "while fetching a FactorLevelLink");
                }
            }
            else
            {
                PersistentSet rs_factor_hdrPSet = allPSets.getPersistentSet(objectID, "rs_factor_hdr", PersistentSetStatus.FETCHED);
                
                createPersistentSetFromRS(allPSets, r, objectID);

                

                        resultElement = new FactorLevelLink ();

                        resultElement.setFromPersistentSets(objectID, allPSets);
                        context.addRetrievedObject(resultElement);

                
            }

            results.put (objectID, resultElement);
        }

        

        BaseBusinessClass[] resultsArr = new BaseBusinessClass[results.size ()];

        return results.values ().toArray (resultsArr);
    }



    public BaseBusinessClass[] find(String searchType, PersistentSetCollection allPSets, Hashtable criteria, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        LogMgr.log (FactorLevelLinkPersistence, LogLevel.DEBUG2, "Search executing:", searchType, " criteria:", criteria);
        String  customParamFilter = (String)criteria.get (SEARCH_CustomFilter);
        String  customOrderBy = (String)criteria.get (SEARCH_OrderBy);
        String  customTables = (String)criteria.get (SEARCH_CustomExtraTables);
        Boolean  noCommaBeforeCustomExtraTables = (Boolean)criteria.get (SEARCH_CustomExtraTablesNoComma);

        if (searchType.equals (SEARCH_CustomSQL))
        {
            Set<ObjectID>                     processedIDs = new HashSet();
            SearchParamTransform    tx = new SearchParamTransform (criteria);
            Object[]                searchParams;

            customParamFilter = StringUtils.replaceParams (customParamFilter, tx);
            searchParams = tx.getParamsArray();

            if (customOrderBy != null) 
            {
                customOrderBy = " ORDER BY " + customOrderBy;
            }
            else
            {
                customOrderBy = "";
            }


            ResultSet   r;
            String      concatCustomTableWith = CollectionUtils.equals(noCommaBeforeCustomExtraTables, true) ?  " " : ", ";
            String      tables = StringUtils.subBlanks(customTables) == null ? " " : concatCustomTableWith + customTables + " ";


            String  query = "SELECT " + SELECT_COLUMNS +
                                    "FROM {PREFIX}rs_factor_hdr " + tables +
                                    "WHERE " + SELECT_JOINS + " " + customParamFilter + customOrderBy;

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, null, false);

            return results;
        }
        else if (searchType.equals (FactorLevelLink.SEARCH_All))
        {
            // Local scope for transformed variables
            {
                
            }


            
                String      orderBy = " ORDER BY factor_hdr.object_id";
                String      tables = " ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: rs_factor_hdr.object_id is not null
                    String preFilter = "(rs_factor_hdr.object_id is not null)"
                                     + "  ";
                    
                    
                    preFilter += context.getLoadingAttributes ().getCustomSQL() ;
                    
                    SearchParamTransform tx = new SearchParamTransform (criteria);
                    
                    filter = StringUtils.replaceParams (preFilter, tx);
                    searchParams = tx.getParamsArray();
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}rs_factor_hdr " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        
        else
        {
            throw new IllegalArgumentException ("Illegal search type:" + searchType);
            
            
        }
    }

    private void createPersistentSetFromRS(PersistentSetCollection allPSets, ResultSet r, ObjectID objectID) throws SQLException
    {
        PersistentSet rs_factor_hdrPSet = allPSets.getPersistentSet(objectID, "rs_factor_hdr", PersistentSetStatus.FETCHED);
        
            // Object Modified
            rs_factor_hdrPSet.setAttrib(BaseBusinessClass.FIELD_ObjectLastModified, r.getTimestamp ("LAST_UPDATED_DATE"));

            // Object Created
            rs_factor_hdrPSet.setAttrib(BaseBusinessClass.FIELD_ObjectCreated, r.getTimestamp ("CREATED_DATE"));

        rs_factor_hdrPSet.setAttrib(FactorLevelLink.FIELD_ClassCode, HELPER_ClassCode.getFromRS(dummyClassCode, r, "class_code"));
        rs_factor_hdrPSet.setAttrib(FactorLevelLink.FIELD_Notes, HELPER_Notes.getFromRS(dummyNotes, r, "factor_hdr_notes"));
        rs_factor_hdrPSet.setAttrib(FactorLevelLink.FIELD_LeftAnnot, HELPER_LeftAnnot.getFromRS(dummyLeftAnnot, r, "left_annot"));
        rs_factor_hdrPSet.setAttrib(FactorLevelLink.FIELD_RightAnnot, HELPER_RightAnnot.getFromRS(dummyRightAnnot, r, "right_annot"));
        rs_factor_hdrPSet.setAttrib(FactorLevelLink.FIELD_ZScoreWeight, HELPER_ZScoreWeight.getFromRS(dummyZScoreWeight, r, "z_score_wght"));
        rs_factor_hdrPSet.setAttrib(FactorLevelLink.FIELD_ZScoreWeight2, HELPER_ZScoreWeight2.getFromRS(dummyZScoreWeight2, r, "z_score_wght_2"));
        
        rs_factor_hdrPSet.setAttrib(FactorLevelLink.SINGLEREFERENCE_Level, r.getObject ("level_number"));
        rs_factor_hdrPSet.setAttrib(FactorLevelLink.SINGLEREFERENCE_Factor, r.getObject ("factor_number"));
        
    }


    public void create(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        ObjectID    objectID = obj.getID ();
        PersistentSet rs_factor_hdrPSet = allPSets.getPersistentSet(objectID, "rs_factor_hdr");
        

        
        if (rs_factor_hdrPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            rs_factor_hdrPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            executeStatement (sqlMgr, 
                                     "INSERT INTO {PREFIX}rs_factor_hdr " +
                                     "  (class_code, factor_hdr_notes, left_annot, right_annot, z_score_wght, z_score_wght_2,  level_number, factor_number,  object_id, object_LAST_UPDATED_DATE, object_CREATED_DATE) " +
                                     "VALUES " +
                                     "  (?, ?, ?, ?, ?, ?,  ?, ?,   ?,  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ",  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ")",
                                     CollectionUtils.listEntry (HELPER_ClassCode.getForSQL(dummyClassCode, rs_factor_hdrPSet.getAttrib (FactorLevelLink.FIELD_ClassCode))).listEntry (HELPER_Notes.getForSQL(dummyNotes, rs_factor_hdrPSet.getAttrib (FactorLevelLink.FIELD_Notes))).listEntry (HELPER_LeftAnnot.getForSQL(dummyLeftAnnot, rs_factor_hdrPSet.getAttrib (FactorLevelLink.FIELD_LeftAnnot))).listEntry (HELPER_RightAnnot.getForSQL(dummyRightAnnot, rs_factor_hdrPSet.getAttrib (FactorLevelLink.FIELD_RightAnnot))).listEntry (HELPER_ZScoreWeight.getForSQL(dummyZScoreWeight, rs_factor_hdrPSet.getAttrib (FactorLevelLink.FIELD_ZScoreWeight))).listEntry (HELPER_ZScoreWeight2.getForSQL(dummyZScoreWeight2, rs_factor_hdrPSet.getAttrib (FactorLevelLink.FIELD_ZScoreWeight2))) .listEntry (SQLManager.CheckNull((Long)(rs_factor_hdrPSet.getAttrib (FactorLevelLink.SINGLEREFERENCE_Level)))).listEntry (SQLManager.CheckNull((Long)(rs_factor_hdrPSet.getAttrib (FactorLevelLink.SINGLEREFERENCE_Factor)))) .listEntry (objectID.longID ()).toList().toArray());

            rs_factor_hdrPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }
}
