package performa.form;

import java.util.Map;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.objstore.StorageException;
import oneit.servlets.forms.SubmissionDetails;
import oneit.servlets.forms.SuccessfulResult;
import oneit.servlets.process.ORMProcessState;
import oneit.servlets.process.SaveFP;
import oneit.utils.BusinessException;
import performa.orm.Company;
import performa.orm.CompanyUser;
import javax.servlet.http.HttpServletRequest;
import oneit.objstore.ObjectTransaction;
import oneit.objstore.rdbms.filters.EqualsFilter;
import oneit.utils.CollectionUtils;
import performa.orm.CompanyUserHiringTeamLink;
import performa.orm.HiringTeam;


public class SaveCompanyUserFP extends SaveFP 
{
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        HttpServletRequest  request     =   submission.getRequest();
        ObjectTransaction   objTran     =   process.getTransaction();
        HiringTeam          hiringTeam  =   (HiringTeam) request.getAttribute("HiringTeam");
        CompanyUser         companyUser =   (CompanyUser) request.getAttribute("CompanyUser");
        Boolean             disabled    =   (Boolean) request.getAttribute("disabled");
        Boolean             remove      =   (Boolean) request.getAttribute("remove");

        LogMgr.log(Company.LOG, LogLevel.PROCESSING1,"In SaveCompanyUserFP saving company user : ", companyUser );

        if(disabled != null)
        {
            companyUser.setIsDisabled(disabled);
        
            LogMgr.log(Company.LOG, LogLevel.PROCESSING1,"In SaveCompanyUserFP setting is disabled : ", disabled , " for company user : ",companyUser );
        }
        
        if(CollectionUtils.equals(remove, Boolean.TRUE))
        {
            CompanyUserHiringTeamLink[] links   = CompanyUserHiringTeamLink.SearchByAll()
                                                                        .andHiringTeam(new EqualsFilter<>(hiringTeam))
                                                                        .andCompanyUser(new EqualsFilter<>(companyUser))
                                                                        .search(objTran);
                                        
            for (CompanyUserHiringTeamLink link: links)
            {
                link.delete();
                            
                LogMgr.log(Company.LOG, LogLevel.PROCESSING1,"In SaveCompanyUserFP removing link of company user : ", companyUser , " for hiring team : ",hiringTeam );

            }
        }

        return super.processForm(process, submission, params);
    }
}