import { Injectable } from '@angular/core';
import { Subject } from 'rxjs';
import { environment } from '../../../../environments/environment';
import { ApiService } from '../../../oneit/services/api.service';
import { UtilsService } from '../../../oneit/services/utils.service';

@Injectable()
export class ApplicantPortalLayoutService {

    userDataUpdated = new Subject<any>();
    userData: any;

    constructor(
        private apiService: ApiService,
        private utilsService: UtilsService
    ) {

    }

    reloadApplicantUserDetails (job, key) {
        if(job && key) {
            let params = {
                environment: environment.envName,
                Job: job,
                Key: key
            }

            this.apiService.post(`svc/ApplicantUserDetails`, params).subscribe(
                (data) => {
                    if (this.utilsService.isSuccessfulResponse(data)) {
                        this.userData = data;
                        this.userDataUpdated.next(data);
                    }
                });
        }
    }
}
