
package performa.orm;

import java.io.*;
import java.util.*;
import java.sql.ResultSet;
import java.sql.SQLException;
import oneit.logging.*;
import oneit.objstore.*;
import oneit.objstore.assocs.*;
import oneit.objstore.rdbms.*;
import oneit.objstore.utils.*;
import oneit.sql.*;
import oneit.utils.resource.*;
import oneit.utils.*;
import oneit.utils.threading.*;



/**
 * IMPORTANT!!!! Autogenerated class, DO NOT EDIT!!!!!
 * Template: Infrastructure8.2[oneit.objstore.PersistenceMgrTemplate.xsl]
 */
public class AnswerPersistenceMgr extends ObjectPersistenceMgr
{
    private static final LoggingArea AnswerPersistence = LoggingArea.createLoggingArea(ObjectPersistenceMgr.OBJECT_PERSISTENCE, "Answer");

    // Private attributes corresponding to business object data
    private Integer dummyAnswerNo;
    

    // Static constants corresponding to attribute helpers
    private static final DefaultAttributeHelper HELPER_AnswerNo = DefaultAttributeHelper.INSTANCE;
    



    public AnswerPersistenceMgr ()
    {
        dummyAnswerNo = (Integer)(HELPER_AnswerNo.initialise (dummyAnswerNo));
        
    }

    private String  SELECT_COLUMNS = "{PREFIX}rs_answer.object_id as id, {PREFIX}rs_answer.object_LAST_UPDATED_DATE as LAST_UPDATED_DATE, {PREFIX}rs_answer.object_CREATED_DATE as CREATED_DATE, {PREFIX}rs_answer.answer_number, {PREFIX}rs_answer.section_number, {PREFIX}rs_answer.candidate_id, {PREFIX}rs_answer.quest_number,  1 AS commasafe ";
    private String SELECT_JOINS = "";

    public BaseBusinessClass fetchByID(ObjectID id, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    resultByIDs = fetchByIDs(Collections.singleton (id), allPSets, context, sqlMgr);

        if (resultByIDs.isEmpty ())
        {
            return null;
        }
        else if (resultByIDs.size () > 1)
        {
            throw new StorageException ("Multiple results for id:" + id);
        }
        else
        {
            return resultByIDs.iterator ().next ();
        }
    }



    public Set<BaseBusinessClass> fetchByIDs(Set<ObjectID> ids, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    results = new HashSet ();
        Set<Long> idsToFetch = new HashSet ();

        for (ObjectID id : ids)
        {
            if (context.containsObject(id)) // Check for cached version
            {
                BaseBusinessClass objectToReturn = context.getObjectToReplace(id, Answer.REFERENCE_Answer);

                if (objectToReturn instanceof Answer)
                {
                    LogMgr.log (AnswerPersistence, LogLevel.TRACE, "Cache hit for id:", id);
                    results.add (objectToReturn);
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + id + " with object " + objectToReturn + "while fetching a Answer");
                }
            }

            PersistentSet rs_answerPSet = allPSets.getPersistentSet(id, "rs_answer", PersistentSetStatus.FETCHED);
            
            

             // Check for persistent sets already prefetched
            if (false  || !rs_answerPSet.containsAttrib(BaseBusinessClass.FIELD_ObjectLastModified) ||
                    !rs_answerPSet.containsAttrib(Answer.FIELD_AnswerNo)||
                    !rs_answerPSet.containsAttrib(Answer.SINGLEREFERENCE_Section)||
                    !rs_answerPSet.containsAttrib(Answer.SINGLEREFERENCE_Candidate)||
                    !rs_answerPSet.containsAttrib(Answer.SINGLEREFERENCE_Question))
            {
                // We will need to retrieve it
                idsToFetch.add (id.longValue());
            }
            else
            {
                LogMgr.log (AnswerPersistence, LogLevel.DEBUG2, "Persistent set preloaded id:", id);
        
                /* Non Polymorphic */
                Answer result = new Answer ();

                result.setFromPersistentSets(id, allPSets);
                context.addRetrievedObject(result);

                results.add (result);
            
            }
        }

        if (idsToFetch.size () > 0)
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}rs_answer " +
                            "WHERE " + SELECT_JOINS + "{PREFIX}rs_answer.object_id IN ?";

            BaseBusinessClass[] resultsFetched = loadQuery (allPSets, sqlMgr, context, query, new Object[] { idsToFetch }, null, false);

            for (BaseBusinessClass objFetched : resultsFetched)
            {
                results.add (objFetched);
            }
        }


        return results;
    }



    public BaseBusinessClass[] getReferencedObjects(ObjectID _objectID, String refName, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        if (false)
        {
            throw new RuntimeException ();
        }
        else if (refName.equals (Answer.SINGLEREFERENCE_Candidate))
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}rs_answer " +
                            "WHERE " + SELECT_JOINS + "candidate_id = ?";

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, new Object[] { _objectID.longID () }, null, false);

            return results;
        }
        else
        {
            throw new IllegalArgumentException ("Illegal reference type:" + refName);
        }
    }



    public void update(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        EqualityResult  test = EqualityResult.compare (obj, obj.getBackup ());
        ObjectID        objectID = obj.getID ();

        if (!test.areAttributesEqual () || !test.areSingleAssocsEqual () || obj.getForcedSave())
        {
            PersistentSet rs_answerPSet = allPSets.getPersistentSet(objectID, "rs_answer");
            

            
            if (rs_answerPSet.getStatus () != PersistentSetStatus.PROCESSED &&
                rs_answerPSet.getStatus () != PersistentSetStatus.DEFERRED)
            {
                int rowsUpdated = executeStatement (sqlMgr, 
                                                           "UPDATE {PREFIX}rs_answer " +
                                                           "SET answer_number = ?, section_number = ? , candidate_id = ? , quest_number = ?  , object_LAST_UPDATED_DATE = " + sqlMgr.getPortabilityServices ().getTimestampExpression () + " " +
                                                                
                                                           "WHERE rs_answer.object_id = ? AND " + getConcurrencyCheck (sqlMgr, "object_LAST_UPDATED_DATE", obj.getObjectLastModified ()) + " ",
                                                           CollectionUtils.listEntry (HELPER_AnswerNo.getForSQL(dummyAnswerNo, rs_answerPSet.getAttrib (Answer.FIELD_AnswerNo))).listEntry (SQLManager.CheckNull((Long)(rs_answerPSet.getAttrib (Answer.SINGLEREFERENCE_Section)))).listEntry (SQLManager.CheckNull((Long)(rs_answerPSet.getAttrib (Answer.SINGLEREFERENCE_Candidate)))).listEntry (SQLManager.CheckNull((Long)(rs_answerPSet.getAttrib (Answer.SINGLEREFERENCE_Question)))).listEntry (objectID.longID ()).listEntry (obj.getObjectLastModified ()).toList().toArray());

                if (rowsUpdated != 1)
                {
                    // Error, either a concurrency error or a not-exists error
                    ResultSet r = executeQuery (sqlMgr, 
                                                       "SELECT object_id, object_LAST_UPDATED_DATE FROM {PREFIX}rs_answer WHERE object_id = ?",
                                                       new Object[] { objectID.longID () });

                    if (r.next ())
                    {
                        Date                d = new java.util.Date (r.getTimestamp (2).getTime());
                        String              errorMsg = QueryBuilder.buildQueryString ("Concurrent update error:[?] for row:[?] objDate:[?] dbDate:[?]", 
                                                                         new Object[] { "rs_answer", objectID.longID (), obj.getObjectLastModified (), d },
                                                                         sqlMgr.getPortabilityServices ());
                                                                         
                        LogMgr.log (AnswerPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new ConcurrentUpdateConflictException (obj, "rs_answer");
                    }
                    else
                    {
                        String  errorMsg = "Attempt to update nonexistent row in table:rs_answer for row:" + objectID + " objDate:" + obj.getObjectLastModified ();

                        LogMgr.log (AnswerPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new RuntimeException (errorMsg);
                    }
                }

                rs_answerPSet.setStatus (PersistentSetStatus.PROCESSED);
            }
            
        }
        else
        {
            LogMgr.log (AnswerPersistence, LogLevel.DEBUG1, "Skipping update since no attribs or simple assocs changed on ", objectID);
        }
    }



    public void delete(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        ObjectID        objectID = obj.getID ();
        PersistentSet rs_answerPSet = allPSets.getPersistentSet(objectID, "rs_answer");
        

        LogMgr.log (AnswerPersistence, LogLevel.DEBUG2, "Deleting:", objectID);

        
        if (rs_answerPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            rs_answerPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            int rowsDeleted = executeStatement (sqlMgr, 
                                                       "DELETE " +
                                                       "FROM {PREFIX}rs_answer " +
                                                       "WHERE rs_answer.object_id = ? AND " + sqlMgr.getPortabilityServices ().getTruncatedTimestampColumn ("object_LAST_UPDATED_DATE") + " = " + sqlMgr.getPortabilityServices ().getTruncatedTimestampParam("?") + " ",
                                                       new Object[] { objectID.longID(), obj.getObjectLastModified () });

            if (rowsDeleted != 1)
            {
                // Error, either a concurrency error or a not-exists error
                ResultSet r = executeQuery (sqlMgr, 
                                                   "SELECT object_id FROM {PREFIX}rs_answer WHERE object_id = ?",
                                                   new Object[] { objectID.longID() });

                if (r.next ())
                {
                    throw new ConcurrentUpdateConflictException (obj, "rs_answer");
                }
                else
                {
                    String  errorMsg = "Attempt to delete nonexistent row in table:rs_answer for row:" + objectID;

                    LogMgr.log (AnswerPersistence, LogLevel.SYSTEMERROR1, errorMsg);
                    throw new RuntimeException (errorMsg);
                }
            }

            rs_answerPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }


    public ResultSet executeSearchQueryAll (SQLManager sqlMgr) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryAll");
    }
    



    public BaseBusinessClass[] loadQuery (PersistentSetCollection allPSets, SQLManager sqlMgr, RDBMSPersistenceContext context, String query, Object[] params, Integer maxRows, boolean truncateExtra) throws SQLException, StorageException
    {
        LinkedHashMap<ObjectID, Answer> results = new LinkedHashMap ();
        
        ResultSet   r = executeQuery (sqlMgr, query, params);

        while (r.next())
        {
            ThreadUtils.checkInterrupted ();
            
            ObjectID    objectID = new ObjectID (Answer.REFERENCE_Answer.getObjectIDSpace (), r.getLong ("id"));
            Answer resultElement;

            if (maxRows != null && !results.containsKey (objectID) && results.size () >= maxRows)
            {
                if (truncateExtra)
                {
                    break;
                }
                else
                {
                    throw new SearchRowsExceededException ("Maximum rows exceeded:" + maxRows);
                }
            }

            if (context.containsObject(objectID))
            {
                BaseBusinessClass   cachedElement = context.getObjectToReplace(objectID, Answer.REFERENCE_Answer);

                if (cachedElement instanceof Answer)
                {
                    LogMgr.log (AnswerPersistence, LogLevel.TRACE, "Cache hit for id:", objectID);
                    resultElement = (Answer)cachedElement;
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + objectID + " with object " + cachedElement + "while fetching a Answer");
                }
            }
            else
            {
                PersistentSet rs_answerPSet = allPSets.getPersistentSet(objectID, "rs_answer", PersistentSetStatus.FETCHED);
                
                createPersistentSetFromRS(allPSets, r, objectID);

                

                        resultElement = new Answer ();

                        resultElement.setFromPersistentSets(objectID, allPSets);
                        context.addRetrievedObject(resultElement);

                
            }

            results.put (objectID, resultElement);
        }

        

        BaseBusinessClass[] resultsArr = new BaseBusinessClass[results.size ()];

        return results.values ().toArray (resultsArr);
    }



    public BaseBusinessClass[] find(String searchType, PersistentSetCollection allPSets, Hashtable criteria, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        LogMgr.log (AnswerPersistence, LogLevel.DEBUG2, "Search executing:", searchType, " criteria:", criteria);
        String  customParamFilter = (String)criteria.get (SEARCH_CustomFilter);
        String  customOrderBy = (String)criteria.get (SEARCH_OrderBy);
        String  customTables = (String)criteria.get (SEARCH_CustomExtraTables);
        Boolean  noCommaBeforeCustomExtraTables = (Boolean)criteria.get (SEARCH_CustomExtraTablesNoComma);

        if (searchType.equals (SEARCH_CustomSQL))
        {
            Set<ObjectID>                     processedIDs = new HashSet();
            SearchParamTransform    tx = new SearchParamTransform (criteria);
            Object[]                searchParams;

            customParamFilter = StringUtils.replaceParams (customParamFilter, tx);
            searchParams = tx.getParamsArray();

            if (customOrderBy != null) 
            {
                customOrderBy = " ORDER BY " + customOrderBy;
            }
            else
            {
                customOrderBy = "";
            }


            ResultSet   r;
            String      concatCustomTableWith = CollectionUtils.equals(noCommaBeforeCustomExtraTables, true) ?  " " : ", ";
            String      tables = StringUtils.subBlanks(customTables) == null ? " " : concatCustomTableWith + customTables + " ";


            String  query = "SELECT " + SELECT_COLUMNS +
                                    "FROM {PREFIX}rs_answer " + tables +
                                    "WHERE " + SELECT_JOINS + " " + customParamFilter + customOrderBy;

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, null, false);

            return results;
        }
        else if (searchType.equals (Answer.SEARCH_All))
        {
            // Local scope for transformed variables
            {
                
            }


            
                String      orderBy = " ORDER BY rs_answer.object_id";
                String      tables = " ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: rs_answer.object_id is not null
                    String preFilter = "(rs_answer.object_id is not null)"
                                     + "  ";
                    
                    
                    preFilter += context.getLoadingAttributes ().getCustomSQL() ;
                    
                    SearchParamTransform tx = new SearchParamTransform (criteria);
                    
                    filter = StringUtils.replaceParams (preFilter, tx);
                    searchParams = tx.getParamsArray();
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}rs_answer " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        
        else
        {
            throw new IllegalArgumentException ("Illegal search type:" + searchType);
            
            
        }
    }

    private void createPersistentSetFromRS(PersistentSetCollection allPSets, ResultSet r, ObjectID objectID) throws SQLException
    {
        PersistentSet rs_answerPSet = allPSets.getPersistentSet(objectID, "rs_answer", PersistentSetStatus.FETCHED);
        
            // Object Modified
            rs_answerPSet.setAttrib(BaseBusinessClass.FIELD_ObjectLastModified, r.getTimestamp ("LAST_UPDATED_DATE"));

            // Object Created
            rs_answerPSet.setAttrib(BaseBusinessClass.FIELD_ObjectCreated, r.getTimestamp ("CREATED_DATE"));

        rs_answerPSet.setAttrib(Answer.FIELD_AnswerNo, HELPER_AnswerNo.getFromRS(dummyAnswerNo, r, "answer_number"));
        
        rs_answerPSet.setAttrib(Answer.SINGLEREFERENCE_Section, r.getObject ("section_number"));
        rs_answerPSet.setAttrib(Answer.SINGLEREFERENCE_Candidate, r.getObject ("candidate_id"));
        rs_answerPSet.setAttrib(Answer.SINGLEREFERENCE_Question, r.getObject ("quest_number"));
        
    }


    public void create(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        ObjectID    objectID = obj.getID ();
        PersistentSet rs_answerPSet = allPSets.getPersistentSet(objectID, "rs_answer");
        

        
        if (rs_answerPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            rs_answerPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            executeStatement (sqlMgr, 
                                     "INSERT INTO {PREFIX}rs_answer " +
                                     "  (answer_number,  section_number, candidate_id, quest_number,  object_id, object_LAST_UPDATED_DATE, object_CREATED_DATE) " +
                                     "VALUES " +
                                     "  (?,  ?, ?, ?,   ?,  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ",  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ")",
                                     CollectionUtils.listEntry (HELPER_AnswerNo.getForSQL(dummyAnswerNo, rs_answerPSet.getAttrib (Answer.FIELD_AnswerNo))) .listEntry (SQLManager.CheckNull((Long)(rs_answerPSet.getAttrib (Answer.SINGLEREFERENCE_Section)))).listEntry (SQLManager.CheckNull((Long)(rs_answerPSet.getAttrib (Answer.SINGLEREFERENCE_Candidate)))).listEntry (SQLManager.CheckNull((Long)(rs_answerPSet.getAttrib (Answer.SINGLEREFERENCE_Question)))) .listEntry (objectID.longID ()).toList().toArray());

            rs_answerPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }
}
