
package performa.orm;

import java.io.*;
import java.util.*;
import java.sql.ResultSet;
import java.sql.SQLException;
import oneit.logging.*;
import oneit.objstore.*;
import oneit.objstore.assocs.*;
import oneit.objstore.rdbms.*;
import oneit.objstore.utils.*;
import oneit.sql.*;
import oneit.utils.resource.*;
import oneit.utils.*;
import oneit.utils.threading.*;
import performa.orm.types.*;
import oneit.security.*;



/**
 * IMPORTANT!!!! Autogenerated class, DO NOT EDIT!!!!!
 * Template: Infrastructure8.2[oneit.objstore.PersistenceMgrTemplate.xsl]
 */
public class MessagePersistenceMgr extends ObjectPersistenceMgr
{
    private static final LoggingArea MessagePersistence = LoggingArea.createLoggingArea(ObjectPersistenceMgr.OBJECT_PERSISTENCE, "Message");

    // Private attributes corresponding to business object data
    private SentVia dummySentVia;
    private String dummyMessageContent;
    private Boolean dummyIsRead;
    

    // Static constants corresponding to attribute helpers
    private static final EnumeratedAttributeHelper HELPER_SentVia = new EnumeratedAttributeHelper (SentVia.FACTORY_SentVia);
    private static final DefaultAttributeHelper HELPER_MessageContent = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_IsRead = DefaultAttributeHelper.INSTANCE;
    



    public MessagePersistenceMgr ()
    {
        dummySentVia = (SentVia)(HELPER_SentVia.initialise (dummySentVia));
        dummyMessageContent = (String)(HELPER_MessageContent.initialise (dummyMessageContent));
        dummyIsRead = (Boolean)(HELPER_IsRead.initialise (dummyIsRead));
        
    }

    private String  SELECT_COLUMNS = "{PREFIX}tl_message.object_id as id, {PREFIX}tl_message.object_LAST_UPDATED_DATE as LAST_UPDATED_DATE, {PREFIX}tl_message.object_CREATED_DATE as CREATED_DATE, {PREFIX}tl_message.sent_via, {PREFIX}tl_message.message_content, {PREFIX}tl_message.is_read, {PREFIX}tl_message.sent_by, {PREFIX}tl_message.work_flow_message, {PREFIX}tl_message.job_application_id,  1 AS commasafe ";
    private String SELECT_JOINS = "";

    public BaseBusinessClass fetchByID(ObjectID id, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    resultByIDs = fetchByIDs(Collections.singleton (id), allPSets, context, sqlMgr);

        if (resultByIDs.isEmpty ())
        {
            return null;
        }
        else if (resultByIDs.size () > 1)
        {
            throw new StorageException ("Multiple results for id:" + id);
        }
        else
        {
            return resultByIDs.iterator ().next ();
        }
    }



    public Set<BaseBusinessClass> fetchByIDs(Set<ObjectID> ids, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    results = new HashSet ();
        Set<Long> idsToFetch = new HashSet ();

        for (ObjectID id : ids)
        {
            if (context.containsObject(id)) // Check for cached version
            {
                BaseBusinessClass objectToReturn = context.getObjectToReplace(id, Message.REFERENCE_Message);

                if (objectToReturn instanceof Message)
                {
                    LogMgr.log (MessagePersistence, LogLevel.TRACE, "Cache hit for id:", id);
                    results.add (objectToReturn);
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + id + " with object " + objectToReturn + "while fetching a Message");
                }
            }

            PersistentSet tl_messagePSet = allPSets.getPersistentSet(id, "tl_message", PersistentSetStatus.FETCHED);
            
            

             // Check for persistent sets already prefetched
            if (false  || !tl_messagePSet.containsAttrib(BaseBusinessClass.FIELD_ObjectLastModified) ||
                    !tl_messagePSet.containsAttrib(Message.FIELD_SentVia)||
                    !tl_messagePSet.containsAttrib(Message.FIELD_MessageContent)||
                    !tl_messagePSet.containsAttrib(Message.FIELD_IsRead)||
                    !tl_messagePSet.containsAttrib(Message.SINGLEREFERENCE_SentBy)||
                    !tl_messagePSet.containsAttrib(Message.SINGLEREFERENCE_WorkFlowMessage)||
                    !tl_messagePSet.containsAttrib(Message.SINGLEREFERENCE_JobApplication))
            {
                // We will need to retrieve it
                idsToFetch.add (id.longValue());
            }
            else
            {
                LogMgr.log (MessagePersistence, LogLevel.DEBUG2, "Persistent set preloaded id:", id);
        
                /* Non Polymorphic */
                Message result = new Message ();

                result.setFromPersistentSets(id, allPSets);
                context.addRetrievedObject(result);

                results.add (result);
            
            }
        }

        if (idsToFetch.size () > 0)
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_message " +
                            "WHERE " + SELECT_JOINS + "{PREFIX}tl_message.object_id IN ?";

            BaseBusinessClass[] resultsFetched = loadQuery (allPSets, sqlMgr, context, query, new Object[] { idsToFetch }, null, false);

            for (BaseBusinessClass objFetched : resultsFetched)
            {
                results.add (objFetched);
            }
        }


        return results;
    }



    public BaseBusinessClass[] getReferencedObjects(ObjectID _objectID, String refName, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        if (false)
        {
            throw new RuntimeException ();
        }
        else if (refName.equals (Message.SINGLEREFERENCE_JobApplication))
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_message " +
                            "WHERE " + SELECT_JOINS + "job_application_id = ?";

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, new Object[] { _objectID.longID () }, null, false);

            return results;
        }
        else
        {
            throw new IllegalArgumentException ("Illegal reference type:" + refName);
        }
    }



    public void update(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        EqualityResult  test = EqualityResult.compare (obj, obj.getBackup ());
        ObjectID        objectID = obj.getID ();

        if (!test.areAttributesEqual () || !test.areSingleAssocsEqual () || obj.getForcedSave())
        {
            PersistentSet tl_messagePSet = allPSets.getPersistentSet(objectID, "tl_message");
            

            
            if (tl_messagePSet.getStatus () != PersistentSetStatus.PROCESSED &&
                tl_messagePSet.getStatus () != PersistentSetStatus.DEFERRED)
            {
                int rowsUpdated = executeStatement (sqlMgr, 
                                                           "UPDATE {PREFIX}tl_message " +
                                                           "SET sent_via = ?, message_content = ?, is_read = ?, sent_by = ? , work_flow_message = ? , job_application_id = ?  , object_LAST_UPDATED_DATE = " + sqlMgr.getPortabilityServices ().getTimestampExpression () + " " +
                                                                
                                                           "WHERE tl_message.object_id = ? AND " + getConcurrencyCheck (sqlMgr, "object_LAST_UPDATED_DATE", obj.getObjectLastModified ()) + " ",
                                                           CollectionUtils.listEntry (HELPER_SentVia.getForSQL(dummySentVia, tl_messagePSet.getAttrib (Message.FIELD_SentVia))).listEntry (HELPER_MessageContent.getForSQL(dummyMessageContent, tl_messagePSet.getAttrib (Message.FIELD_MessageContent))).listEntry (HELPER_IsRead.getForSQL(dummyIsRead, tl_messagePSet.getAttrib (Message.FIELD_IsRead))).listEntry (SQLManager.CheckNull((Long)(tl_messagePSet.getAttrib (Message.SINGLEREFERENCE_SentBy)))).listEntry (SQLManager.CheckNull((Long)(tl_messagePSet.getAttrib (Message.SINGLEREFERENCE_WorkFlowMessage)))).listEntry (SQLManager.CheckNull((Long)(tl_messagePSet.getAttrib (Message.SINGLEREFERENCE_JobApplication)))).listEntry (objectID.longID ()).listEntry (obj.getObjectLastModified ()).toList().toArray());

                if (rowsUpdated != 1)
                {
                    // Error, either a concurrency error or a not-exists error
                    ResultSet r = executeQuery (sqlMgr, 
                                                       "SELECT object_id, object_LAST_UPDATED_DATE FROM {PREFIX}tl_message WHERE object_id = ?",
                                                       new Object[] { objectID.longID () });

                    if (r.next ())
                    {
                        Date                d = new java.util.Date (r.getTimestamp (2).getTime());
                        String              errorMsg = QueryBuilder.buildQueryString ("Concurrent update error:[?] for row:[?] objDate:[?] dbDate:[?]", 
                                                                         new Object[] { "tl_message", objectID.longID (), obj.getObjectLastModified (), d },
                                                                         sqlMgr.getPortabilityServices ());
                                                                         
                        LogMgr.log (MessagePersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new ConcurrentUpdateConflictException (obj, "tl_message");
                    }
                    else
                    {
                        String  errorMsg = "Attempt to update nonexistent row in table:tl_message for row:" + objectID + " objDate:" + obj.getObjectLastModified ();

                        LogMgr.log (MessagePersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new RuntimeException (errorMsg);
                    }
                }

                tl_messagePSet.setStatus (PersistentSetStatus.PROCESSED);
            }
            
        }
        else
        {
            LogMgr.log (MessagePersistence, LogLevel.DEBUG1, "Skipping update since no attribs or simple assocs changed on ", objectID);
        }
    }



    public void delete(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        ObjectID        objectID = obj.getID ();
        PersistentSet tl_messagePSet = allPSets.getPersistentSet(objectID, "tl_message");
        

        LogMgr.log (MessagePersistence, LogLevel.DEBUG2, "Deleting:", objectID);

        
        if (tl_messagePSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_messagePSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            int rowsDeleted = executeStatement (sqlMgr, 
                                                       "DELETE " +
                                                       "FROM {PREFIX}tl_message " +
                                                       "WHERE tl_message.object_id = ? AND " + sqlMgr.getPortabilityServices ().getTruncatedTimestampColumn ("object_LAST_UPDATED_DATE") + " = " + sqlMgr.getPortabilityServices ().getTruncatedTimestampParam("?") + " ",
                                                       new Object[] { objectID.longID(), obj.getObjectLastModified () });

            if (rowsDeleted != 1)
            {
                // Error, either a concurrency error or a not-exists error
                ResultSet r = executeQuery (sqlMgr, 
                                                   "SELECT object_id FROM {PREFIX}tl_message WHERE object_id = ?",
                                                   new Object[] { objectID.longID() });

                if (r.next ())
                {
                    throw new ConcurrentUpdateConflictException (obj, "tl_message");
                }
                else
                {
                    String  errorMsg = "Attempt to delete nonexistent row in table:tl_message for row:" + objectID;

                    LogMgr.log (MessagePersistence, LogLevel.SYSTEMERROR1, errorMsg);
                    throw new RuntimeException (errorMsg);
                }
            }

            tl_messagePSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }


    public ResultSet executeSearchQueryAll (SQLManager sqlMgr) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryAll");
    }
    



    public BaseBusinessClass[] loadQuery (PersistentSetCollection allPSets, SQLManager sqlMgr, RDBMSPersistenceContext context, String query, Object[] params, Integer maxRows, boolean truncateExtra) throws SQLException, StorageException
    {
        LinkedHashMap<ObjectID, Message> results = new LinkedHashMap ();
        
        ResultSet   r = executeQuery (sqlMgr, query, params);

        while (r.next())
        {
            ThreadUtils.checkInterrupted ();
            
            ObjectID    objectID = new ObjectID (Message.REFERENCE_Message.getObjectIDSpace (), r.getLong ("id"));
            Message resultElement;

            if (maxRows != null && !results.containsKey (objectID) && results.size () >= maxRows)
            {
                if (truncateExtra)
                {
                    break;
                }
                else
                {
                    throw new SearchRowsExceededException ("Maximum rows exceeded:" + maxRows);
                }
            }

            if (context.containsObject(objectID))
            {
                BaseBusinessClass   cachedElement = context.getObjectToReplace(objectID, Message.REFERENCE_Message);

                if (cachedElement instanceof Message)
                {
                    LogMgr.log (MessagePersistence, LogLevel.TRACE, "Cache hit for id:", objectID);
                    resultElement = (Message)cachedElement;
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + objectID + " with object " + cachedElement + "while fetching a Message");
                }
            }
            else
            {
                PersistentSet tl_messagePSet = allPSets.getPersistentSet(objectID, "tl_message", PersistentSetStatus.FETCHED);
                
                createPersistentSetFromRS(allPSets, r, objectID);

                

                        resultElement = new Message ();

                        resultElement.setFromPersistentSets(objectID, allPSets);
                        context.addRetrievedObject(resultElement);

                
            }

            results.put (objectID, resultElement);
        }

        

        BaseBusinessClass[] resultsArr = new BaseBusinessClass[results.size ()];

        return results.values ().toArray (resultsArr);
    }



    public BaseBusinessClass[] find(String searchType, PersistentSetCollection allPSets, Hashtable criteria, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        LogMgr.log (MessagePersistence, LogLevel.DEBUG2, "Search executing:", searchType, " criteria:", criteria);
        String  customParamFilter = (String)criteria.get (SEARCH_CustomFilter);
        String  customOrderBy = (String)criteria.get (SEARCH_OrderBy);
        String  customTables = (String)criteria.get (SEARCH_CustomExtraTables);
        Boolean  noCommaBeforeCustomExtraTables = (Boolean)criteria.get (SEARCH_CustomExtraTablesNoComma);

        if (searchType.equals (SEARCH_CustomSQL))
        {
            Set<ObjectID>                     processedIDs = new HashSet();
            SearchParamTransform    tx = new SearchParamTransform (criteria);
            Object[]                searchParams;

            customParamFilter = StringUtils.replaceParams (customParamFilter, tx);
            searchParams = tx.getParamsArray();

            if (customOrderBy != null) 
            {
                customOrderBy = " ORDER BY " + customOrderBy;
            }
            else
            {
                customOrderBy = "";
            }


            ResultSet   r;
            String      concatCustomTableWith = CollectionUtils.equals(noCommaBeforeCustomExtraTables, true) ?  " " : ", ";
            String      tables = StringUtils.subBlanks(customTables) == null ? " " : concatCustomTableWith + customTables + " ";


            String  query = "SELECT " + SELECT_COLUMNS +
                                    "FROM {PREFIX}tl_message " + tables +
                                    "WHERE " + SELECT_JOINS + " " + customParamFilter + customOrderBy;

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, null, false);

            return results;
        }
        else if (searchType.equals (Message.SEARCH_All))
        {
            // Local scope for transformed variables
            {
                
            }


            
                String      orderBy = " ORDER BY tl_message.object_id";
                String      tables = " ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: tl_message.object_id is not null
                    String preFilter = "(tl_message.object_id is not null)"
                                     + "  ";
                    
                    
                    preFilter += context.getLoadingAttributes ().getCustomSQL() ;
                    
                    SearchParamTransform tx = new SearchParamTransform (criteria);
                    
                    filter = StringUtils.replaceParams (preFilter, tx);
                    searchParams = tx.getParamsArray();
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}tl_message " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        
        else
        {
            throw new IllegalArgumentException ("Illegal search type:" + searchType);
            
            
        }
    }

    private void createPersistentSetFromRS(PersistentSetCollection allPSets, ResultSet r, ObjectID objectID) throws SQLException
    {
        PersistentSet tl_messagePSet = allPSets.getPersistentSet(objectID, "tl_message", PersistentSetStatus.FETCHED);
        
            // Object Modified
            tl_messagePSet.setAttrib(BaseBusinessClass.FIELD_ObjectLastModified, r.getTimestamp ("LAST_UPDATED_DATE"));

            // Object Created
            tl_messagePSet.setAttrib(BaseBusinessClass.FIELD_ObjectCreated, r.getTimestamp ("CREATED_DATE"));

        tl_messagePSet.setAttrib(Message.FIELD_SentVia, HELPER_SentVia.getFromRS(dummySentVia, r, "sent_via"));
        tl_messagePSet.setAttrib(Message.FIELD_MessageContent, HELPER_MessageContent.getFromRS(dummyMessageContent, r, "message_content"));
        tl_messagePSet.setAttrib(Message.FIELD_IsRead, HELPER_IsRead.getFromRS(dummyIsRead, r, "is_read"));
        
        tl_messagePSet.setAttrib(Message.SINGLEREFERENCE_SentBy, r.getObject ("sent_by"));
        tl_messagePSet.setAttrib(Message.SINGLEREFERENCE_WorkFlowMessage, r.getObject ("work_flow_message"));
        tl_messagePSet.setAttrib(Message.SINGLEREFERENCE_JobApplication, r.getObject ("job_application_id"));
        
    }


    public void create(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        ObjectID    objectID = obj.getID ();
        PersistentSet tl_messagePSet = allPSets.getPersistentSet(objectID, "tl_message");
        

        
        if (tl_messagePSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_messagePSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            executeStatement (sqlMgr, 
                                     "INSERT INTO {PREFIX}tl_message " +
                                     "  (sent_via, message_content, is_read,  sent_by, work_flow_message, job_application_id,  object_id, object_LAST_UPDATED_DATE, object_CREATED_DATE) " +
                                     "VALUES " +
                                     "  (?, ?, ?,  ?, ?, ?,   ?,  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ",  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ")",
                                     CollectionUtils.listEntry (HELPER_SentVia.getForSQL(dummySentVia, tl_messagePSet.getAttrib (Message.FIELD_SentVia))).listEntry (HELPER_MessageContent.getForSQL(dummyMessageContent, tl_messagePSet.getAttrib (Message.FIELD_MessageContent))).listEntry (HELPER_IsRead.getForSQL(dummyIsRead, tl_messagePSet.getAttrib (Message.FIELD_IsRead))) .listEntry (SQLManager.CheckNull((Long)(tl_messagePSet.getAttrib (Message.SINGLEREFERENCE_SentBy)))).listEntry (SQLManager.CheckNull((Long)(tl_messagePSet.getAttrib (Message.SINGLEREFERENCE_WorkFlowMessage)))).listEntry (SQLManager.CheckNull((Long)(tl_messagePSet.getAttrib (Message.SINGLEREFERENCE_JobApplication)))) .listEntry (objectID.longID ()).toList().toArray());

            tl_messagePSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }
}
