
package performa.orm;

import java.io.*;
import java.util.*;
import java.sql.ResultSet;
import java.sql.SQLException;
import oneit.logging.*;
import oneit.objstore.*;
import oneit.objstore.assocs.*;
import oneit.objstore.rdbms.*;
import oneit.objstore.utils.*;
import oneit.sql.*;
import oneit.utils.resource.*;
import oneit.utils.*;
import oneit.utils.threading.*;
import performa.orm.types.*;



/**
 * IMPORTANT!!!! Autogenerated class, DO NOT EDIT!!!!!
 * Template: Infrastructure8.2[oneit.objstore.PersistenceMgrTemplate.xsl]
 */
public class SentEmailPersistenceMgr extends ObjectPersistenceMgr
{
    private static final LoggingArea SentEmailPersistence = LoggingArea.createLoggingArea(ObjectPersistenceMgr.OBJECT_PERSISTENCE, "SentEmail");

    // Private attributes corresponding to business object data
    private String dummySubject;
    private Date dummySentDate;
    private ApplicationStatus dummyApplicationStatus;
    private String dummyMessageContent;
    private String dummyEmailTo;
    

    // Static constants corresponding to attribute helpers
    private static final DefaultAttributeHelper HELPER_Subject = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_SentDate = DefaultAttributeHelper.INSTANCE;
    private static final EnumeratedAttributeHelper HELPER_ApplicationStatus = new EnumeratedAttributeHelper (ApplicationStatus.FACTORY_ApplicationStatus);
    private static final DefaultAttributeHelper HELPER_MessageContent = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_EmailTo = DefaultAttributeHelper.INSTANCE;
    



    public SentEmailPersistenceMgr ()
    {
        dummySubject = (String)(HELPER_Subject.initialise (dummySubject));
        dummySentDate = (Date)(HELPER_SentDate.initialise (dummySentDate));
        dummyApplicationStatus = (ApplicationStatus)(HELPER_ApplicationStatus.initialise (dummyApplicationStatus));
        dummyMessageContent = (String)(HELPER_MessageContent.initialise (dummyMessageContent));
        dummyEmailTo = (String)(HELPER_EmailTo.initialise (dummyEmailTo));
        
    }

    private String  SELECT_COLUMNS = "{PREFIX}tl_sent_email.object_id as id, {PREFIX}tl_sent_email.object_LAST_UPDATED_DATE as LAST_UPDATED_DATE, {PREFIX}tl_sent_email.object_CREATED_DATE as CREATED_DATE, {PREFIX}tl_sent_email.subject, {PREFIX}tl_sent_email.sent_date, {PREFIX}tl_sent_email.application_status, {PREFIX}tl_sent_email.message_content, {PREFIX}tl_sent_email.email_to, {PREFIX}tl_sent_email.job_application_id,  1 AS commasafe ";
    private String SELECT_JOINS = "";

    public BaseBusinessClass fetchByID(ObjectID id, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    resultByIDs = fetchByIDs(Collections.singleton (id), allPSets, context, sqlMgr);

        if (resultByIDs.isEmpty ())
        {
            return null;
        }
        else if (resultByIDs.size () > 1)
        {
            throw new StorageException ("Multiple results for id:" + id);
        }
        else
        {
            return resultByIDs.iterator ().next ();
        }
    }



    public Set<BaseBusinessClass> fetchByIDs(Set<ObjectID> ids, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    results = new HashSet ();
        Set<Long> idsToFetch = new HashSet ();

        for (ObjectID id : ids)
        {
            if (context.containsObject(id)) // Check for cached version
            {
                BaseBusinessClass objectToReturn = context.getObjectToReplace(id, SentEmail.REFERENCE_SentEmail);

                if (objectToReturn instanceof SentEmail)
                {
                    LogMgr.log (SentEmailPersistence, LogLevel.TRACE, "Cache hit for id:", id);
                    results.add (objectToReturn);
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + id + " with object " + objectToReturn + "while fetching a SentEmail");
                }
            }

            PersistentSet tl_sent_emailPSet = allPSets.getPersistentSet(id, "tl_sent_email", PersistentSetStatus.FETCHED);
            
            

             // Check for persistent sets already prefetched
            if (false  || !tl_sent_emailPSet.containsAttrib(BaseBusinessClass.FIELD_ObjectLastModified) ||
                    !tl_sent_emailPSet.containsAttrib(SentEmail.FIELD_Subject)||
                    !tl_sent_emailPSet.containsAttrib(SentEmail.FIELD_SentDate)||
                    !tl_sent_emailPSet.containsAttrib(SentEmail.FIELD_ApplicationStatus)||
                    !tl_sent_emailPSet.containsAttrib(SentEmail.FIELD_MessageContent)||
                    !tl_sent_emailPSet.containsAttrib(SentEmail.FIELD_EmailTo)||
                    !tl_sent_emailPSet.containsAttrib(SentEmail.SINGLEREFERENCE_JobApplication))
            {
                // We will need to retrieve it
                idsToFetch.add (id.longValue());
            }
            else
            {
                LogMgr.log (SentEmailPersistence, LogLevel.DEBUG2, "Persistent set preloaded id:", id);
        
                /* Non Polymorphic */
                SentEmail result = new SentEmail ();

                result.setFromPersistentSets(id, allPSets);
                context.addRetrievedObject(result);

                results.add (result);
            
            }
        }

        if (idsToFetch.size () > 0)
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_sent_email " +
                            "WHERE " + SELECT_JOINS + "{PREFIX}tl_sent_email.object_id IN ?";

            BaseBusinessClass[] resultsFetched = loadQuery (allPSets, sqlMgr, context, query, new Object[] { idsToFetch }, null, false);

            for (BaseBusinessClass objFetched : resultsFetched)
            {
                results.add (objFetched);
            }
        }


        return results;
    }



    public BaseBusinessClass[] getReferencedObjects(ObjectID _objectID, String refName, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        if (false)
        {
            throw new RuntimeException ();
        }
        else if (refName.equals (SentEmail.SINGLEREFERENCE_JobApplication))
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_sent_email " +
                            "WHERE " + SELECT_JOINS + "job_application_id = ?";

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, new Object[] { _objectID.longID () }, null, false);

            return results;
        }
        else
        {
            throw new IllegalArgumentException ("Illegal reference type:" + refName);
        }
    }



    public void update(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        EqualityResult  test = EqualityResult.compare (obj, obj.getBackup ());
        ObjectID        objectID = obj.getID ();

        if (!test.areAttributesEqual () || !test.areSingleAssocsEqual () || obj.getForcedSave())
        {
            PersistentSet tl_sent_emailPSet = allPSets.getPersistentSet(objectID, "tl_sent_email");
            

            
            if (tl_sent_emailPSet.getStatus () != PersistentSetStatus.PROCESSED &&
                tl_sent_emailPSet.getStatus () != PersistentSetStatus.DEFERRED)
            {
                int rowsUpdated = executeStatement (sqlMgr, 
                                                           "UPDATE {PREFIX}tl_sent_email " +
                                                           "SET subject = ?, sent_date = ?, application_status = ?, message_content = ?, email_to = ?, job_application_id = ?  , object_LAST_UPDATED_DATE = " + sqlMgr.getPortabilityServices ().getTimestampExpression () + " " +
                                                                
                                                           "WHERE tl_sent_email.object_id = ? AND " + getConcurrencyCheck (sqlMgr, "object_LAST_UPDATED_DATE", obj.getObjectLastModified ()) + " ",
                                                           CollectionUtils.listEntry (HELPER_Subject.getForSQL(dummySubject, tl_sent_emailPSet.getAttrib (SentEmail.FIELD_Subject))).listEntry (HELPER_SentDate.getForSQL(dummySentDate, tl_sent_emailPSet.getAttrib (SentEmail.FIELD_SentDate))).listEntry (HELPER_ApplicationStatus.getForSQL(dummyApplicationStatus, tl_sent_emailPSet.getAttrib (SentEmail.FIELD_ApplicationStatus))).listEntry (HELPER_MessageContent.getForSQL(dummyMessageContent, tl_sent_emailPSet.getAttrib (SentEmail.FIELD_MessageContent))).listEntry (HELPER_EmailTo.getForSQL(dummyEmailTo, tl_sent_emailPSet.getAttrib (SentEmail.FIELD_EmailTo))).listEntry (SQLManager.CheckNull((Long)(tl_sent_emailPSet.getAttrib (SentEmail.SINGLEREFERENCE_JobApplication)))).listEntry (objectID.longID ()).listEntry (obj.getObjectLastModified ()).toList().toArray());

                if (rowsUpdated != 1)
                {
                    // Error, either a concurrency error or a not-exists error
                    ResultSet r = executeQuery (sqlMgr, 
                                                       "SELECT object_id, object_LAST_UPDATED_DATE FROM {PREFIX}tl_sent_email WHERE object_id = ?",
                                                       new Object[] { objectID.longID () });

                    if (r.next ())
                    {
                        Date                d = new java.util.Date (r.getTimestamp (2).getTime());
                        String              errorMsg = QueryBuilder.buildQueryString ("Concurrent update error:[?] for row:[?] objDate:[?] dbDate:[?]", 
                                                                         new Object[] { "tl_sent_email", objectID.longID (), obj.getObjectLastModified (), d },
                                                                         sqlMgr.getPortabilityServices ());
                                                                         
                        LogMgr.log (SentEmailPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new ConcurrentUpdateConflictException (obj, "tl_sent_email");
                    }
                    else
                    {
                        String  errorMsg = "Attempt to update nonexistent row in table:tl_sent_email for row:" + objectID + " objDate:" + obj.getObjectLastModified ();

                        LogMgr.log (SentEmailPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new RuntimeException (errorMsg);
                    }
                }

                tl_sent_emailPSet.setStatus (PersistentSetStatus.PROCESSED);
            }
            
        }
        else
        {
            LogMgr.log (SentEmailPersistence, LogLevel.DEBUG1, "Skipping update since no attribs or simple assocs changed on ", objectID);
        }
    }



    public void delete(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        ObjectID        objectID = obj.getID ();
        PersistentSet tl_sent_emailPSet = allPSets.getPersistentSet(objectID, "tl_sent_email");
        

        LogMgr.log (SentEmailPersistence, LogLevel.DEBUG2, "Deleting:", objectID);

        
        if (tl_sent_emailPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_sent_emailPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            int rowsDeleted = executeStatement (sqlMgr, 
                                                       "DELETE " +
                                                       "FROM {PREFIX}tl_sent_email " +
                                                       "WHERE tl_sent_email.object_id = ? AND " + sqlMgr.getPortabilityServices ().getTruncatedTimestampColumn ("object_LAST_UPDATED_DATE") + " = " + sqlMgr.getPortabilityServices ().getTruncatedTimestampParam("?") + " ",
                                                       new Object[] { objectID.longID(), obj.getObjectLastModified () });

            if (rowsDeleted != 1)
            {
                // Error, either a concurrency error or a not-exists error
                ResultSet r = executeQuery (sqlMgr, 
                                                   "SELECT object_id FROM {PREFIX}tl_sent_email WHERE object_id = ?",
                                                   new Object[] { objectID.longID() });

                if (r.next ())
                {
                    throw new ConcurrentUpdateConflictException (obj, "tl_sent_email");
                }
                else
                {
                    String  errorMsg = "Attempt to delete nonexistent row in table:tl_sent_email for row:" + objectID;

                    LogMgr.log (SentEmailPersistence, LogLevel.SYSTEMERROR1, errorMsg);
                    throw new RuntimeException (errorMsg);
                }
            }

            tl_sent_emailPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }


    public ResultSet executeSearchQueryAll (SQLManager sqlMgr) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryAll");
    }
    



    public BaseBusinessClass[] loadQuery (PersistentSetCollection allPSets, SQLManager sqlMgr, RDBMSPersistenceContext context, String query, Object[] params, Integer maxRows, boolean truncateExtra) throws SQLException, StorageException
    {
        LinkedHashMap<ObjectID, SentEmail> results = new LinkedHashMap ();
        
        ResultSet   r = executeQuery (sqlMgr, query, params);

        while (r.next())
        {
            ThreadUtils.checkInterrupted ();
            
            ObjectID    objectID = new ObjectID (SentEmail.REFERENCE_SentEmail.getObjectIDSpace (), r.getLong ("id"));
            SentEmail resultElement;

            if (maxRows != null && !results.containsKey (objectID) && results.size () >= maxRows)
            {
                if (truncateExtra)
                {
                    break;
                }
                else
                {
                    throw new SearchRowsExceededException ("Maximum rows exceeded:" + maxRows);
                }
            }

            if (context.containsObject(objectID))
            {
                BaseBusinessClass   cachedElement = context.getObjectToReplace(objectID, SentEmail.REFERENCE_SentEmail);

                if (cachedElement instanceof SentEmail)
                {
                    LogMgr.log (SentEmailPersistence, LogLevel.TRACE, "Cache hit for id:", objectID);
                    resultElement = (SentEmail)cachedElement;
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + objectID + " with object " + cachedElement + "while fetching a SentEmail");
                }
            }
            else
            {
                PersistentSet tl_sent_emailPSet = allPSets.getPersistentSet(objectID, "tl_sent_email", PersistentSetStatus.FETCHED);
                
                createPersistentSetFromRS(allPSets, r, objectID);

                

                        resultElement = new SentEmail ();

                        resultElement.setFromPersistentSets(objectID, allPSets);
                        context.addRetrievedObject(resultElement);

                
            }

            results.put (objectID, resultElement);
        }

        

        BaseBusinessClass[] resultsArr = new BaseBusinessClass[results.size ()];

        return results.values ().toArray (resultsArr);
    }



    public BaseBusinessClass[] find(String searchType, PersistentSetCollection allPSets, Hashtable criteria, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        LogMgr.log (SentEmailPersistence, LogLevel.DEBUG2, "Search executing:", searchType, " criteria:", criteria);
        String  customParamFilter = (String)criteria.get (SEARCH_CustomFilter);
        String  customOrderBy = (String)criteria.get (SEARCH_OrderBy);
        String  customTables = (String)criteria.get (SEARCH_CustomExtraTables);
        Boolean  noCommaBeforeCustomExtraTables = (Boolean)criteria.get (SEARCH_CustomExtraTablesNoComma);

        if (searchType.equals (SEARCH_CustomSQL))
        {
            Set<ObjectID>                     processedIDs = new HashSet();
            SearchParamTransform    tx = new SearchParamTransform (criteria);
            Object[]                searchParams;

            customParamFilter = StringUtils.replaceParams (customParamFilter, tx);
            searchParams = tx.getParamsArray();

            if (customOrderBy != null) 
            {
                customOrderBy = " ORDER BY " + customOrderBy;
            }
            else
            {
                customOrderBy = "";
            }


            ResultSet   r;
            String      concatCustomTableWith = CollectionUtils.equals(noCommaBeforeCustomExtraTables, true) ?  " " : ", ";
            String      tables = StringUtils.subBlanks(customTables) == null ? " " : concatCustomTableWith + customTables + " ";


            String  query = "SELECT " + SELECT_COLUMNS +
                                    "FROM {PREFIX}tl_sent_email " + tables +
                                    "WHERE " + SELECT_JOINS + " " + customParamFilter + customOrderBy;

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, null, false);

            return results;
        }
        else if (searchType.equals (SentEmail.SEARCH_All))
        {
            // Local scope for transformed variables
            {
                
            }


            
                String      orderBy = " ORDER BY tl_scheduled_email.object_id";
                String      tables = " ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: tl_scheduled_email.object_id is not null
                    String preFilter = "(tl_scheduled_email.object_id is not null)"
                                     + "  ";
                    
                    
                    preFilter += context.getLoadingAttributes ().getCustomSQL() ;
                    
                    SearchParamTransform tx = new SearchParamTransform (criteria);
                    
                    filter = StringUtils.replaceParams (preFilter, tx);
                    searchParams = tx.getParamsArray();
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}tl_sent_email " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        
        else
        {
            throw new IllegalArgumentException ("Illegal search type:" + searchType);
            
            
        }
    }

    private void createPersistentSetFromRS(PersistentSetCollection allPSets, ResultSet r, ObjectID objectID) throws SQLException
    {
        PersistentSet tl_sent_emailPSet = allPSets.getPersistentSet(objectID, "tl_sent_email", PersistentSetStatus.FETCHED);
        
            // Object Modified
            tl_sent_emailPSet.setAttrib(BaseBusinessClass.FIELD_ObjectLastModified, r.getTimestamp ("LAST_UPDATED_DATE"));

            // Object Created
            tl_sent_emailPSet.setAttrib(BaseBusinessClass.FIELD_ObjectCreated, r.getTimestamp ("CREATED_DATE"));

        tl_sent_emailPSet.setAttrib(SentEmail.FIELD_Subject, HELPER_Subject.getFromRS(dummySubject, r, "subject"));
        tl_sent_emailPSet.setAttrib(SentEmail.FIELD_SentDate, HELPER_SentDate.getFromRS(dummySentDate, r, "sent_date"));
        tl_sent_emailPSet.setAttrib(SentEmail.FIELD_ApplicationStatus, HELPER_ApplicationStatus.getFromRS(dummyApplicationStatus, r, "application_status"));
        tl_sent_emailPSet.setAttrib(SentEmail.FIELD_MessageContent, HELPER_MessageContent.getFromRS(dummyMessageContent, r, "message_content"));
        tl_sent_emailPSet.setAttrib(SentEmail.FIELD_EmailTo, HELPER_EmailTo.getFromRS(dummyEmailTo, r, "email_to"));
        
        tl_sent_emailPSet.setAttrib(SentEmail.SINGLEREFERENCE_JobApplication, r.getObject ("job_application_id"));
        
    }


    public void create(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        ObjectID    objectID = obj.getID ();
        PersistentSet tl_sent_emailPSet = allPSets.getPersistentSet(objectID, "tl_sent_email");
        

        
        if (tl_sent_emailPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_sent_emailPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            executeStatement (sqlMgr, 
                                     "INSERT INTO {PREFIX}tl_sent_email " +
                                     "  (subject, sent_date, application_status, message_content, email_to,  job_application_id,  object_id, object_LAST_UPDATED_DATE, object_CREATED_DATE) " +
                                     "VALUES " +
                                     "  (?, ?, ?, ?, ?,  ?,   ?,  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ",  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ")",
                                     CollectionUtils.listEntry (HELPER_Subject.getForSQL(dummySubject, tl_sent_emailPSet.getAttrib (SentEmail.FIELD_Subject))).listEntry (HELPER_SentDate.getForSQL(dummySentDate, tl_sent_emailPSet.getAttrib (SentEmail.FIELD_SentDate))).listEntry (HELPER_ApplicationStatus.getForSQL(dummyApplicationStatus, tl_sent_emailPSet.getAttrib (SentEmail.FIELD_ApplicationStatus))).listEntry (HELPER_MessageContent.getForSQL(dummyMessageContent, tl_sent_emailPSet.getAttrib (SentEmail.FIELD_MessageContent))).listEntry (HELPER_EmailTo.getForSQL(dummyEmailTo, tl_sent_emailPSet.getAttrib (SentEmail.FIELD_EmailTo))) .listEntry (SQLManager.CheckNull((Long)(tl_sent_emailPSet.getAttrib (SentEmail.SINGLEREFERENCE_JobApplication)))) .listEntry (objectID.longID ()).toList().toArray());

            tl_sent_emailPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }
}
