package performa.ws;

import oneit.appservices.ws.*;
import oneit.appservices.ws.serialisation.*;
import oneit.appservices.ws.services.*;
import oneit.components.InitialisationParticipant;
import oneit.objstore.ObjectTransaction;
import oneit.security.SecUser;
import oneit.utils.MultiException;
import oneit.utils.parsers.FieldException;
import org.json.*;
import performa.orm.*;
import performa.utils.*;

/**
 *
 * @author harsh
 */
public class AdminUserDetailsJSONService extends BasicJSONService implements InitialisationParticipant
{
    @Override
    public JSONObject serviceRequestSafe(JSONServiceRequest request) throws MultiException, FieldException, Exception
    {
        ObjectTransaction   objTran     =   WSUtils.createTransaction(request);

        try
        {
            JSONObject      result      =   new JSONObject();
            SecUser         user        =   SecUser.getTXUser(objTran);
            SecUser         clientUser  =   Utils.checkAdminPortalAccess(user) ? user : null;
            Company         company     =   null;
            JSONSerialiser  serialiser  =   new JSONSerialiser(new ProfileAttribSerialiser(null));
        
            serialiser.setServices(request);
            if(clientUser != null)
            {
                if(clientUser.getExtension(CompanyUser.REFERENCE_CompanyUser) != null)
                {
                    company =   clientUser.getExtension(CompanyUser.REFERENCE_CompanyUser).getCompany();
                }
                CompanyUser companyUser     =   clientUser.getExtension(CompanyUser.REFERENCE_CompanyUser);
                HiringTeam  selectedTeam    =   (HiringTeam) request.getRequest().getSession().getAttribute("SelectedHiringTeam");

                result.put("ClientName", Utils.getClientUserName(clientUser));
                result.put("HomeURL", WebUtils.getArticleByShortCut(user.getTransaction(), WebUtils.ADMIN_HOME).getLink(request.getRequest()));
                
                if(company != null)
                {
                    result.put("CompanyName", company.getCompanyName());
                }
                
                if(companyUser != null)
                {
                    result.put("CompanyUser", serialiser.convertBBCToJSON(companyUser));
                    
                    JSONArray   hiringTeamJSON  =   new JSONArray();
                    
                    for(HiringTeam hiringTeam : Utils.getHiringTeamsByUser(companyUser))
                    {
                        hiringTeamJSON.put(serialiser.convertBBCToJSON(hiringTeam));
                    }
                    result.put("HiringTeams", hiringTeamJSON);
                    
                    if(selectedTeam == null)
                    {
                        selectedTeam    =   companyUser.getSelectedTeam();
                    }
                }
                
                if(selectedTeam != null)
                {
                    selectedTeam    =   selectedTeam.getInTransaction(objTran);
                    result.put("SelectedTeam", serialiser.convertBBCToJSON(selectedTeam));
                    result.put("CreateJobDisabled", !selectedTeam.hasBillingSetup());
                }
            }
            return result;
        }
        finally     // Clean up tranasaction in a finally
        {
            objTran.releaseResources();
        }
    }
}