import { Component, OnInit, OnDestroy, ViewChild } from '@angular/core';
import { Router, ActivatedRoute, Params } from '@angular/router';
import { NgForm } from '@angular/forms';
import { Subscription } from 'rxjs/Subscription';

import { Message, MenuItem } from 'primeng/primeng';

import { AppService } from './../../app.service';
import { UtilsService } from './../../oneit/services/utils.service';
import { SaveService } from './../../oneit/services/save.service';
import { EditJobService } from './edit-job.service';

import { Job } from './edit-job.model';

@Component({
    selector: 'app-edit-job',
    templateUrl: './edit-job.component.html'
})
export class EditJobComponent implements OnInit, OnDestroy {
    
    subscriptions: Array<Subscription> = [];
    @ViewChild('form') form: NgForm;
    createdObjs =   {};
    updatedObjs =   {};
    deletedObjs =   {};

    job = new Job();
    selectWorkflows: any[] = [];
    showLoader: boolean = false;
    
    constructor(
        private router: Router,
        private activatedRoute: ActivatedRoute,
        private utilsService: UtilsService,
        private saveService: SaveService,
        private appService: AppService,
        private editJobService: EditJobService
    ){
        
    }

    ngOnInit() {

        this.utilsService.resetCounter();
        
        this.subscriptions.push(this.activatedRoute.params
            .subscribe(
                (params: Params) => {
                    this.showLoader = true;
                    if (params.id && params.id !== '0') {
                        this.getJobByID(params.id);
                    } else {
                        this.utilsService.createObject(this.job, this.createdObjs);
                        this.showLoader = false;
                    }
                }
        ));
        this.getSelectWorkflows();
    }
    

    getSelectWorkflows() {
        this.subscriptions.push(this.editJobService.getSelectWorkflows([])
            .subscribe(
                data => {
                    this.selectWorkflows = data;
                },
                error => {
                    this.utilsService.handleError(error);
                }
            )
        );
    }

    getJobByID(id) {
        
        this.showLoader = true;
        this.createdObjs = {};
        this.updatedObjs = {};
        this.deletedObjs = {};
        this.utilsService.resetCounter();
        this.utilsService.clearErrorMessages();
        
        let assocs  =   [];
        this.subscriptions.push(this.editJobService.getJobByID(id, assocs)
            .subscribe(
                data => {
                    this.job = data;
                    this.updatedObjs[this.job.ObjectID] = this.job;

                    //Loop over other multirefs here, which can be updated on screen e.g

                    this.showLoader = false;
                },
                error => {
                    this.showLoader = false;
                    this.utilsService.handleError(error);
                }
            )
        );
    }
    
    saveJob(reload: boolean) {
        this.utilsService.clearErrorMessages();
        
        if (this.form.invalid) {
            this.utilsService.showAllErrorMessages();
        } else {
            this.showLoader = true;
            this.subscriptions.push(this.saveService.saveObjectsWithDefaultSvc(this.createdObjs, this.updatedObjs, this.deletedObjs)
                .subscribe(
                    data => {
                        this.utilsService.handleSuccess();
                        if (reload) {
                            let idToNavigate = this.job.ObjectID;
                            if (data["created"][idToNavigate]) {
                                idToNavigate = data["created"][idToNavigate];
                                this.router.navigate(["/edit-job", idToNavigate]);
                                return;
                            }
                            this.getJobByID(idToNavigate);
                        }
                        else {
                            this.router.navigate([""]);
                        }
                    },
                    error => {
                        this.showLoader = false;
                        this.utilsService.handleError(error);
                    }
                )
            );
        }
    }
    
    ngOnDestroy(){
        this.utilsService.unsubscribeSubscriptions(this.subscriptions);
    }
}