/**
 * Reference : https://stripe.com/docs/stripe-js#elements
 */

// Create a Stripe client
var stripe = Stripe(stripePubKey);

// Create an instance of Elements
var elements = stripe.elements(
        {
    fonts:[
        {family : 'Usual-Light',
            src : 'url("data:font/truetype;charset=utf-8;base64,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")'
        }
         ]
    }
);

// Custom styling can be passed to options when creating an Element.
var style = {
  base: {
    // Add your base input styles here. For example:
    fontSize: '14px',
    fontFamily: '"Usual-Light"',
    color: "#555",
    '::placeholder': {
        color: '#DBDBDF',
        fontSize: '14px',
    },
//    padding-top: "7px !important",
  }
};

var cardNumber = elements.create('cardNumber', {style: style, placeholder: ''});
cardNumber.mount('#card-number');

var cardExpiry = elements.create('cardExpiry', {style: style});
cardExpiry.mount('#card-expiry');

var cardCvc = elements.create('cardCvc', {style: style, placeholder: ''});
cardCvc.mount('#card-cvc');

cardNumber.addEventListener('change', function(event) {
  var displayError = document.getElementById('card-errors');
  if (event.error) {
    displayError.textContent = event.error.message;
  } else {
    displayError.textContent = '';
  }
});
cardExpiry.addEventListener('change', function(event) {
  var displayError = document.getElementById('card-errors');
  if (event.error) {
    displayError.textContent = event.error.message;
  } else {
    displayError.textContent = '';
  }
});
cardCvc.addEventListener('change', function(event) {
  var displayError = document.getElementById('card-errors');
  if (event.error) {
    displayError.textContent = event.error.message;
  } else {
    displayError.textContent = '';
  }
});

// Create a token or display an error when the form is submitted.
var form = document.getElementById('makePayment');

form.addEventListener('submit', function(event) {
    event.preventDefault();

    var nameOnCard  = document.getElementById('NameOnCard').value;
    var postalCode  = document.getElementById('PostCode').value;
    
    stripe.createToken(cardNumber, {name: nameOnCard, address_zip : postalCode}).then(function(result) {
        if (result.error) {
            // Inform the customer that there was an error
            var errorElement = document.getElementById('card-errors');
            errorElement.textContent = result.error.message;
        } else {
            // Send the token to your server
            $('input[name=stripe-token-id]').val(result.token.id);
            $('#payNow').click();
        }
    });
});