<%@ page extends="oneit.servlets.jsp.JSPInclude" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    Job     job         = (Job) process.getAttribute("Job");
    String  fourthPage   = WebUtils.getSamePageInRenderMode(request, WebUtils.JOB_MATCH);
    String  secondPage  = WebUtils.getSamePageInRenderMode(request, WebUtils.ASSESSMENT_CRITERIA);

%>
    
    <script type="text/javascript">
        
        $(document).ready(function() 
        {
            $("input[name$='CultureElementRating']").click(function() 
            {
                var id = $(this).attr('id');
                var val = $(this).val();
                
                $("div." + val).hide();
                $("div." + id).show();
            });
            
            $(".importance input[type='radio']").each(function()
            {
                $(this).parent('li').removeClass("active" );
               
                if($(this).is(":checked"))
                {
                    $(this).parent('li').addClass("active" );
                }
            });
            
            $(".importance input[type='radio']").change(function() 
            {               
                $(this).closest('li').addClass("active" );
            });
            
        });
        
    </script>
    
    <oneit:form name="editJob" method="post" enctype="multipart/form-data" action="<%= secondPage %>">
    
        <div class="container-fluid">
                 
            <h1 class="page-title">Create a job <span class="active-time">(Active for 30 days)</span> </h1>
       
            <oneit:dynInclude   page="/extensions/adminportal/inc/job_main_tabs.jsp"    PageNumber="3"    data="<%= CollectionUtils.EMPTY_MAP%>"/>

            <div class="form-page-area">
                <div class="create-job">
                    <div class="assessment-criteria">
                        <div class="form-group">
                            <label class="label-16 work-title">Workplace Culture</label>
                            <p>
                              Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Duis autem vel eum iriure dolor in hendrerit.
                            </p>      
                        </div>
                        <div class="form-group">
                            <select class="form-control">
                                <option>Optional: Select previously defined Workplace Culture</option>
                                <option>One 1</option>
                                <option>One 2</option>
                                <option>One 3</option>
                          </select>              
                        </div>              
                        <div class="form-brack-line-sub"></div> 
                        <%
                            FormTag     jobForm     = FormTag.getActiveFormTag(request);
                            FormBuilder formBuilder = jobForm.getFormBuilder();

                            for(CultureClass cultureClass : CultureClass.getCultureClassArray())
                            {
                        %>
                                <div class="form-group">
                                    <div class="work-belonging">
                                        <oneit:toString value="<%= cultureClass %>" mode="EscapeHTML"/>
                                    </div>
                                    <%
                                        for(CultureElement element : CultureElement.SearchByAll().andCultureClass(new EqualsFilter<>(cultureClass)).search(transaction))
                                        {
                                            CultureCriteria culture =   CultureCriteria.createCultureCriteria(transaction);

                                            culture.setCultureElement(element);
                                            culture.setJob(job);

                                            String  optionKey   = WebUtils.getRadioSingleAssocKey(request, culture, CultureCriteria.SINGLEREFERENCE_CultureElementRating);
                                            String  formValue   = formBuilder.fieldValue (optionKey, culture.getCultureElementRating() == null ? "" : culture.getCultureElementRating().getID().toString());
                                    %>
                                            <div class="work-radio-title">
                                                <oneit:toString value="<%= element.getDescription() %>" mode="EscapeHTML"/>
                                            </div>
                                            <%
                                                for (CultureElementRating rating : element.getRatingsSet())
                                                {
                                                    String  id          = String.valueOf(rating.getID().longID());
                                                    String  selectedStr = (CollectionUtils.equals(id, formValue) ? "checked" : "");
                                            %>
                                                    <div class="<%= "radio radio-primary workplace-radio " %>">
                                                        <input type="radio" name="<%= optionKey %>" id="<%= id %>"  <%= selectedStr %>  value="<%= String.valueOf(culture.getID().longID()) %>">
                                                        <label for="<%= id %>">
                                                            <oneit:toString value="<%= rating.getDescription() %>" mode="EscapeHTML"/>
                                                        </label>
                                                    </div>
                                                    <div class="<%= "work-rating " + id + " " + String.valueOf(culture.getID().longID()) %>" style="display: none;">
                                                        <div class="rate-background">
                                                            <span class="arrow-up-gray"></span>
                                                            <span class="rate-label">
                                                                <oneit:ormlabel  obj="<%= culture %>"   field="Importance" />
                                                            </span>
                                                            <span class="rate-toggle">
                                                                <ul class="nav nav-pills nav-justified loyalty-ul">
                                                                    
                                                            <%

                                                                String  importanceKey   =   WebUtils.getInputKey(request, culture, CultureCriteria.FIELD_Importance);
                                                                String  importanceValue =   formBuilder.fieldValue (importanceKey, culture.getImportance() == null ? "" : culture.getImportance().getName());
                                                                
                                                                for(Importance importance : Importance.getImportanceArray())
                                                                {
                                                                    boolean isSelected      = CollectionUtils.equals(importanceValue, importance.getName());
                                                                    String  importanceId    = "importance_" + importance.getName();
                                                                    String  selected        = (isSelected) ? "checked" : "";
                                                            %>
                                                                    <li>
                                                                        <a href="javascript:void(0)" class="importance">

                                                                                <input type="radio" name="<%= importanceKey %>" value="<%= importance.getName() %>" id="<%= importanceId %>" <%= selected %>/>
                                                                                <label for="<%= importanceId %>"><oneit:toString value="<%= importance %>" mode="EscapeHTML" /></label>
                                                                        </a>

                                                                    </li>
                                                            <%
                                                                }
                                                            %>
                                                                </ul>
                                                            </span>                      
                                                        </div>
                                                    </div>
                                    <%
                                                }
                                        }
                                    %>
                                </div>
                                <div class="form-brack-line-sub"></div>
                        <%
                            }
                        %>
                        
                        <div class="form-group">
                            <div class="save-assess">
                                <div class="checkbox checkbox-primary">
                                    <input id="checkbox2" type="checkbox" checked>
                                    <label for="checkbox2">
                                      Save this Assessment Criteria as a template
                                    </label>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="input-group input-group-lg">                    
                                <div class="icon-addon addon-lg">
                                    <input type="text" placeholder="Template Name" class="form-control" id="email">
                                </div>
                                <span class="input-group-btn">
                                    <button class="btn btn-primary" type="button">SAVE</button>
                                </span>
                            </div>
                        </div>
                        <div class="text-center">
                            <input type="button" class="btn btn-primary top-margin-25" value="Proceed to Job Match" />
                        </div>
                    </div>
                </div>
            </div>                                    
        </div>
    </oneit:form>
</oneit:dynIncluded>