package performa.utils;

import oneit.objstore.ObjectTransaction;
import oneit.security.*;

/**
 *
 * @author Harsh
 */
public class Utils
{
    public static final String  ROLE_APPLICANT              =   "TL_Applicant";
    public static final String  ROLE_CLIENT                 =   "TL_Client";
    public static final String  PRIV_ACCESS_ADMIN_PORTAL    =   "TL_AccessAdminPortal";
    
    public static Role  getRole(String role, ObjectTransaction transaction)
    {
        return Role.SearchByNAME().byName(role).search(transaction);
    }
    
    public static Privilege  getPrivilege(String priv, ObjectTransaction transaction)
    {
        return Privilege.searchNAME(transaction, priv);
    }
    
    public static boolean checkAdminPortalAccess(SecUser secUser)
    {
        return (secUser != null && secUser.hasPrivilege(PRIV_ACCESS_ADMIN_PORTAL));
    }
}
