package performa.orm;

import java.util.Collection;
import java.util.List;
import oneit.logging.LoggingArea;
import oneit.objstore.rdbms.filters.EqualsFilter;
import oneit.utils.filter.CollectionFilter;
import oneit.utils.filter.Filter;
import oneit.utils.parsers.FieldException;
import performa.orm.types.CriteriaType;


public class JobApplication extends BaseJobApplication
{
    private static final long   serialVersionUID    = 0L;
    public  static LoggingArea  LOG                 = LoggingArea.createLoggingArea("JobApplication");
    
    // This constructor should not be called
    public JobApplication ()
    {
        // Do not add any code to this, always put it in initialiseNewObject
    }

    
    public void initACAnswers() throws FieldException
    {
        for(AssessmentCriteria ac: getJob().getAssessmentCriteriasSet())
        {
            AssessmentCriteriaAnswer    answer  = AssessmentCriteriaAnswer.createAssessmentCriteriaAnswer(getTransaction());

            answer.setJobApplication(this);
            answer.setAssessmentCriteria(ac);
        }
    }
    
    
    public void initCCAnswers() throws FieldException
    {
        for(CultureCriteria cc: getJob().getCultureCriteriasSet())
        {
            CultureCriteriaAnswer   answer  = CultureCriteriaAnswer.createCultureCriteriaAnswer(getTransaction());
            
            answer.setJobApplication(this);
            answer.setCultureCriteria(cc);
        }
    }
    
    
    public Answer getPAAnswerOrCreate(Question question, int index) throws FieldException
    {
        Filter  filter  = Answer.SearchByAll().andQuestion(new EqualsFilter<>(question));
        Answer  answer  = CollectionFilter.getFirstMatch(getProfileAssessmentAnswersSet(), filter);
        
        if(answer==null)
        {
            answer  = Answer.createAnswer(getTransaction());
            
            answer.setJobApplication(this);
            answer.setQuestion(question);
            
            if(question.getRightQuestion()!=null)
            {
                Answer  rightAnswer = Answer.createAnswer(getTransaction());
            
                rightAnswer.setJobApplication(this);
                rightAnswer.setQuestion(question);
            }
        }
        
        return answer;
    }
    
    
    public Collection<AssessmentCriteriaAnswer> getACAnswersByType(CriteriaType criteria)
    {
        Filter  filter  = AssessmentCriteriaAnswer.SearchByCriteriaType()
                                                .andJobApplication(new EqualsFilter<>(this))
                                                .byCriteriaType(criteria);   

        return  CollectionFilter.filter(getAssessmentCriteriaAnswersSet(), filter);
    }

    
    public Boolean selectionCompleted()
    {
        return Boolean.FALSE;
    }
       
    
    public Boolean cultureCompleted()
    {
        return Boolean.FALSE;
    }
    
    
    public Boolean assessmentCompleted()
    {
        return Boolean.FALSE;
    }
}