package performa.batch;

import oneit.appservices.batch.ORMBatch;
import oneit.logging.*;
import oneit.objstore.ObjectTransaction;
import oneit.objstore.StorageException;
import oneit.objstore.rdbms.filters.LessThanFilter;
import oneit.utils.DateDiff;
import oneit.utils.parsers.FieldException;
import performa.orm.Job;
import performa.orm.types.JobStatus;


public class CloseJobBatch  extends ORMBatch
{
    public static LoggingArea CLOSE_JOB_BATCH = LoggingArea.createLoggingArea("CloseJobBatch");

    @Override
    public void run(ObjectTransaction ot) throws StorageException, FieldException
    {
        LogMgr.log (CLOSE_JOB_BATCH, LogLevel.DEBUG2, "RUNNING Close Job Batch");

        Job[]   expiringJobs    = Job.SearchByAll()
                                        .andApplyBy(new LessThanFilter<>(DateDiff.getToday()))
                                        .search(ot);
        
        for (Job job : expiringJobs)
        {
            job.setJobStatus(JobStatus.COMPLETE);
            
            LogMgr.log(CLOSE_JOB_BATCH, LogLevel.DEBUG2, "Setting Job Status to Closed in job : ", job);
        }
    }
}