package performa.form;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oneit.logging.*;
import oneit.objstore.StorageException;
import oneit.servlets.forms.*;
import oneit.servlets.process.*;
import oneit.utils.*;
import performa.orm.Job;
import performa.orm.types.JobStatus;
 

public class ChangeJobStatusFP extends SaveFP
{
    private static final LoggingArea  LOG =   LoggingArea.createLoggingArea("ChangeJobStatusFP");
    
    
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        HttpServletRequest  request     =   submission.getRequest();
        Job                 job         =   (Job) request.getAttribute("Job");
        JobStatus           newStatus   =   (JobStatus) request.getAttribute("newStatus");
        
        if(job!= null && newStatus != null)
        {
            job.setJobStatus(newStatus);
            
            LogMgr.log(LOG, LogLevel.PROCESSING1, "Change Job status", job, newStatus);
        }
        
        return super.processForm(process, submission, params);
    }
}