import { Component, EventEmitter, Input, Output, ViewChild } from '@angular/core';
import { Select2Component } from "ng2-select2";

@Component({
    selector: 'app-select-2',
    templateUrl: './select-2.component.html',
    styleUrls: ['./select-2.component.scss']
})
export class SelectTwoComponent {
    @Input() data: Array<any>;
    @Input() fieldLabel: string;
    @Input() value: any;
    @ViewChild('mySelect') mySelect: Select2Component;
    options: {};
    // tslint:disable-next-line:prefer-output-readonly
    @Output() valChange: EventEmitter<any> = new EventEmitter<any>();

    // tslint:disable-next-line:no-empty
    constructor() {
    }

    ngOnInit(): void {
        this.options = {minimumResultsForSearch: Infinity};

        if (!this.data) {
            return;
        }

        this.value = this.value ? (this.value.id ? this.value.id :
            (this.value.ObjectID ? this.value.ObjectID : 0)) : 0;

        this.data.map((elem, index) => {
            elem.id = elem.ObjectID ? elem.ObjectID : index;
            elem.text = elem[this.fieldLabel];

            return elem;
        });
    }

}
