import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { Subscription } from 'rxjs/Subscription';
import { AppService } from '../../app.service';
import { SEARCH, SERVICES } from '../../constants';
import { SorterModel } from '../../models/sorterModel';
import { WorkflowTemplateModel } from '../../models/workflowTemplate.model';
import { UtilsService } from '../../oneit/services/utils.service';
import { BaseComponent } from '../base/base.component';

@Component({
    selector: 'app-list-work-flows',
    templateUrl: './list-work-flows.component.html'
})
export class ListWorkFlowsComponent extends BaseComponent implements OnInit {

    subscriptions: Array<Subscription> = [];
    myTemplates: Array<WorkflowTemplateModel> = [];
    sharedTemplates: Array<WorkflowTemplateModel> = [];
    sortOptions: Array<SorterModel>;
    showLoader = false;

    constructor(
        private router: Router,
        private utilsService: UtilsService,
        private appService: AppService
    ) {
        super(utilsService);
    }

    ngOnInit(): void {
        this.sortOptions = [
            new SorterModel('Alphabetical (A-Z)', true),
            new SorterModel('Alphabetical (Z-A)', false)
        ];
        const sharedParams = {
            OnlyGlobalTemplates: true
        };
        const myParams = {
            OnlyGlobalTemplates: false
        };
        this.subscriptions.push(
            this.appService.getSearchListing(SERVICES.WORKFLOW_TEMPLATES, 'All', myParams, [], SEARCH.WORKFLOW_TEMPLATE)
                .subscribe(
                    messages => {
                        this.myTemplates = messages;
                        this.sortSpecificTemplate('myTemplates');
                    },
                    error => {
                        this.showLoader = false;
                        this.utilsService.handleError(error);
                    }
                )
        );
        this.subscriptions.push(
            this.appService.getSearchListing(SERVICES.WORKFLOW_TEMPLATES, 'All', sharedParams, [], SEARCH.WORKFLOW_TEMPLATE)
                .subscribe(
                    messages => {
                        this.sharedTemplates = messages;
                        this.sortSpecificTemplate('sharedTemplates');
                    },
                    error => {
                        this.showLoader = false;
                        this.utilsService.handleError(error);
                    }
                )
        );
        setTimeout(() => (this.showLoader = false), 0);
    }

    sortSpecificTemplate(arrayName: string): void {
        this[arrayName] = this.utilsService.sort(this[arrayName],
            ['TemplateName'], [this.sortOptions[0].ascending ? 1 : -1], false);
    }

    sortWorkFlowTemplates($event): void {
        if (!$event.data[0]) {
            return;
        }
        const sort = $event.data[0];
        this.showLoader = true;
        this.myTemplates = this.utilsService.sort(this.myTemplates,
            ['TemplateName'], [sort.ascending ? 1 : -1], false);
        this.sharedTemplates = this.utilsService.sort(this.sharedTemplates,
            ['TemplateName'], [sort.ascending ? 1 : -1], false);
        this.showLoader = false;

    }

    onRowSelect(data: WorkflowTemplateModel): void {
        this.router.navigate(['/admin/edit-workflow-template', data.ObjectID]);
    }
}
