import { Message } from '@angular/compiler/src/i18n/i18n_ast';
import { Component, OnInit } from '@angular/core';
import { Subscription } from 'rxjs';
import { MsgsService } from '../../oneit/services/msgs.service';
import { UtilsService } from '../../oneit/services/utils.service';

@Component({
    selector: 'app-error-message',
    templateUrl: './error-message.component.html'
})
export class ErrorMessageComponent implements OnInit {

    subscriptions: Array<Subscription> = [];
    errorMsgs: Message[] = [];
    showAllErrorsCalled: boolean = false;
    dialogOpen: boolean = false;

    constructor(
        private msgsService: MsgsService,
        private utilsService: UtilsService,
    ) { }

    ngOnInit() {
        this.subscriptions.push(
            this.msgsService.errorMsgsUpdated.subscribe(
                data => {
                    console.log(data);
                    this.errorMsgs = data;
                }
            )
        );

        this.subscriptions.push(
            this.msgsService.showAllErrors.subscribe((data) => {
                this.showAllErrorsCalled = data;
            })
        );
    }

    ngOnDestroy() {
        this.utilsService.unsubscribeSubscriptions(this.subscriptions);
    }
}
