package performa.form;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oneit.logging.*;
import oneit.objstore.StorageException;
import oneit.servlets.forms.*;
import oneit.servlets.process.*;
import oneit.utils.BusinessException;
import performa.orm.*;

/**
 *
 * @author Harsh
 */
public class ChangeAssessmentCriteriaFP extends ORMProcessFormProcessor
{
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        HttpServletRequest          request     =   submission.getRequest();
        Job                         job         =   (Job) request.getAttribute("Job");
        AssessmentCriteriaTemplate  template    =   (AssessmentCriteriaTemplate) request.getAttribute("AssessmentCriteriaTemplate");

        LogMgr.log(Job.LOG, LogLevel.PROCESSING1, "Inside ChangeAssessmentCriteriaFP for ", job != null ? job : template , " Include Assessment:", job != null ? job.getIncludeAssessmentCriteria() : template.getIncludeAssessmentCriteria());
        
        if(job != null ?  !job.isTrue(job.getIncludeAssessmentCriteria()) : !template.isTrue(template.getIncludeAssessmentCriteria()))
        {
            for(AssessmentCriteria assessmentCriteria : job != null ? job.getAssessmentCriteriasSet() : template.getAssessmentCriteriasSet())
            {
                assessmentCriteria.delete();
            }
        }
        
        LogMgr.log(Job.LOG, LogLevel.PROCESSING1, "ChangeAssessmentCriteriaFP completed for ", job != null ? job : template);
        
        return RedisplayResult.getInstance();
    }
}
