
package performa.orm;

import java.io.*;
import java.util.*;
import java.sql.ResultSet;
import java.sql.SQLException;
import oneit.logging.*;
import oneit.objstore.*;
import oneit.objstore.assocs.*;
import oneit.objstore.rdbms.*;
import oneit.objstore.utils.*;
import oneit.sql.*;
import oneit.utils.resource.*;
import oneit.utils.*;
import oneit.utils.threading.*;
import performa.orm.types.*;
import performa.orm.types.TimeZone;
import oneit.business.shopping.orm.*;



/**
 * IMPORTANT!!!! Autogenerated class, DO NOT EDIT!!!!!
 * Template: Infrastructure8.2[oneit.objstore.PersistenceMgrTemplate.xsl]
 */
public class ClientPersistenceMgr extends ObjectPersistenceMgr
{
    private static final LoggingArea ClientPersistence = LoggingArea.createLoggingArea(ObjectPersistenceMgr.OBJECT_PERSISTENCE, "Client");

    // Private attributes corresponding to business object data
    private String dummyClientName;
    private BinaryContent dummyClientLogo;
    private String dummyEmail;
    private String dummyContactName;
    private String dummyContactSurname;
    private String dummyPhone;
    private State dummyState;
    private Countries dummyCountry;
    private String dummyPostCode;
    private String dummyCity;
    private TimeZone dummyTimeZone;
    

    // Static constants corresponding to attribute helpers
    private static final DefaultAttributeHelper HELPER_ClientName = DefaultAttributeHelper.INSTANCE;
    private static final BLOBAttributeHelper HELPER_ClientLogo = BLOBAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_Email = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_ContactName = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_ContactSurname = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_Phone = DefaultAttributeHelper.INSTANCE;
    private static final EnumeratedAttributeHelper HELPER_State = new EnumeratedAttributeHelper (State.FACTORY_State);
    private static final EnumeratedAttributeHelper HELPER_Country = new EnumeratedAttributeHelper (Countries.FACTORY_Countries);
    private static final DefaultAttributeHelper HELPER_PostCode = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_City = DefaultAttributeHelper.INSTANCE;
    private static final EnumeratedAttributeHelper HELPER_TimeZone = new EnumeratedAttributeHelper (TimeZone.FACTORY_TimeZone);
    



    public ClientPersistenceMgr ()
    {
        dummyClientName = (String)(HELPER_ClientName.initialise (dummyClientName));
        dummyClientLogo = (BinaryContent)(HELPER_ClientLogo.initialise (dummyClientLogo));
        dummyEmail = (String)(HELPER_Email.initialise (dummyEmail));
        dummyContactName = (String)(HELPER_ContactName.initialise (dummyContactName));
        dummyContactSurname = (String)(HELPER_ContactSurname.initialise (dummyContactSurname));
        dummyPhone = (String)(HELPER_Phone.initialise (dummyPhone));
        dummyState = (State)(HELPER_State.initialise (dummyState));
        dummyCountry = (Countries)(HELPER_Country.initialise (dummyCountry));
        dummyPostCode = (String)(HELPER_PostCode.initialise (dummyPostCode));
        dummyCity = (String)(HELPER_City.initialise (dummyCity));
        dummyTimeZone = (TimeZone)(HELPER_TimeZone.initialise (dummyTimeZone));
        
    }

    private String  SELECT_COLUMNS = "{PREFIX}tl_client.object_id as id, {PREFIX}tl_client.object_LAST_UPDATED_DATE as LAST_UPDATED_DATE, {PREFIX}tl_client.object_CREATED_DATE as CREATED_DATE, {PREFIX}tl_client.client_name, {PREFIX}tl_client.client_logo, {PREFIX}tl_client.email, {PREFIX}tl_client.contact_name, {PREFIX}tl_client.contact_surname, {PREFIX}tl_client.phone, {PREFIX}tl_client.state, {PREFIX}tl_client.country, {PREFIX}tl_client.post_code, {PREFIX}tl_client.city, {PREFIX}tl_client.time_zone, {PREFIX}tl_client.hiring_team_id, {PREFIX}tl_client.company_id,  1 AS commasafe ";
    private String SELECT_JOINS = "";

    public BaseBusinessClass fetchByID(ObjectID id, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    resultByIDs = fetchByIDs(Collections.singleton (id), allPSets, context, sqlMgr);

        if (resultByIDs.isEmpty ())
        {
            return null;
        }
        else if (resultByIDs.size () > 1)
        {
            throw new StorageException ("Multiple results for id:" + id);
        }
        else
        {
            return resultByIDs.iterator ().next ();
        }
    }



    public Set<BaseBusinessClass> fetchByIDs(Set<ObjectID> ids, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    results = new HashSet ();
        Set<Long> idsToFetch = new HashSet ();

        for (ObjectID id : ids)
        {
            if (context.containsObject(id)) // Check for cached version
            {
                BaseBusinessClass objectToReturn = context.getObjectToReplace(id, Client.REFERENCE_Client);

                if (objectToReturn instanceof Client)
                {
                    LogMgr.log (ClientPersistence, LogLevel.TRACE, "Cache hit for id:", id);
                    results.add (objectToReturn);
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + id + " with object " + objectToReturn + "while fetching a Client");
                }
            }

            PersistentSet tl_clientPSet = allPSets.getPersistentSet(id, "tl_client", PersistentSetStatus.FETCHED);
            
            

             // Check for persistent sets already prefetched
            if (false  || !tl_clientPSet.containsAttrib(BaseBusinessClass.FIELD_ObjectLastModified) ||
                    !tl_clientPSet.containsAttrib(Client.FIELD_ClientName)||
                    !tl_clientPSet.containsAttrib(Client.FIELD_ClientLogo)||
                    !tl_clientPSet.containsAttrib(Client.FIELD_Email)||
                    !tl_clientPSet.containsAttrib(Client.FIELD_ContactName)||
                    !tl_clientPSet.containsAttrib(Client.FIELD_ContactSurname)||
                    !tl_clientPSet.containsAttrib(Client.FIELD_Phone)||
                    !tl_clientPSet.containsAttrib(Client.FIELD_State)||
                    !tl_clientPSet.containsAttrib(Client.FIELD_Country)||
                    !tl_clientPSet.containsAttrib(Client.FIELD_PostCode)||
                    !tl_clientPSet.containsAttrib(Client.FIELD_City)||
                    !tl_clientPSet.containsAttrib(Client.FIELD_TimeZone)||
                    !tl_clientPSet.containsAttrib(Client.SINGLEREFERENCE_HiringTeam)||
                    !tl_clientPSet.containsAttrib(Client.SINGLEREFERENCE_Company))
            {
                // We will need to retrieve it
                idsToFetch.add (id.longValue());
            }
            else
            {
                LogMgr.log (ClientPersistence, LogLevel.DEBUG2, "Persistent set preloaded id:", id);
        
                /* Non Polymorphic */
                Client result = new Client ();

                result.setFromPersistentSets(id, allPSets);
                context.addRetrievedObject(result);

                results.add (result);
            
            }
        }

        if (idsToFetch.size () > 0)
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_client " +
                            "WHERE " + SELECT_JOINS + "{PREFIX}tl_client.object_id IN ?";

            BaseBusinessClass[] resultsFetched = loadQuery (allPSets, sqlMgr, context, query, new Object[] { idsToFetch }, null, false);

            for (BaseBusinessClass objFetched : resultsFetched)
            {
                results.add (objFetched);
            }
        }


        return results;
    }



    public BaseBusinessClass[] getReferencedObjects(ObjectID _objectID, String refName, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        if (false)
        {
            throw new RuntimeException ();
        }
        else if (refName.equals (Client.SINGLEREFERENCE_HiringTeam))
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_client " +
                            "WHERE " + SELECT_JOINS + "hiring_team_id = ?";

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, new Object[] { _objectID.longID () }, null, false);

            return results;
        }
        else if (refName.equals (Client.SINGLEREFERENCE_Company))
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_client " +
                            "WHERE " + SELECT_JOINS + "company_id = ?";

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, new Object[] { _objectID.longID () }, null, false);

            return results;
        }
        else
        {
            throw new IllegalArgumentException ("Illegal reference type:" + refName);
        }
    }



    public void update(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        EqualityResult  test = EqualityResult.compare (obj, obj.getBackup ());
        ObjectID        objectID = obj.getID ();

        if (!test.areAttributesEqual () || !test.areSingleAssocsEqual () || obj.getForcedSave())
        {
            PersistentSet tl_clientPSet = allPSets.getPersistentSet(objectID, "tl_client");
            

            
            if (tl_clientPSet.getStatus () != PersistentSetStatus.PROCESSED &&
                tl_clientPSet.getStatus () != PersistentSetStatus.DEFERRED)
            {
                int rowsUpdated = executeStatement (sqlMgr, 
                                                           "UPDATE {PREFIX}tl_client " +
                                                           "SET client_name = ?, client_logo = ?, email = ?, contact_name = ?, contact_surname = ?, phone = ?, state = ?, country = ?, post_code = ?, city = ?, time_zone = ?, hiring_team_id = ? , company_id = ?  , object_LAST_UPDATED_DATE = " + sqlMgr.getPortabilityServices ().getTimestampExpression () + " " +
                                                                
                                                           "WHERE tl_client.object_id = ? AND " + getConcurrencyCheck (sqlMgr, "object_LAST_UPDATED_DATE", obj.getObjectLastModified ()) + " ",
                                                           CollectionUtils.listEntry (HELPER_ClientName.getForSQL(dummyClientName, tl_clientPSet.getAttrib (Client.FIELD_ClientName))).listEntry (HELPER_ClientLogo.getForSQL(dummyClientLogo, tl_clientPSet.getAttrib (Client.FIELD_ClientLogo))).listEntry (HELPER_Email.getForSQL(dummyEmail, tl_clientPSet.getAttrib (Client.FIELD_Email))).listEntry (HELPER_ContactName.getForSQL(dummyContactName, tl_clientPSet.getAttrib (Client.FIELD_ContactName))).listEntry (HELPER_ContactSurname.getForSQL(dummyContactSurname, tl_clientPSet.getAttrib (Client.FIELD_ContactSurname))).listEntry (HELPER_Phone.getForSQL(dummyPhone, tl_clientPSet.getAttrib (Client.FIELD_Phone))).listEntry (HELPER_State.getForSQL(dummyState, tl_clientPSet.getAttrib (Client.FIELD_State))).listEntry (HELPER_Country.getForSQL(dummyCountry, tl_clientPSet.getAttrib (Client.FIELD_Country))).listEntry (HELPER_PostCode.getForSQL(dummyPostCode, tl_clientPSet.getAttrib (Client.FIELD_PostCode))).listEntry (HELPER_City.getForSQL(dummyCity, tl_clientPSet.getAttrib (Client.FIELD_City))).listEntry (HELPER_TimeZone.getForSQL(dummyTimeZone, tl_clientPSet.getAttrib (Client.FIELD_TimeZone))).listEntry (SQLManager.CheckNull((Long)(tl_clientPSet.getAttrib (Client.SINGLEREFERENCE_HiringTeam)))).listEntry (SQLManager.CheckNull((Long)(tl_clientPSet.getAttrib (Client.SINGLEREFERENCE_Company)))).listEntry (objectID.longID ()).listEntry (obj.getObjectLastModified ()).toList().toArray());

                if (rowsUpdated != 1)
                {
                    // Error, either a concurrency error or a not-exists error
                    ResultSet r = executeQuery (sqlMgr, 
                                                       "SELECT object_id, object_LAST_UPDATED_DATE FROM {PREFIX}tl_client WHERE object_id = ?",
                                                       new Object[] { objectID.longID () });

                    if (r.next ())
                    {
                        Date                d = new java.util.Date (r.getTimestamp (2).getTime());
                        String              errorMsg = QueryBuilder.buildQueryString ("Concurrent update error:[?] for row:[?] objDate:[?] dbDate:[?]", 
                                                                         new Object[] { "tl_client", objectID.longID (), obj.getObjectLastModified (), d },
                                                                         sqlMgr.getPortabilityServices ());
                                                                         
                        LogMgr.log (ClientPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new ConcurrentUpdateConflictException (obj, "tl_client");
                    }
                    else
                    {
                        String  errorMsg = "Attempt to update nonexistent row in table:tl_client for row:" + objectID + " objDate:" + obj.getObjectLastModified ();

                        LogMgr.log (ClientPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new RuntimeException (errorMsg);
                    }
                }

                tl_clientPSet.setStatus (PersistentSetStatus.PROCESSED);
            }
            
        }
        else
        {
            LogMgr.log (ClientPersistence, LogLevel.DEBUG1, "Skipping update since no attribs or simple assocs changed on ", objectID);
        }
    }



    public void delete(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        ObjectID        objectID = obj.getID ();
        PersistentSet tl_clientPSet = allPSets.getPersistentSet(objectID, "tl_client");
        

        LogMgr.log (ClientPersistence, LogLevel.DEBUG2, "Deleting:", objectID);

        
        if (tl_clientPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_clientPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            int rowsDeleted = executeStatement (sqlMgr, 
                                                       "DELETE " +
                                                       "FROM {PREFIX}tl_client " +
                                                       "WHERE tl_client.object_id = ? AND " + sqlMgr.getPortabilityServices ().getTruncatedTimestampColumn ("object_LAST_UPDATED_DATE") + " = " + sqlMgr.getPortabilityServices ().getTruncatedTimestampParam("?") + " ",
                                                       new Object[] { objectID.longID(), obj.getObjectLastModified () });

            if (rowsDeleted != 1)
            {
                // Error, either a concurrency error or a not-exists error
                ResultSet r = executeQuery (sqlMgr, 
                                                   "SELECT object_id FROM {PREFIX}tl_client WHERE object_id = ?",
                                                   new Object[] { objectID.longID() });

                if (r.next ())
                {
                    throw new ConcurrentUpdateConflictException (obj, "tl_client");
                }
                else
                {
                    String  errorMsg = "Attempt to delete nonexistent row in table:tl_client for row:" + objectID;

                    LogMgr.log (ClientPersistence, LogLevel.SYSTEMERROR1, errorMsg);
                    throw new RuntimeException (errorMsg);
                }
            }

            tl_clientPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }


    public ResultSet executeSearchQueryAll (SQLManager sqlMgr) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryAll");
    }
    



    public BaseBusinessClass[] loadQuery (PersistentSetCollection allPSets, SQLManager sqlMgr, RDBMSPersistenceContext context, String query, Object[] params, Integer maxRows, boolean truncateExtra) throws SQLException, StorageException
    {
        LinkedHashMap<ObjectID, Client> results = new LinkedHashMap ();
        
        ResultSet   r = executeQuery (sqlMgr, query, params);

        while (r.next())
        {
            ThreadUtils.checkInterrupted ();
            
            ObjectID    objectID = new ObjectID (Client.REFERENCE_Client.getObjectIDSpace (), r.getLong ("id"));
            Client resultElement;

            if (maxRows != null && !results.containsKey (objectID) && results.size () >= maxRows)
            {
                if (truncateExtra)
                {
                    break;
                }
                else
                {
                    throw new SearchRowsExceededException ("Maximum rows exceeded:" + maxRows);
                }
            }

            if (context.containsObject(objectID))
            {
                BaseBusinessClass   cachedElement = context.getObjectToReplace(objectID, Client.REFERENCE_Client);

                if (cachedElement instanceof Client)
                {
                    LogMgr.log (ClientPersistence, LogLevel.TRACE, "Cache hit for id:", objectID);
                    resultElement = (Client)cachedElement;
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + objectID + " with object " + cachedElement + "while fetching a Client");
                }
            }
            else
            {
                PersistentSet tl_clientPSet = allPSets.getPersistentSet(objectID, "tl_client", PersistentSetStatus.FETCHED);
                
                createPersistentSetFromRS(allPSets, r, objectID);

                

                        resultElement = new Client ();

                        resultElement.setFromPersistentSets(objectID, allPSets);
                        context.addRetrievedObject(resultElement);

                
            }

            results.put (objectID, resultElement);
        }

        

        BaseBusinessClass[] resultsArr = new BaseBusinessClass[results.size ()];

        return results.values ().toArray (resultsArr);
    }



    public BaseBusinessClass[] find(String searchType, PersistentSetCollection allPSets, Hashtable criteria, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        LogMgr.log (ClientPersistence, LogLevel.DEBUG2, "Search executing:", searchType, " criteria:", criteria);
        String  customParamFilter = (String)criteria.get (SEARCH_CustomFilter);
        String  customOrderBy = (String)criteria.get (SEARCH_OrderBy);
        String  customTables = (String)criteria.get (SEARCH_CustomExtraTables);
        Boolean  noCommaBeforeCustomExtraTables = (Boolean)criteria.get (SEARCH_CustomExtraTablesNoComma);

        if (searchType.equals (SEARCH_CustomSQL))
        {
            Set<ObjectID>                     processedIDs = new HashSet();
            SearchParamTransform    tx = new SearchParamTransform (criteria);
            Object[]                searchParams;

            customParamFilter = StringUtils.replaceParams (customParamFilter, tx);
            searchParams = tx.getParamsArray();

            if (customOrderBy != null) 
            {
                customOrderBy = " ORDER BY " + customOrderBy;
            }
            else
            {
                customOrderBy = "";
            }


            ResultSet   r;
            String      concatCustomTableWith = CollectionUtils.equals(noCommaBeforeCustomExtraTables, true) ?  " " : ", ";
            String      tables = StringUtils.subBlanks(customTables) == null ? " " : concatCustomTableWith + customTables + " ";


            String  query = "SELECT " + SELECT_COLUMNS +
                                    "FROM {PREFIX}tl_client " + tables +
                                    "WHERE " + SELECT_JOINS + " " + customParamFilter + customOrderBy;

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, null, false);

            return results;
        }
        else if (searchType.equals (Client.SEARCH_All))
        {
            // Local scope for transformed variables
            {
                
            }


            
                String      orderBy = " ORDER BY tl_client.object_id";
                String      tables = " ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: tl_client.object_id is not null
                    String preFilter = "(tl_client.object_id is not null)"
                                     + "  ";
                    
                    
                    preFilter += context.getLoadingAttributes ().getCustomSQL() ;
                    
                    SearchParamTransform tx = new SearchParamTransform (criteria);
                    
                    filter = StringUtils.replaceParams (preFilter, tx);
                    searchParams = tx.getParamsArray();
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}tl_client " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        
        else
        {
            throw new IllegalArgumentException ("Illegal search type:" + searchType);
            
            
        }
    }

    private void createPersistentSetFromRS(PersistentSetCollection allPSets, ResultSet r, ObjectID objectID) throws SQLException
    {
        PersistentSet tl_clientPSet = allPSets.getPersistentSet(objectID, "tl_client", PersistentSetStatus.FETCHED);
        
            // Object Modified
            tl_clientPSet.setAttrib(BaseBusinessClass.FIELD_ObjectLastModified, r.getTimestamp ("LAST_UPDATED_DATE"));

            // Object Created
            tl_clientPSet.setAttrib(BaseBusinessClass.FIELD_ObjectCreated, r.getTimestamp ("CREATED_DATE"));

        tl_clientPSet.setAttrib(Client.FIELD_ClientName, HELPER_ClientName.getFromRS(dummyClientName, r, "client_name"));
        tl_clientPSet.setAttrib(Client.FIELD_ClientLogo, HELPER_ClientLogo.getFromRS(dummyClientLogo, r, "client_logo"));
        tl_clientPSet.setAttrib(Client.FIELD_Email, HELPER_Email.getFromRS(dummyEmail, r, "email"));
        tl_clientPSet.setAttrib(Client.FIELD_ContactName, HELPER_ContactName.getFromRS(dummyContactName, r, "contact_name"));
        tl_clientPSet.setAttrib(Client.FIELD_ContactSurname, HELPER_ContactSurname.getFromRS(dummyContactSurname, r, "contact_surname"));
        tl_clientPSet.setAttrib(Client.FIELD_Phone, HELPER_Phone.getFromRS(dummyPhone, r, "phone"));
        tl_clientPSet.setAttrib(Client.FIELD_State, HELPER_State.getFromRS(dummyState, r, "state"));
        tl_clientPSet.setAttrib(Client.FIELD_Country, HELPER_Country.getFromRS(dummyCountry, r, "country"));
        tl_clientPSet.setAttrib(Client.FIELD_PostCode, HELPER_PostCode.getFromRS(dummyPostCode, r, "post_code"));
        tl_clientPSet.setAttrib(Client.FIELD_City, HELPER_City.getFromRS(dummyCity, r, "city"));
        tl_clientPSet.setAttrib(Client.FIELD_TimeZone, HELPER_TimeZone.getFromRS(dummyTimeZone, r, "time_zone"));
        
        tl_clientPSet.setAttrib(Client.SINGLEREFERENCE_HiringTeam, r.getObject ("hiring_team_id"));
        tl_clientPSet.setAttrib(Client.SINGLEREFERENCE_Company, r.getObject ("company_id"));
        
    }


    public void create(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        ObjectID    objectID = obj.getID ();
        PersistentSet tl_clientPSet = allPSets.getPersistentSet(objectID, "tl_client");
        

        
        if (tl_clientPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_clientPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            executeStatement (sqlMgr, 
                                     "INSERT INTO {PREFIX}tl_client " +
                                     "  (client_name, client_logo, email, contact_name, contact_surname, phone, state, country, post_code, city, time_zone,  hiring_team_id, company_id,  object_id, object_LAST_UPDATED_DATE, object_CREATED_DATE) " +
                                     "VALUES " +
                                     "  (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,  ?, ?,   ?,  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ",  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ")",
                                     CollectionUtils.listEntry (HELPER_ClientName.getForSQL(dummyClientName, tl_clientPSet.getAttrib (Client.FIELD_ClientName))).listEntry (HELPER_ClientLogo.getForSQL(dummyClientLogo, tl_clientPSet.getAttrib (Client.FIELD_ClientLogo))).listEntry (HELPER_Email.getForSQL(dummyEmail, tl_clientPSet.getAttrib (Client.FIELD_Email))).listEntry (HELPER_ContactName.getForSQL(dummyContactName, tl_clientPSet.getAttrib (Client.FIELD_ContactName))).listEntry (HELPER_ContactSurname.getForSQL(dummyContactSurname, tl_clientPSet.getAttrib (Client.FIELD_ContactSurname))).listEntry (HELPER_Phone.getForSQL(dummyPhone, tl_clientPSet.getAttrib (Client.FIELD_Phone))).listEntry (HELPER_State.getForSQL(dummyState, tl_clientPSet.getAttrib (Client.FIELD_State))).listEntry (HELPER_Country.getForSQL(dummyCountry, tl_clientPSet.getAttrib (Client.FIELD_Country))).listEntry (HELPER_PostCode.getForSQL(dummyPostCode, tl_clientPSet.getAttrib (Client.FIELD_PostCode))).listEntry (HELPER_City.getForSQL(dummyCity, tl_clientPSet.getAttrib (Client.FIELD_City))).listEntry (HELPER_TimeZone.getForSQL(dummyTimeZone, tl_clientPSet.getAttrib (Client.FIELD_TimeZone))) .listEntry (SQLManager.CheckNull((Long)(tl_clientPSet.getAttrib (Client.SINGLEREFERENCE_HiringTeam)))).listEntry (SQLManager.CheckNull((Long)(tl_clientPSet.getAttrib (Client.SINGLEREFERENCE_Company)))) .listEntry (objectID.longID ()).toList().toArray());

            tl_clientPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }
}
