import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from '../../../../environments/environment';
import { ApiService } from '../../../oneit/services/api.service';

@Injectable()
export class AuthService {

    env = environment.envName;

    constructor(
        private as: ApiService
    ) {
    }

    login(formData): Observable<any> {
        formData.environment = this.env;

        return this.as.post('svc/Login', formData);
    }

    googleLogin(formData = {} as any): Observable<any> {
        formData.environment = this.env;

        return this.as.post('svc/LoginWithGoogle', formData);
    }

    linkedinLogin(formData = {} as any): Observable<any> {
        formData.environment = this.env;

        return this.as.post('svc/LoginWithGoogle', formData);
    }

    forgot(formData): Observable<any> {
        formData.environment = this.env;

        return this.as.post('svc/RequestPasswordReset', formData);
    }

    register(formData): Observable<any> {
        formData.environment = this.env;

        return this.as.post('svc/RegisterMyCareerUser', formData);
    }

    reset(formData): Observable<any> {
        formData.environment = this.env;

        return this.as.post('svc/PasswordChange', formData);
    }

    logout(formData = {} as any): Observable<any> {
        formData.environment = this.env;

        return this.as.post('svc/Logout', formData);
    }

}
