<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>
<%@page import="oneit.utils.text.FormatUtils"%>

<oneit:dynIncluded>
<%
    Job                     job             =   (Job) process.getAttribute("Job");
    List<JobApplication>    applications    =   (List<JobApplication>) getData(request, "applications");

    String          applicationPage =   WebUtils.getSamePageInRenderMode(request, WebUtils.VIEW_APPLICATION);
    String          currentPage     =   WebUtils.getSamePageInRenderMode(request, WebUtils.VIEW_APPLICANTS_GRID);

%>

    <script type="text/javascript">
        $(document).ready(function()
        {
            $('.grid-box-view').slick({
                dots: false,
                infinite: false,
                speed: 300,
                slidesToShow: 5,    
                nextArrow: "<div class='sl_width slider-next'><span><img src='images/slider-arrow.png' /></span></div>",
                prevArrow: "<div class='sl_width slider-prev'><span><img src='images/slider-arrow-left.png' /></span></div>",
                responsive: [
                {
                  breakpoint: 1280,
                  settings: {
                    slidesToShow: 4
                  }
                },
                {
                  breakpoint: 1024,
                  settings: {
                    slidesToShow: 3
                  }
                },
                {
                  breakpoint: 600,
                  settings: {
                    slidesToShow: 2
                  }
                },
                {
                  breakpoint: 480,
                  settings: {
                    slidesToShow: 1
                  }
                }
              ]
            });
            
            recalcFunction = setupRecalc ($("form#viewApplicants"), {'recalcOnError':true});
        });
    </script>

    <div class="five-boxs grid-box-view" style="">
        <%
            int i   = 0;

            for(JobApplication jobApplication : applications)
            {
                Candidate   candidate   =   jobApplication.getCandidate();
                String      appID       =   "app-id-" + jobApplication.getID().toString();
                Integer     overallRank =   jobApplication.getOverallRank();
                Boolean     isTopRank   =   CollectionUtils.equals(overallRank, 1);
        %>
                <div class="<%= "appl-c-box " + (i == 0 ? " cb-one" : "")%> ">
                    <!--TODO: need to work on the logic. just added to demonstrate that there are 3 different colors for this-->
                    <div class="cb-title dark-back ">
                        <div class="checkbox-list grid-checkbox">
                            <div class="checkbox-list">
                                <input type="checkbox"  name="IsSelected" value="<%= jobApplication.getObjectID().toString() %>"  id="<%= appID %>" class="applicant" >
                                <label for="<%= appID %>">
                                    <oneit:toString value="<%= candidate %>"    mode="EscapeHTML" />
                                </label>
                            </div>
                        </div>
                    </div>
                    <oneit:button   value=" "   name="gotoPage" skin="link"
                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", applicationPage)
                                                                    .mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).mapEntry("Applications", applications).toMap())
                                                                    .toMap() %>">
                        <div class="overall-suitablity grid-suitability">
                            <div class="<%= "over-all blue " + (isTopRank ? "f-60" : "")%>">
                                <oneit:toString value="<%= overallRank %>"   mode="Integer" />
                            </div>
                            <div class="<%= "overall " + (isTopRank ? "f-60" : "")%>">overall rank</div>
                        </div>
                        <div class="jcc-box">
                            <div class="job-match jcc">
                                <img src="images/app-job-match-icon.svg"> Role fit 
                                <%
                                    if(!job.isExpressJob())
                                    {
                                %>
                                        <span><oneit:toString value="<%= jobApplication.getRoleFitPercentage() %>"  mode="PercentageTwoDP" /></span>
                                <%
                                    }
                                %>
                            </div>

                            <%
                                if(job.isExpressJob())
                                {
                                    Map<FactorClass, Map<FactorLevelLink, Map>> factorClassDtls =   (Map<FactorClass, Map<FactorLevelLink, Map>>) jobApplication.getFactorScoreDetails();

                                    for(FactorClass factorClass : factorClassDtls.keySet())
                                    {
                                        if(factorClass != null)
                                        {
                            %>
                                            <div class="detail-box ja-exp-b-p">
                                                <div class="detail-row">
                                                    <div class="detail-label ja-exp-fact-c">
                                                        <oneit:toString   value="<%= factorClass %>"    mode="EscapeHTML"/>
                                                    </div>
                                                </div>   
                                            </div>
                            <%
                                            Map<FactorLevelLink, Map>   factorDetails   =   factorClassDtls.get(factorClass);

                                            for(FactorLevelLink factorLevelLink : factorDetails.keySet())
                                            {
                                                Map factorLinkDetails   =   factorDetails.get(factorLevelLink);

                                                if(!factorLinkDetails.isEmpty())
                                                {
                                                    FactorScore factorScore =   (FactorScore) factorLinkDetails.get("factorScore");
                            %>
                                                <div class="detail-box ja-exp-f-box">
                                                    <div class="detail-row">
                                                        <div class="detail-label">
                                                            <oneit:toString value="<%= factorLevelLink.getFactor() %>"  mode="EscapeHTML"/>
                                                        </div>
                                                        <div class="detail-no">
                                                            <oneit:toString  value="<%= factorScore.getScore() %>"      mode="WholeNumber"/>
                                                        </div>
                                                    </div> 
                                                </div>
                                                <div class="detail-box ja-exp-f-b-b">
                                                </div>
                            <%
                                                }
                                            }
                            %>
                                            <div class="detail-box ja-exp-f-c-b-b">
                                            </div>
                            <%
                                        } 
                                    }
                                }
                                else
                                {
                            %>
                                    <div class="detail-box">
                            <%
                                        Map<FactorClass, Tuple.T3<Double, ColorCode, Double>>   roleScoreMap    =   (Map<FactorClass, Tuple.T3<Double, ColorCode, Double>>)jobApplication.getRoleFit();

                                        for(FactorClass factorClass : jobApplication.getSortedFactorClasses())
                                        {
                                            if(factorClass != null && roleScoreMap.get(factorClass) != null)
                                            {
                            %>  
                                            <div class="detail-row">
                                                <div class="detail-label">
                                                    <oneit:toString   value="<%= factorClass %>"    mode="EscapeHTML"/>
                                                </div>
                                                <div class="detail-no">
                                                    <oneit:toString  value="<%= roleScoreMap.get(factorClass).get2() %>"    mode="PercentageWholeNumber"/>
                                                </div>
                                            </div>   
                            <%
                                            }
                                        }
                            %>
                                    </div>
                            <%
                                }
                            %>
                            <div class="culture jcc">
                                <img src="images/culture-icon.svg"> culture fit
                                <span>
                                    <oneit:button   value=" "   name="gotoPage" skin="link"
                                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", applicationPage)
                                                                                    .mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).toMap())
                                                                                    .toMap() %>">
                                        <oneit:toString value="<%= jobApplication.getCultureFitScore() %>"  mode="PercentageWholeNumber" />
                                    </oneit:button>
                                </span>
                            </div>
                            <div class="detail-box">
                                <%
                                    Map<CultureClass, Tuple.T2<Long, Set<Tuple.T3>>>    cultureFitData  =   (Map<CultureClass, Tuple.T2<Long, Set<Tuple.T3>>>)jobApplication.getCultureFit();

                                    for(CultureClass cClass: cultureFitData.keySet())
                                    {
                                        if(cClass==null)
                                        {
                                            continue;
                                        }
                                %>
                                        <div class="detail-row">
                                            <div class="detail-label"><oneit:toString   value="<%= cClass %>"   mode="EscapeHTML"/></div>
                                            <div class="detail-no"><oneit:toString    value="<%= cultureFitData.get(cClass) != null ? cultureFitData.get(cClass).get0() : 0 %>"   mode="PercentageWholeNumber" /></div>
                                        </div>
                                <%
                                    }
                                %>
                            </div>
                        <%
                            if(job.getIncludeAssessmentCriteria()==Boolean.TRUE)
                            {
                        %>
                                <div class="jcc">
                                    <img src="images/criteria-icon.svg"> Requirements 
                                    <span>
                                        <oneit:button   value=" "   name="gotoPage" skin="link"
                                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", applicationPage)
                                                                                        .mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).toMap())
                                                                                        .toMap() %>">
                                            <oneit:toString value="<%= jobApplication.getRequirementFitScore() %>"   mode="PercentageWholeNumber" />
                                        </oneit:button>
                                    </span>
                                </div>
                                <div class="detail-box">
                                <%
                                    Map<Importance, Long>   requirementFitData  =   (Map<Importance, Long>)jobApplication.getRequirementFit();

                                    for(Importance importance: Utils.getImportancesForAssessment())
                                    {
                                %>
                                        <div class="detail-row">
                                            <div class="detail-label"><oneit:toString   value="<%= importance %>"   mode="EscapeHTML"/></div>
                                            <div class="detail-no"><oneit:toString    value="<%= requirementFitData.get(importance) %>"   mode="PercentageWholeNumber" /></div>
                                        </div>
                                <%
                                    }
                                %>
                                </div>
                        <%
                            }
                        %>
                        </div>
                    </oneit:button>
                </div>
        <%
                i++;
            }
        %>
    </div>
</oneit:dynIncluded>