<%@ page extends="oneit.servlets.jsp.JSPInclude" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>
<%@ page import="oneit.utils.text.FormatUtils"%>

<oneit:dynIncluded>
<div class="main-application-outline">
<%
    ObjectTransaction   objTran         =   process.getTransaction ();
    String              nextPage        =   WebUtils.getSamePageInRenderMode(request, "SelectionCriteria");
    
    boolean             toRedirect      =   GenericObjDF.getOrCreateObject (request, "Job", Job.REFERENCE_Job);
    Job                 job             =   (Job) process.getAttribute("Job");

    Debug.assertion(job != null && !toRedirect, "Invalid job in applicant portal");
    
    SecUser             secUser         =   SecUser.getTXUser(transaction);
    Candidate           candidate       =   secUser.getExtension(Candidate.REFERENCE_Candidate);
    
    Debug.assertion(candidate != null, "Invalid candidate in applicant portal");
    
    JobApplication      jobApplication  =   JobApplication.searchCandidateJob(objTran, candidate, job);

    if(jobApplication == null)
    {
        jobApplication  =   JobApplication.createNewApplication(candidate, job);
    }
    
//    //to store already completed culture or role data
//    Boolean alreadyCompletedCulture =   (Boolean) process.getAttribute("AlreadyCompletedCulture");
//    Boolean alreadyCompletedRole    =   (Boolean) process.getAttribute("AlreadyCompletedRole");
//    
//    if(alreadyCompletedCulture==null)
//    {
//        alreadyCompletedCulture =   jobApplication.getAlreadyCompletedApplicationForCulture()!=null;
//        process.setAttribute("AlreadyCompletedCulture", alreadyCompletedCulture);
//    }
//    
//    if(alreadyCompletedRole==null)
//    {
//        alreadyCompletedRole    =   jobApplication.getAlreadyCompletedApplicationForRole()!=null;
//        process.setAttribute("AlreadyCompletedRole", alreadyCompletedRole);
//    }
    
    Boolean isSelectionComplete     =   jobApplication.selectionCompleted();
    Boolean isCultureComplete       =   jobApplication.cultureCompleted();
    Boolean isAssesmentComplete     =   jobApplication.assessmentCompleted();
    
        
    if(!jobApplication.isIncludeAssessmentCriteria())
    {
        if(!isCultureComplete)
        {
            nextPage    =   WebUtils.getSamePageInRenderMode(request, "WorkplaceCulture");
        }
        else if(!isAssesmentComplete)
        {
            nextPage    =   WebUtils.getSamePageInRenderMode(request, "JobMatchAssessment");
        }
    }
    else
    {
        if(!isSelectionComplete)
        {
            nextPage    =   WebUtils.getSamePageInRenderMode(request, "SelectionCriteria");
        }
        else if(!isCultureComplete)
        {
            nextPage    =   WebUtils.getSamePageInRenderMode(request, "WorkplaceCulture");
        }
        else if(!isAssesmentComplete)
        {
            nextPage    =   WebUtils.getSamePageInRenderMode(request, "JobMatchAssessment");
        }
    }
    
    process.setAttribute("JobApplication", jobApplication);
%>
        <div class="welcome-aust-logo">
            <%
                if(job.getClient() != null)
                {
                    int logoWidth   =   45;
            %>
                    <tagfile:img src="<%= ThumbnailUtils.filterImage(DiskFileBinaryContent.getRelativeURL(job.getClient().getClientLogo()), "KEEP", new ScaleWithin (logoWidth, 0)) %>" />
            <%
                }
            %>
        </div>
        <div class="welcome-title">Welcome <oneit:toString value="<%= candidate.getFirstName() %>"/>, here's your application outline</div>
        <div class="appli-aust-title">
            <oneit:toString value="<%= job.getJobTitle() %>"  mode="EscapeHTML"/>
        </div>
        <p class="appli-content">
            <oneit:toString value="<%= job.getJobDescription() %>"  mode="ParagraphHTML"    nullValue="-"/>
        </p>
        <div class="three-block">
            <%
                if(job.getIncludeAssessmentCriteria())
                {
            %>
                    <div class="col-sm-4 col-xs-12 app-block eq-height">
                        <div class="block-icon <%= isSelectionComplete ? "app-outline-complete" : "" %>">
                            <div class="<%= isSelectionComplete ? "app-outline-complete-icon" : "app-outline-selection-icon" %>"></div>
                        </div>
                        <div class="app-block-title">Your experience</div>
                        <div class="estimated-time">
                            <%
                                if(isSelectionComplete)
                                {
                            %>
                                    <span>Completed</span>
                            <%
                                }
                                else
                                {
                            %>
                                    Estimated time to complete: <span>5 mins</span>
                            <%
                                }
                            %>
                        </div>
                        <p>
                            Lorem ipsum dolor sit amet,
                            consectetur adipiscing elit. Aenean
                            semper at magna a tristique. Ut ut
                            magna ut mauris sagittis placerat.
                            Suspendisse vitae tempus sem.
                        </p>
                    </div>
            <%
                }
            %>
            <div class="<%= (job.getIncludeAssessmentCriteria() ? "col-sm-4  app-second-block " : " col-sm-6 app-block " ) + " col-xs-12 app-block eq-height "%> ">
                <div class="block-icon <%= isCultureComplete ? "app-outline-complete" : "" %>">
                    <div class="<%= isCultureComplete ? "app-outline-complete-icon" : "app-outline-culture-icon" %>"></div>
                </div>
                <div class="app-block-title">Your preferences about where you work</div>
                <div class="estimated-time">
                    <%
                        if(isCultureComplete)
                        {
                    %>
                            <span>Completed</span>
                    <%
                        }
                        else
                        {
                    %>
                            Estimated time to complete: <span>5 mins</span>
                    <%
                        }
                    %>
                </div>
                <p>
                    Lorem ipsum dolor sit amet,
                    consectetur adipiscing elit. Aenean
                    semper at magna a tristique. Ut ut
                    magna ut mauris sagittis placerat.
                    Suspendisse vitae tempus sem.
                </p>
            </div>
            <div class="<%= (job.getIncludeAssessmentCriteria() ? "col-sm-4 " : "col-sm-6 app-thired-block " ) + "col-xs-12 app-block eq-height last-border"%>">
                <div class="block-icon <%= isAssesmentComplete ? "app-outline-complete" : "" %>">
                    <div class="<%= isAssesmentComplete ? "app-outline-complete-icon" : "app-outline-assesmet-icon" %>"></div>
                </div>
                <div class="app-block-title">Your work preference and beliefs</div>
                <div class="estimated-time">
                    <%
                        if(isAssesmentComplete)
                        {
                    %>
                            <span>Completed</span>
                    <%
                        }
                        else
                        {
                    %>
                            Estimated time to complete: <span><oneit:toString value="<%= jobApplication.getRoleTestRemainingTime() %>"  mode="EscapeHTML"/> mins</span>
                    <%
                        }
                    %>
                </div>
                <p>
                    Lorem ipsum dolor sit amet,
                    consectetur adipiscing elit. Aenean
                    semper at magna a tristique. Ut ut
                    magna ut mauris sagittis placerat.
                    Suspendisse vitae tempus sem.
                </p>
            </div>
        </div>
    <%
        if(job.getJobStatus() == JobStatus.OPEN && jobApplication.getApplicationStatus()!= ApplicationStatus.SUBMITTED)
        {
            String  btnText =   "Resume the application";

            if(jobApplication.getStatus()==ObjectStatus.NEW)
            {
                btnText =   "Begin the application";
            }
    %>
            <oneit:form name="applyJob" method="post" enctype="multipart/form-data">
                <div class="app-out-btn">
                    <span>
                        <%
                            if(!(isSelectionComplete && isCultureComplete && isAssesmentComplete))
                            {
                        %>
                                Total time to complete: Approximately <oneit:toString value="<%= jobApplication.getRemainingTime() %>"  mode="EscapeHTML"/> minutes
                        <%
                            }
                        %>
                    </span>
                    <%
                        if(isSelectionComplete && isCultureComplete && isAssesmentComplete)
                        {
                            nextPage    =   WebUtils.getSamePageInRenderMode(request, "SubmitApplication");
                    %>
                            <oneit:button   value="Submit your application"    name="completeApplication"  id="nextButton"  cssClass="box-btn"
                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                                .mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).toMap())
                                                                                .mapEntry("attribNamesToRestore", Collections.singleton("JobApplication"))
                                                                                .mapEntry("restartProcess", Boolean.TRUE)
                                                                                .toMap() %>"/>
                    <%
                        }
                        else
                        {
                    %>
                            <oneit:button   value="<%= btnText %>"  name="gotoPage" skin="link" cssClass="box-btn"
                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                            .mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).toMap())
                                                                            .toMap() %>"/>
                    <%
                        }
                    %>
                </div>
            </oneit:form>
    <%
        }
        else
        {
            String  infoStr =   "We're sorry, this job is no longer accepting applications";

            if(jobApplication.getApplicationStatus() == ApplicationStatus.SUBMITTED)
            {
                infoStr =   "You applied for this job on " + FormatUtils.stringify(jobApplication.getSubmittedDate(), "MidDate", "") ;
            }
    %>
            <div class="app-out-btn">
                <span></span>
                <span style="float: right"><oneit:toString value="<%= infoStr %>"  mode="EscapeHTML"/></span>
            </div>
    <%
        }
    %>

<style>
    .power-footer {
        background-color:#fff;
    }
</style>

</div>
</oneit:dynIncluded>